package com.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

import javax.annotation.PostConstruct;


/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/27 15:36
 * @description：入参字符串转枚举
 * @modified By：
 * @version: 1.0
 */
@Configuration
public class ConverterConfig {


    @Autowired
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;

    /**
     *
     */
    @PostConstruct
    public void addConverterConfig() {
        ConfigurableWebBindingInitializer initializer = (ConfigurableWebBindingInitializer) requestMappingHandlerAdapter.getWebBindingInitializer();
        if (initializer.getConversionService() != null) {
            GenericConversionService genericConversionService = (GenericConversionService) initializer.getConversionService();
            //添加游标转枚举
            genericConversionService.addConverterFactory(new MyConverterFactory());

        }
    }


    public class MyConverterFactory implements ConverterFactory<String, Enum> {
        @Override
        public <T extends Enum> Converter<String, T> getConverter(Class<T> aClass) {
            return new EnumConverter(aClass);
        }
    }

    public static class EnumConverter<T extends Enum> implements Converter<String, T> {
        private Class<T> enumType;

        public EnumConverter(Class<T> enumType) {
            this.enumType = enumType;
        }

        @Override
        public T convert(String source) {
            if (source.length() == 0) {
                return null;
            }
            return enumType.getEnumConstants()[Integer.parseInt(source)];
        }
    }

}
