package com.timer;

import com.config.ReportConfig;
import com.service.report.ReportService;
import com.util.DingTalk;
import com.util.IpUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/11/1 16:09
 * @description：上报定时器
 * @modified By：
 * @version: 1.0
 */
@Component
public class ReportTimer {
    @Autowired
    private ReportConfig reportConfig;

    @Autowired
    private DingTalk dingTalk;
    @Autowired
    private ReportService reportService;

    public static Map<String, Object> result = new ConcurrentHashMap();

    private static boolean isRun = false;
    private static boolean dayReportIsRunning = false;
    private static boolean monReportIsRunning = false;

    @PostConstruct
    public void init() {
        String localIP = IpUtil.getLocalIP();
        if (reportConfig.getTimerIp().equals(localIP)) {
            isRun = true;
        }
    }

    //每天凌晨2点
    @Scheduled(cron = "0  0  2  *  * ?")
    public void reportDayData() {
        if (!isRun) {
            return;
        }
        dayReportIsRunning = true;
        try {
            //上报日放款数据
            reportService.reportLoanDayData();
            //上报日还款数据
            reportService.reportRepayDayData();
            //上报日逾期数据
            reportService.reportOverDayData();
        } finally {
            dayReportIsRunning = false;
        }
        talk(result);

    }

    //每月1次
    @Scheduled(cron = "0 0 3 1 1/1 ?")
    void reportMonthData() {
        if (!isRun) {
            return;
        }
        monReportIsRunning = true;
        try {
            //上报月逾期数据
            reportService.reportOverMonthData();
        } finally {
            monReportIsRunning = false;
        }
        talk(result);
    }

    //一小时一次 延迟10秒
    @Scheduled(fixedDelay = 1000 * 60 * 60, initialDelay = 10000)
    public void quaryReportedStatus() {
        //测试先去掉这个限制
        if (!isRun) {
            return;
        }
        if (monReportIsRunning || dayReportIsRunning) {
            return;
        }
        reportService.quaryReportedStatus();
    }

    public void  talk(Map<String, Object> result){
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> ntry : result.entrySet()) {
            sb.append(ntry.getKey())
                    .append(ntry.getValue())
                    .append("\r\n");
        }
        dingTalk.talk("上报结果汇总", sb.toString());
        result.clear();
    }
}
