package cn.quantgroup.report.service.baihang.util;

import cn.quantgroup.report.service.baihang.response.FileUploadResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class TuoMinUtils {



    private static char getRandomChar() {
        String str = "";
        int hightPos; //
        int lowPos;
        Random random = new Random();
        hightPos = (176 + Math.abs(random.nextInt(39)));
        lowPos = (161 + Math.abs(random.nextInt(93)));
        byte[] b = new byte[2];
        b[0] = (Integer.valueOf(hightPos)).byteValue();
        b[1] = (Integer.valueOf(lowPos)).byteValue();
        try {
            str = new String(b, "GBK");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println("错误");
        }
        return str.charAt(0);
    }

    private static String getRandomNum(int length) {
        StringBuffer buff = new StringBuffer();
        Random random = new Random();
        for (int i=0;i<length;i++){
            // 返回一个0~(指定数-1)之间的随机值
            int ran = random.nextInt(10);
            buff.append(ran);
        }
        return buff.toString();
    }

    public static String random_name(String name) {
        /*姓名脱敏
        保证为汉字，如张三丰脱敏为张无忌、张艺兴，均符合要求。
        避免使用张某、赵某等，容易出现编码校验失败问题。*/
        return name.substring(0,1)+getRandomChar()+getRandomChar();
    }


    public static String random_idcard(String idcard) {
        /*身份证脱敏
        需满足以下条件：
        1.身份证前两位数字（即省份代码）需为以下34个数字之一：11,12,13,14,15,21,22,23,31,32,33,34,35,36,37,41,42,43,44,45,46,50,51,52,53,54,61,62,63,64,65,71,81,82
        2.身份证中的年月日需为现实中存在的日期
        如360822198305022623脱敏：*/
        return idcard.substring(0,2) + getRandomNum(4) + idcard.substring(6,14) + getRandomNum(4);
    }

    public static String random_mobile(String mobile) {
        return mobile.substring(0,3) + getRandomNum(4) + mobile.substring(7,11);
    }


    public static boolean checkEmail(String email) {
        //电子邮件
        if(StringUtils.isBlank(email)){
            return false;
        }
        String regex =  "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9]+(-[a-z0-9]+)?\\.)+[a-z]{2,}$";
        //"^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$"
        //"^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$"
        //"^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$"
        boolean b1 =  Pattern.compile(regex).matcher(email).matches(); //email.matches(email);

        String ends = "";
        if(email.contains("@")){
            ends = email.substring(email.lastIndexOf("@"), email.length());
        }

        boolean b2 = Pattern.compile("\\s+").matcher(ends).find();;

        String regex2 =".*[A-Z]+.*"; //"[A-Z]*"
        boolean b3 =  Pattern.compile(regex2).matcher(ends).matches();

        return b1 && !b2 && !b3;
    }

    //判断Email合法性
    public static boolean isEmail(String email) {
        if (email == null)
            return false;
        String rule = "[\\w!#$%&'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&'*+/=?^_`{|}~-]+)*@(?:[\\w](?:[\\w-]*[\\w])?\\.)+[\\w](?:[\\w-]*[\\w])?";

        Pattern pattern = Pattern.compile(rule);
        Matcher matcher = pattern.matcher(email);
        if (matcher.matches())
            return true;
        else
            return false;
    }

}
