package cn.quantgroup.report.controller;

import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.manualTool.ManualToolService;
import cn.quantgroup.report.service.renhang.UserOcrService;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@Slf4j
@RestController
@RequestMapping(value = "/manualtool")
public class ManualToolController {

  @Autowired
  private ManualToolService manualToolService;

  @Autowired
  private UserOcrService userOcrService;


  @RequestMapping("/deleteRedisKey")
  public Map<String,Object> deleteRedisKey(String key1, String key2, String key3){
    try{
      manualToolService.deleteRedisKey(key1, key2, key3);
      return ImmutableMap.of("code", 0, "msg", "手动删除redisKey成功");
    }catch(Exception e){
      return ImmutableMap.of("code", 1, "msg", "手动设置redisKey异常");
    }
  }

  @RequestMapping("/getRedisVal")
  public String getRedisVal(String key){
    try{
      return manualToolService.getRedisVal(key);
    }catch(Exception e){
      return "获取redis值异常";
    }
  }





  @RequestMapping("/synGrowingUser")
  public String synGrowingUser(String startnyr, String endnyr) {
    userOcrService.synGrowingUserOcr(startnyr, endnyr);

    return "synGrowingUser方法调度成功";
  }


  @RequestMapping("/synUserOcrByUuids")
  public String synUserOcrByUuids(String uuids) {
    if (StringUtils.isEmpty(uuids)) {
      return "参数为空";
    }
    userOcrService.synUserOcrByUuids(uuids);

    return "synUserOcrByUuids方法调度成功";
  }


  @RequestMapping("/synValidDateEndUserOcr")
  public String synValidDateEndUserOcr() {
    userOcrService.synValidDateEndUserOcr();
    return "synValidDateEndUserOcr方法调度成功";
  }


}
