package cn.quantgroup.report.service.usersdk.impl;

import cn.quantgroup.motan.bean.UserInfo;
import cn.quantgroup.motan.retbean.XUserFullInfo;
import cn.quantgroup.motan.vo.UserSysResult;
import cn.quantgroup.report.cmpt.CommonAlarmCmpt;
import cn.quantgroup.report.domain.sdk.SdkUser;
import cn.quantgroup.report.service.http.IHttpService;
import cn.quantgroup.report.service.usersdk.IUserCenterService;
import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

@Service
public class UserCenterServiceImpl implements IUserCenterService {
	
     private static final Logger LOGGER = LoggerFactory.getLogger(UserCenterServiceImpl.class);
	 @Autowired
	 @Qualifier("httpClient")
	 private CloseableHttpClient httpClient;
	 @Value("${user.sdk.url}")
	 private String userSysUrl;
	 private IUserSdkService userSdkService;
	 @Autowired
	 private CommonAlarmCmpt iMonitorAlarmService;

     @Value("${b.user.url}")
     private String bUserUrl;
     @Autowired
     private IHttpService iHttpService;
	 
	 @PostConstruct
	 private void init() {
		 userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
	 }
	

	@Override
	public SdkUser getSdkUserByPhoneNo(String phoneNo) {
		try{
			UserSysResult<UserInfo> findUserInfoByPhone = userSdkService.findUserInfoByPhone(phoneNo);
			SdkUser sdkUser = new SdkUser();
			if(findUserInfoByPhone.isSuccess()&&findUserInfoByPhone.getData()!=null){
				UserInfo data = findUserInfoByPhone.getData();
				BeanUtils.copyProperties(data, sdkUser);
				return sdkUser;
			}
		}catch(Exception e){
			LOGGER.error("查询用户用心异常，phoneNo: {} , {}",phoneNo,e);
			iMonitorAlarmService.alarm("WARN","用户中心查询异常告警","接口 : findUserInfoByPhone(phoneNo) ,  异常信息："+e.getMessage());
		}
		return null;
	}

	@Override
    public SdkUser getSdkUserByUuid(String uuid) {
        try{
            UserSysResult<UserInfo> findUserInfoByPhone = userSdkService.findUserInfoByUuid(uuid);
            SdkUser sdkUser = new SdkUser();
            LOGGER.info("用户中心查询uuid: {} , SDKUser结果：{}", uuid, findUserInfoByPhone);
            if(findUserInfoByPhone.isSuccess()&&findUserInfoByPhone.getData()!=null){
                UserInfo data = findUserInfoByPhone.getData();
                BeanUtils.copyProperties(data, sdkUser);
                return sdkUser;
            }
        }catch(Exception e){
            LOGGER.error("查询用户用心异常，uuid: {} , {}",uuid,e);
            iMonitorAlarmService.alarm("WARN","用户中心查询异常告警","接口 : findUserInfoByUuid(uuid) ,  异常信息："+e.getMessage());
        }
        return null;
    }


    @Override
    public String getUuidByPhoneNumber(String phoneNumber) {
	     if(StringUtils.isEmpty(phoneNumber)){
	         return null;
         }
        String uuid = null;
        try {
            SdkUser user = getSdkUserByPhoneNo(phoneNumber);
            if (user != null) {
                uuid = user.getUuid();
            }
        }catch (Exception e){
            LOGGER.error("查询用户用心异常，phoneNumber: {} , {}",phoneNumber,e);
        }
        return uuid;
    }

    @Override
    public SdkUser getUserFullInfoByUuid(String uuid) {
        try{
            if(StringUtils.isNotBlank(uuid)){
                if(uuid.startsWith("600_")){
                    return getBUserInfo(uuid);
                }else{
                    UserSysResult<XUserFullInfo> findUserInfoByPhone = userSdkService.findUserFullInfoByUuid(uuid);
                    SdkUser sdkUser = new SdkUser();
                    LOGGER.info("三方数据源查询用户中心用户全量信息结果, uuid: {} , result:{}", uuid, findUserInfoByPhone, JSON.toJSONString(findUserInfoByPhone));
                    if(findUserInfoByPhone.isSuccess()&&findUserInfoByPhone.getData()!=null){
                        XUserFullInfo data = findUserInfoByPhone.getData();
                        BeanUtils.copyProperties(data, sdkUser);
                        return sdkUser;
                    }
                }
            }else{
                LOGGER.error("三方数据源查询用户中心用户全量信息结果用户Id不正确, uuid: {} ", uuid);
            }

        }catch(Exception e){
            LOGGER.error("三方数据源查询用户中心用户全量信息结果用户异常，uuid:{}, {}",uuid,e);
        }
        return null;
    }

    public SdkUser getBUserInfo(String uuid){
        try{
            //bUserUrl = "http://192.168.29.45:9059/ex/user/query";//本地联调
            String bUserInfo = iHttpService.get(bUserUrl, ImmutableMap.of("uuid", uuid));
            LOGGER.info("外部渠道（B端）查询用户信息结果, uuid: {} ,result:{}", uuid, bUserInfo);
            if(StringUtils.isNotBlank(bUserInfo)){
                JSONObject jsonObject = JSON.parseObject(bUserInfo);
                Integer code = jsonObject.getInteger("code");
                if(0==code){
                    SdkUser sdkUser = new SdkUser();
                    JSONObject info = jsonObject.getJSONObject("body");
                    sdkUser.setPhoneNo(info.getString("phoneNo"));
                    sdkUser.setIdNo(info.getString("idNo"));
                    sdkUser.setName(info.getString("name"));
                    sdkUser.setUuid(uuid);

                    //2019.10.10 B端用户查询增加md5加密
                    sdkUser.setIdNoMd5(info.getString("idNoMd5"));
                    sdkUser.setPhoneNoMd5(info.getString("phoneNoMd5"));
                    return sdkUser;
                }
            }
        }catch(Exception e){
            LOGGER.error("外部渠道（B端）查询用户信息异常, uuid: {} ", uuid, e);
        }
        return null;
    }

}
