package cn.quantgroup.report.config.datasource.renhang;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: tidb中call_record日志表 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.12.30 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Import(RenHangDatasourceProperties.class)
@Configuration
@Slf4j
@MapperScan(basePackages = RenHangDataSourceConfig.PACKAGE, sqlSessionFactoryRef = "renhangSqlSessionFactory")
public class RenHangDataSourceConfig {

  static final String PACKAGE = "cn.quantgroup.report.mapper.renhang";

  @Value("${renhang.rc_sync_guangda.mapper-locations}")
  private String mapperLocations; //="classpath:cn/quantgroup/report/mapper/tidbrisk/*.xml";//resources *.xml

  @Value("${renhang.rc_sync_guangda.type-aliases-package}")
  private String typeAliasesPackage; //="cn.quantgroup.report.domain.tidbrisk";//实体pojo

  @Value("${config-location}")
  private String configLocation;


  @Autowired
  private RenHangDatasourceProperties renhangDatasourceProperties;

  @Bean(name = "renhangDataSource")
  public DataSource renhangDataSource() {
    HikariConfig config = new HikariConfig();
    log.info("rc_sync_guangda数据库地址:{}",renhangDatasourceProperties.getDatasourceJdbcUrl());
    config.setJdbcUrl(renhangDatasourceProperties.getDatasourceJdbcUrl());
    config.setPassword(renhangDatasourceProperties.getDatasourcePassword());
    config.setUsername(renhangDatasourceProperties.getDatasourceUsername());
    config.setMaximumPoolSize(renhangDatasourceProperties.getMaxPoolSize());
    config.setMinimumIdle(renhangDatasourceProperties.getMinPoolSize());
    config.addDataSourceProperty("cachePrepStmts", "true");
    config.addDataSourceProperty("prepStmtCacheSize", "250");
    config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
    return new HikariDataSource(config);
  }

  @Bean(name = "renhangTransactionManager")
  public DataSourceTransactionManager renhangTransactionManager(@Qualifier("renhangDataSource") DataSource dataSource) {
    return new DataSourceTransactionManager(dataSource);
  }

  @Bean(name = "renhangSqlSessionFactory")
  public SqlSessionFactory renhangSqlSessionFactory(@Qualifier("renhangDataSource") DataSource renhangDataSource) throws Exception {
    final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
    sessionFactory.setDataSource(renhangDataSource);
    sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
      .getResources(mapperLocations));
    sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
    sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
      .getResource(configLocation));
    return sessionFactory.getObject();
  }

  @Bean(name = "renhangSqlSessionTemplate")
  public SqlSessionTemplate renhangSqlSessionTemplate(@Qualifier("renhangSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
    return new SqlSessionTemplate(sqlSessionFactory);
  }

  @Bean(name = "renhangJdbcTemplate")
  public JdbcTemplate tidbRiskJdbcTemplate(@Qualifier("renhangDataSource") DataSource dataSource) {
    return new JdbcTemplate(dataSource);
  }

}
