package cn.quantgroup.report.service.renhang;

import cn.quantgroup.report.domain.renhang.User;
import cn.quantgroup.report.domain.renhang.UserOcrVo;
import cn.quantgroup.report.mapper.renhang.UserMapper;
import cn.quantgroup.report.service.baihang.client.BhFileCreditApiClient;
import cn.quantgroup.report.service.baihang.client.BhInterfaceCreditApiClient;
import cn.quantgroup.report.service.baihang.request.FileUploadRequest;
import cn.quantgroup.report.service.baihang.request.FileUploadValidationRequest;
import cn.quantgroup.report.service.baihang.request.InterfaceUploadValidationRequest;
import cn.quantgroup.report.service.baihang.response.FileUploadResponse;
import cn.quantgroup.report.service.baihang.response.FileUploadValidationResponse;
import cn.quantgroup.report.service.baihang.response.InterfaceUploadValidationResponse;
import cn.quantgroup.report.service.baihang.util.BHRSAUtils;
import cn.quantgroup.report.service.http.IHttpService;
import com.alibaba.fastjson.JSONObject;
import com.lkb.data.hbase.dataservice.verify.OCRIdCardDataService;
import com.lkb.data.hbase.row.verify.OCRIdCardRow;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 百行-助贷模式报送 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.10.23 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Service
public class UserOcrService {

    private static final Logger log = LoggerFactory.getLogger(UserOcrService.class);

    @Autowired
    public IHttpService iHttpService;

    private static AtomicBoolean A1_Stop = new AtomicBoolean(false);
    private static AtomicBoolean D2_Stop = new AtomicBoolean(false);
    private static AtomicBoolean D3_Stop = new AtomicBoolean(false);

    @Autowired
    private UserMapper userMapper;



    //从Hbase里获取ocr方法
    private List<UserOcrVo> getOcrInfoByHbase(List<User> userList) {
        List<UserOcrVo> resultList = new ArrayList<>();
        if (userList == null || userList.size() == 0) {
            return resultList;
        }
        long start = System.currentTimeMillis();
        JSONObject idCardContentA = null, idCardContentB = null;
        UserOcrVo userOcrVo = null;
        for (int i=0; i<userList.size(); i++) {
            User user = userList.get(i);
            String uuid = user.getUuid();
            try {
                List<OCRIdCardRow> ocrIdCardRows = OCRIdCardDataService.get(uuid);
                log.info("从hbase中查询身份证正反面结束, count: {} , uuid: {} ", i, uuid);

                if (CollectionUtils.isNotEmpty(ocrIdCardRows)) {
                    OCRIdCardRow ocrIdCardRow = ocrIdCardRows.get(0);
                    if (StringUtils.isNotBlank(ocrIdCardRow.getIdCardContentA())) {
                        idCardContentA = JSONObject.parseObject(ocrIdCardRow.getIdCardContentA());
                    }
                    if (StringUtils.isNotBlank(ocrIdCardRow.getIdCardContentB())) {
                        idCardContentB = JSONObject.parseObject(ocrIdCardRow.getIdCardContentB());
                    }
                }

                if (idCardContentA != null) {
                    userOcrVo = new UserOcrVo();
                    userOcrVo.setUuid(uuid);
                    userOcrVo.setName(idCardContentA.getString("name"));
                    userOcrVo.setGender(idCardContentA.getString("gender"));//性别  男/女
                    userOcrVo.setNation(idCardContentA.getString("nation"));//民族
                    userOcrVo.setBirthday(idCardContentA.getString("birthday"));//出生日期 格式 ：1990.02.14
                    userOcrVo.setCitizenId(idCardContentA.getString("citizen_id"));//身份证号
                    userOcrVo.setAddress(idCardContentA.getString("address"));
                }
                if (idCardContentB != null) {
                    if (userOcrVo == null) {
                        userOcrVo = new UserOcrVo();
                        userOcrVo.setUuid(uuid);
                    }
                    userOcrVo.setAgency(idCardContentB.getString("agency"));//签发机关
                    userOcrVo.setValidDateBegin(idCardContentB.getString("valid_date_begin"));//有效日期之起始日期  格式：20131022
                    userOcrVo.setValidDateEnd(idCardContentB.getString("valid_date_end"));//有效日期之结束日期  格式：20231022
                }

                if (userOcrVo != null) {
                    resultList.add(userOcrVo);
                }

            } catch (Exception e) {
                log.error("从hbase中查询身份证正反面异常, uuid: {} ", uuid, e);
            } finally {
                idCardContentA = null;
                idCardContentB = null;
                userOcrVo = null;
            }
        }
        log.info("从hbase中获取OCR结束, 参数大小: {} , 结果大小: {} , 耗时: {} ", userList.size(), resultList.size(), System.currentTimeMillis()-start);
        return resultList;
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 同步新增用户ocr <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.06.10 19:48 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.06.10 19:48 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Async
    public String synGrowingUserOcr(String startnyr, String endnyr) {
        try {
            long start1 = System.currentTimeMillis();
            List<User> growUsersList = userMapper.queryGrowingUser();

            log.info("查询DB新增用户结束, 大小: {} , 耗时: {} ", growUsersList!=null?growUsersList.size():0, (System.currentTimeMillis()-start1));

            long start2 = System.currentTimeMillis();
            List<UserOcrVo> ocrInfoList = getOcrInfoByHbase(growUsersList);
            log.info("从Hbase里获取新增用户ocr结束, 大小: {} , 耗时: {} ", ocrInfoList!=null?ocrInfoList.size():0, (System.currentTimeMillis()-start2));

            if(ocrInfoList!=null && ocrInfoList.size()>0){
                RenHangBatchExecuteJdbc.batchInsertExecute(ocrInfoList);
            }
        }catch (Exception e){
            log.error("执行同步增量ocr信息异常,", e);
            return "执行异常";
        }

        return "执行结束";
    }



    @Async
    public String synUserOcrByUuids(String uuids) {
        try {
            long start1 = System.currentTimeMillis();
            String[] uuidArray = uuids.split(",");

            List<User> userList = new ArrayList<>();
            for (String uuid : uuidArray){
                User user = new User();
                user.setUuid(uuid);
                userList.add(user);
            }
            log.info("入参用户大小: {} , 耗时: {} ", userList!=null?userList.size():0, (System.currentTimeMillis()-start1));

            long start2 = System.currentTimeMillis();
            List<UserOcrVo> ocrInfoList = getOcrInfoByHbase(userList);
            log.info("从Hbase里获取新增用户ocr结束, 大小: {} , 耗时: {} ", ocrInfoList!=null?ocrInfoList.size():0, (System.currentTimeMillis()-start2));

            if(ocrInfoList!=null && ocrInfoList.size()>0){
                RenHangBatchExecuteJdbc.batchInsertExecute(ocrInfoList);
            }
        }catch (Exception e){
            log.error("执行同步增量ocr信息异常,", e);
            return "执行异常";
        }

        return "执行结束";
    }


    @Async
    public String synValidDateEndUserOcr() {
        try {
            long start1 = System.currentTimeMillis();
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String todayNyr = dateFormat.format(new Date());
            List<User> validDateEndList = userMapper.queryValidDateEndUserOcr(todayNyr);

            log.info("查询DB用户身份证有效期已过期结束, todayNyr: {} , 大小: {} , 耗时: {} ", todayNyr, validDateEndList!=null?validDateEndList.size():0, (System.currentTimeMillis()-start1));

            long start2 = System.currentTimeMillis();
            List<UserOcrVo> ocrInfoList = getOcrInfoByHbase(validDateEndList);
            log.info("从Hbase里获取新增用户ocr结束, 大小: {} , 耗时: {} ", ocrInfoList!=null?ocrInfoList.size():0, (System.currentTimeMillis()-start2));

            if(ocrInfoList!=null && ocrInfoList.size()>0){
                RenHangBatchExecuteJdbc.batchInsertExecute(ocrInfoList);
            }
        }catch (Exception e){
            log.error("执行同步增量ocr信息异常,", e);
            return "执行异常";
        }

        return "执行结束";
    }










    /**
     * 解密
     *
     * @throws Exception
     */
    private static void interfaceUploadValidationClient(String miwen) throws Exception {
        //RSA私钥文件路径（百行提供测试环境私钥文件）
//        String RSA_PRIVATE_KEY = "d:\\rsa_private_key.pem";

        InterfaceUploadValidationRequest req = new InterfaceUploadValidationRequest();
        List<String> datas = new ArrayList<String>();
        String name = "J6kssxkrOSWPOh4XHk5cZEAEKNEQyUQeY3VNNpFHQaBJhp4lxnx+PeHgWt3uSW9A/wZf3jd5rFpdw21C55BSHHob7kU41n00Tfbt4dFy8u6lS16UaFSdNdrvZ6Y8iokVujq54zd96jggbHPK258qlrW8rkvaWp0KIWBgJesp2UQ=";//加密后的密文
//        String pid = "CSdFOGhhZS1eX5NnPAIR6/vh3FzgMBRSvJVcgf4WI8d4zStBjXKUf7UfsjGfcdMjPLkPQ93sD0OqkF5XuMWaCSkt1gHkvQCmxvErBYDfaYKI6rMY4QdJ4BPxau/IStAo+hXNdlD9gGBZpIjEtickDIw1YYdLfqRw4mZdNuMkMXI=";//加密后的密文
//        String mobile= "B5F2ozIoPbXpv65rk7fStPsVmpF0xoB+wpTc++1EvWqoDYZ5epWGmBdtxCElgvdflBcWDzB0oPPM8PclG0p/EPmJcrbivkFHN65HViTvfk2Xxs+sss9IomhmuWiLS5BTpxyTlMsPnSPjmE8so6S16YiiW3ZVble2CijUKPV+Luk=";//加密后的密文

        //datas.add(name);
//        datas.add(pid);
//        datas.add(mobile);

        datas.add(miwen);

        //设置待解密的密文数据集合
        req.setData(datas);
        BhInterfaceCreditApiClient client = new BhInterfaceCreditApiClient();
        //初始化设置RSA私钥
        client.init(BHRSAUtils.readRSAPrivateKey("/baihang/rsa_private_key.pem"));
        //执行解密操作
        InterfaceUploadValidationResponse response = client.execute(req);
        if (response.isSuccess) {
            List<String> data = response.getDecryptData();
            for (int i = 0; i < data.size(); i++) {
                System.out.println(data.get(i));
            }
            System.out.println("decrypt success;decrypt data = " + response.getDecryptData());
        } else {
            System.out.println("decrypt fail;errorMessage = " + response.getErrorMessage());
        }
    }

    /**
     * 描述: 文件方式上报的客户端代码（文件加密） <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.11.05  <br/>
     */
    public static String fileUploadClient(String fileUrl) throws Exception {
        //fileUrl = "C:\\Users\\Administrator\\Desktop\\测试\\文件测试\\baihang\\all_data.txt";
        if (StringUtils.isBlank(fileUrl)) {
            return "fileUrl参数为空";
        }
        String writeFilePath = "";
        if(fileUrl.lastIndexOf("/")!=-1){//linux
            writeFilePath = fileUrl.substring(0,fileUrl.lastIndexOf("/"))+"/cry/";
        }else{//windows
            writeFilePath = fileUrl.substring(0,fileUrl.lastIndexOf("\\"))+"\\cry\\";
        }

        //RSA公钥文件路径（百行提供公钥文件）
        ////String RSA_PUBLIC_KEY = "/manualTool/rsa_public_key.pem";
        String RSA_PUBLIC_KEY = "/baihang/rsa_public_key.pem";

        //AES密钥（机构自行设置）
        String AES_KEY = "fc4c1cbca5a46840f60";

        FileUploadRequest req = new FileUploadRequest();
        //设置未作压缩加密前的原始数据文件路径
        req.setDataFile(fileUrl);

        //设置压缩加密后的密文文件输出路径(为空表示与原始数据文件同目录)
        req.setTargetFilePath(writeFilePath);

        BhFileCreditApiClient client = new BhFileCreditApiClient();
        //初始化设置AES密钥和RSA公钥
        client.init(BHRSAUtils.readRSAPublicKey(RSA_PUBLIC_KEY), AES_KEY);
        //执行压缩加密操作
        FileUploadResponse response = client.execute(req);
        String msg = "";
        if (response.isSuccess) {
            msg = "zip And encrypt success;fileName = " + response.getEncryptFilePath() + response.getEncryptFileName();
        } else {
            msg = "zip And encrypt fail;errorMessage = " + response.getErrorMessage();
        }
        log.info(msg);
        return msg;
    }


    /**
     * 描述: 文件方式上报的客户端本地测试代码（文件解密） <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.11.05  <br/>
     */
    public static String fileUploadValidationClient(String fileUrl) throws Exception {
        //fileUrl = "C:\\Users\\Administrator\\Desktop\\测试\\文件测试\\baihang\\all_data.cry";
        if (StringUtils.isBlank(fileUrl)) {
            return "fileUrl参数为空";
        }
        String writeFilePath = "";
        if(fileUrl.lastIndexOf("/")!=-1){//linux
            writeFilePath = fileUrl.substring(0,fileUrl.lastIndexOf("/"))+"/out/";
        }else{//windows
            writeFilePath = fileUrl.substring(0,fileUrl.lastIndexOf("\\"))+"\\out\\";
        }

        //RSA私钥文件路径（百行提供测试环境私钥文件）
        String RSA_PRIVATE_KEY = "/baihang/rsa_private_key.pem";
        ////String RSA_PRIVATE_KEY = "/manualTool/rsa_private_key.pem";

        FileUploadValidationRequest req = new FileUploadValidationRequest();
        //设置压缩加密后的数据文件路径
        req.setDataFile(fileUrl);
        req.setTargetFilePath(writeFilePath);

        BhFileCreditApiClient client = new BhFileCreditApiClient();
        //初始化设置RSA私钥
        client.init(BHRSAUtils.readRSAPrivateKey(RSA_PRIVATE_KEY));
        //执行解密解压操作
        FileUploadValidationResponse response = client.execute(req);
        String msg = "";
        if (response.isSuccess) {
            msg = "decrypt And unzip success;fileName = " + response.getDecryptFilePath() + response.getDecryptFileName();
        } else {
            msg = "decrypt And unzip fail;errorMessage = " + response.getErrorMessage();
        }
        log.info(msg);
        return msg;
    }


}
