package cn.quantgroup.report.response;

import cn.quantgroup.report.constant.TransactionCodeEnum;
import cn.quantgroup.report.enums.RequestUrlType;
import cn.quantgroup.report.error.QGException;
import cn.quantgroup.report.error.QGExceptionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

@Data
public class GlobalResponse {
  private int code;
  private String error;
  private String transactionId;
  private Object body;

  @JsonIgnore
  private Boolean isBilling = false;
  @JsonIgnore
  private String uuid;
  @JsonIgnore
  private String identity;
  @JsonIgnore
  private String phone;

  @JsonIgnore
  private List<TransactionResult> transactionResult = new ArrayList<>();


  public GlobalResponse() {

  }

  private GlobalResponse(Object object) {
    body = object;
    code = 0;
    error = "";
  }

  public GlobalResponse(Object code, String error) {
    if (code instanceof String && StringUtils.isNumeric(((String) code))) {
      this.code = Integer.parseInt(((String) code));
    } else {
      this.code = QGExceptionType.COMMON_SERVER_ERROR.code;
    }
    this.error = error;
  }

  public GlobalResponse(QGException ex) {
    code = ex.qgExceptionType.code;
    error = StringUtils.isNotBlank(ex.detail) ? ex.detail : ex.qgExceptionType.text;
  }

  public static GlobalResponse generate(Object o) {
    return new GlobalResponse(o);
  }

  public static GlobalResponse builder(String transactionId, Object o) {
    GlobalResponse response;
    if(o instanceof QGException){
      response = new GlobalResponse((QGException)o);
    } else {
      response = new GlobalResponse(o);
    }
    response.setTransactionId(transactionId);
    return response;
  }

  public GlobalResponse addTransactionResult(RequestUrlType urlType, TransactionCodeEnum code){
    transactionResult.add(new TransactionResult(urlType, code));
    return this;
  }

  public GlobalResponse addTransactionResult(List<TransactionResult> transactionResults){
    transactionResult.addAll(transactionResults);
    return this;
  }

  public GlobalResponse addUuid(String uuid){
    this.uuid = uuid;
    return this;
  }

  public GlobalResponse addPhone(String phone){
    this.phone = phone;
    return this;
  }

  public GlobalResponse addIdentity(String identity){
    this.identity = identity;
    return this;
  }

  public GlobalResponse isBilling(boolean isBilling){
    this.isBilling = isBilling;
    return this;
  }

}
