package cn.quantgroup.report.config.datasource.renhang;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: tidb中call_record日志表 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.12.30 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Getter
@Setter
@Configuration
public class RenHangDatasourceProperties {


  @Value("${db.driver}")
  private String driverClass;
  @Value("${db.minPoolSize}")
  private int minPoolSize;
  @Value("${db.maxPoolSize}")
  private int maxPoolSize;



  @Value("${db.renhang.rc_sync_guangda.fullurl}")
  private String datasourceJdbcUrl;

  @Value("${db.renhang.rc_sync_guangda.username}")
  private String datasourceUsername;

  @Value("${db.renhang.rc_sync_guangda.password}")
  private String datasourcePassword;



}
