package cn.quantgroup.report.utils;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import javax.sql.DataSource;


@Slf4j
public enum RenHangHikDataSource {

    HIK_DATA_SOURCE_RENHANG;

    @Value("${db.renhang.rc_sync_guangda.fullurl}")
    private String datasourceJdbcUrl;
    @Value("${db.renhang.rc_sync_guangda.username}")
    private String datasourceUsername;
    @Value("${db.renhang.rc_sync_guangda.password}")
    private String datasourcePassword;

    public DataSource dataSourceJdbc;

    RenHangHikDataSource(){
        if(dataSourceJdbc==null){
            HikariConfig config = new HikariConfig();
            //"jdbc:mysql://fengkong-tidb.quantgroups.com:4010/risk_datasource?useUnicode=true&characterEncoding=UTF8&rewriteBatchedStatements=true"
            config.setJdbcUrl(datasourceJdbcUrl.substring(0, datasourceJdbcUrl.indexOf("?"))+"?useUnicode=true&characterEncoding=UTF8&rewriteBatchedStatements=true");
            config.setUsername(datasourceUsername);
            config.setPassword(datasourcePassword);
            config.setDriverClassName("com.mysql.jdbc.Driver");
            config.setMaximumPoolSize(10);
            config.setMinimumIdle(5);
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            dataSourceJdbc = new HikariDataSource(config);
            System.out.println("rc_sync_guangda创建数据库连接完毕");
        }
    }

}
