package cn.quantgroup.report.service.baihang;

import cn.quantgroup.report.service.AbstractBaseService;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.service.baihang.client.BhInterfaceCreditApiClient;
import cn.quantgroup.report.service.baihang.request.InterfaceUploadRequest;
import cn.quantgroup.report.service.baihang.response.InterfaceUploadResponse;
import cn.quantgroup.report.service.baihang.util.BHRSAUtils;
import cn.quantgroup.report.service.baihang.util.Base64;
import cn.quantgroup.report.service.http.IHttpService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: 百行个人征信报告查询 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.05.13 16:01 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class BaiHangQueryService extends AbstractBaseService implements CommonSuperService {

    //@Value("${baihang.zhudai.Q1.account.name}")
    private String baiHangQ1AccountName = "BJZXLM_A0001";

    //@Value("${baihang.zhudai.Q1.password}")
    private String haiHangQ1Password = "msvo%t4cxb#i262g";

    //@Value("${baihang.zhudai.Q1.requestUrl}")
    private String baihangQ1requestUrl = "https://zxpt.baihangcredit.com:8443/api/v1/credit/query";

    @Autowired
    private IHttpService iHttpService;

    private static PublicKey baihang_zhudai_publickey = null;

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 百行个人征信报告(zxlm实体:贷前/贷中/贷后)查询公共方法 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.05.13 15:58 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.05.13 15:58 <br>
     * 入参说明: [transactionId, uuid, identity, phone, name, queryReason, loanId] <br>
     * 出参说明: java.util.Map<java.lang.String,java.lang.String> <br>
     * -----------------------------------------------------------------------------
     */
    public Map<String, Object> queryBaiHangQ1OfZxlm(String transactionId, String uuid, String identity, String phone, String name, String queryReason, String loanId) {

        /*查询原因（queryReason）
        1	授信审批	机构在批核贷款、授信额度时填报的原因
        2	贷中管理	机构在实际放款前如果需要再次查询，填写贷中管理
        3	贷后管理	机构在贷款放款或循环贷款额度批核后，在业务存续期间，定期开展贷后风险管理时查询
        4	个人查询	信息主体本人查询征信报告时填报
        5	异议处理	百行征信或机构为处理异议处理时查询
        6	担保查询	机构审核担保人资质而查询征信报告时填写
        7	特约商户实名审查	适用于特约商户实名审查时填写
        8	重要人员资信审查	适用于法定代表人、负责人、高管等资信审查时填写
        9	其他人员资信审查	适用于出资方或关联方等资信审查时填写*/
        log.info("众信利民-百行个人征信报告查询入参, name: {} , identity: {} , queryReason: {} , uuid: {} ", name, identity, queryReason, uuid);
        if (!",1,2,3,4,5,6,7,8,9,".contains("," + queryReason + ",")) {
            return ImmutableMap.of("code", "301", "msg", "参数不正确！");
        }

        Long startTime = System.currentTimeMillis();
        long cost = 0;

        try {
            JSONObject applyLoanInfo = new JSONObject();
            applyLoanInfo.put("reqID", transactionId);//记录唯一标识
            applyLoanInfo.put("name", interfaceUploadClient(name));
            applyLoanInfo.put("idType", 1);//证件类型
            applyLoanInfo.put("pid", interfaceUploadClient(identity));
            applyLoanInfo.put("creditRptVersion", 1);//信用报告版本 1:机构简版
            applyLoanInfo.put("queryReason", queryReason);//查询原因
            if ("2".equals(queryReason) || "3".equals(queryReason)) {
                //ERR_30039: 查询原因是“2-贷中管理”、“3-贷后管理”时，应填写“贷款/授信账户编号”
                applyLoanInfo.put("loanId", loanId);
            }

            //String resultStr = iHttpService.postBaiHang(baihangQ1requestUrl, getHeader(), JSON.toJSONString(applyLoanInfo));
            String resultStr = "{\"homeInfo\":[{\"homeAddress\":\"福建省龙岩**********\",\"date\":\"2020-02-27\"},{\"homeAddress\":\"福建省宁化县济村**********\",\"date\":\"2020-02-27\"},{\"homeAddress\":\"福建省龙岩**********\",\"date\":\"2020-01-25\"}],\"nonRevolvingLoan\":{\"D180\":{\"applyTenantCount\":-1,\"loanCount\":0,\"loanAmount\":0.0,\"loanTenantCount\":0,\"maxLoanAmount\":0.0,\"averageLoanAmount\":0.0,\"overdueLoanCount\":0,\"compensationCount\":0,\"compensationTimes\":0,\"compensationAmount\":0.0},\"D30\":{\"applyTenantCount\":-1,\"loanCount\":0,\"loanAmount\":0.0,\"loanTenantCount\":0,\"maxLoanAmount\":0.0,\"averageLoanAmount\":0.0,\"overdueLoanCount\":0,\"compensationCount\":0,\"compensationTimes\":0,\"compensationAmount\":0.0},\"D360\":{\"applyTenantCount\":-1,\"loanCount\":0,\"loanAmount\":0.0,\"loanTenantCount\":0,\"maxLoanAmount\":0.0,\"averageLoanAmount\":0.0,\"overdueLoanCount\":0,\"compensationCount\":0,\"compensationTimes\":0,\"compensationAmount\":0.0},\"D90\":{\"applyTenantCount\":-1,\"loanCount\":0,\"loanAmount\":0.0,\"loanTenantCount\":0,\"maxLoanAmount\":0.0,\"averageLoanAmount\":0.0,\"overdueLoanCount\":0,\"compensationCount\":0,\"compensationTimes\":0,\"compensationAmount\":0.0},\"summary\":{\"loanCount\":0,\"openLoanCount\":0,\"remainingAmount\":0.0,\"remainingOverdueLoanCount\":0,\"remainingOverdueAmount\":0.0,\"remainingMaxOverdueStatus\":\"N\",\"overdueCount\":0,\"maxOverdueStatus\":\"N\",\"lastCompensationDate\":\"\"}},\"personalProfile\":{\"pid\":\"558b1bea81d43b64739f4a10ad225fa71af86c9139ec78b6e236edc31eff9d70\",\"idType\":1,\"name\":\"3c2388015a362992a4d8a9dcf8157cd56a7e6a33b29e7ae4739f5b259c89783c\",\"mobileCount\":0},\"queryHistory\":[{\"tenantType\":\"-\",\"tenantName\":\"鹰潭市信江广达小额贷款股份有限公司\",\"userId\":\"YTXJGD_C0001\",\"date\":\"2020-04-12\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-03-24\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-03-06\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-02-27\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-02-27\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-02-26\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-02-26\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"鹰潭市信江广达小额贷款股份有限公司\",\"userId\":\"YTXJGD_C0001\",\"date\":\"2020-02-26\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-01-30\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-01-28\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-01-25\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2020-01-25\",\"reason\":1},{\"tenantType\":\"-\",\"tenantName\":\"*\",\"userId\":\"*\",\"date\":\"2019-12-22\",\"reason\":1}],\"reportHeader\":{\"reportId\":\"BH2005081653168406987864\",\"reportTime\":\"2020-05-08T16:53:16\",\"queryResult\":1},\"revolvingLoan\":{\"D180\":{\"applyTenantCount\":-1,\"revolvingCompensationCount\":0,\"revolvingCompensationTimes\":0,\"revolvingCompensationAmount\":0.0,\"lendingAmount\":0.0,\"creditLimitSum\":0.0,\"overdueAccountCount\":0,\"accountCount\":0},\"D30\":{\"applyTenantCount\":-1,\"revolvingCompensationCount\":0,\"revolvingCompensationTimes\":0,\"revolvingCompensationAmount\":0.0,\"lendingAmount\":0.0,\"creditLimitSum\":0.0,\"overdueAccountCount\":0,\"accountCount\":0},\"D360\":{\"applyTenantCount\":-1,\"revolvingCompensationCount\":0,\"revolvingCompensationTimes\":0,\"revolvingCompensationAmount\":0.0,\"lendingAmount\":0.0,\"creditLimitSum\":0.0,\"overdueAccountCount\":0,\"accountCount\":0},\"D90\":{\"applyTenantCount\":-1,\"revolvingCompensationCount\":0,\"revolvingCompensationTimes\":0,\"revolvingCompensationAmount\":0.0,\"lendingAmount\":0.0,\"creditLimitSum\":0.0,\"overdueAccountCount\":0,\"accountCount\":0},\"summary\":{\"remainingAmount\":0.0,\"remainingOverdueAmount\":0.0,\"remainingMaxOverdueStatus\":\"N\",\"overdueCount\":0,\"maxOverdueStatus\":\"N\",\"revolvingLastCompensationDate\":\"\",\"creditLimitSum\":0.0,\"accountCount\":0,\"validAccountCount\":0,\"maxCreditLimitPerTenant\":0.0,\"remainingOverdueAccountCount\":0}},\"workInfo\":[{\"workName\":\"福建华维环保科*****\",\"workAddress\":\"\",\"date\":\"2020-02-27\"}]}";
            cost = System.currentTimeMillis() - startTime;

            log.info("众信利民-百行个人征信报告查询结束, transactionId: {} , uuid: {} , identity: {} , phone: {} , name: {} , queryReason: {} , loanId: {} , result: {} , 耗时: {} ",
                    transactionId, uuid, identity, phone, name, queryReason, loanId, resultStr, cost);

            //失败的情况 {"errorCode":"ERR_20003","errorMessage":"decrypt failed"}
            if (StringUtils.isNotBlank(resultStr)) {
                return ImmutableMap.of("code", "200", "msg", "众信利民-百行个人征信报告查询成功", "data", resultStr);
            } else {
                return ImmutableMap.of("code", "999", "msg", "众信利民-百行个人征信报告查询失败,返回结果为空！");
            }

        } catch (Exception e) {
            cost = System.currentTimeMillis() - startTime;
            log.error("众信利民-百行个人征信报告查询异常, transactionId: {} , uuid: {} , identity: {} , phone: {} , name: {} , queryReason: {} , loanId: {} , 耗时: {} ",
                    transactionId, uuid, identity, phone, name, queryReason, loanId, cost, e);
            return ImmutableMap.of("code", "500", "msg", "众信利民-百行个人征信报告查询异常["+e.toString()+"]");
        }
    }


    private Map<String, String> getHeader() {
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", "Basic " + Base64.byteArrayToBase64((baiHangQ1AccountName + ":" + haiHangQ1Password).getBytes()));
        headerMap.put("Content-Type", "application/json");
        return headerMap;
    }


    public static String interfaceUploadClient(String param) throws Exception {
        InterfaceUploadRequest req = new InterfaceUploadRequest();
        List<String> datas = new ArrayList<String>();
        datas.add(param);
        //设置待加密的原始数据集合
        req.setData(datas);
        BhInterfaceCreditApiClient client = new BhInterfaceCreditApiClient();
        //初始化设置RSA公钥
        client.init(getBaihangZDPublickey());
        //执行加密操作
        InterfaceUploadResponse response = client.execute(req);
        if (response.isSuccess) {
            List<String> data = response.getEncryptData();
            return data.get(0);
        }
        throw new Exception();
    }

    private static PublicKey getBaihangZDPublickey(){
        if(baihang_zhudai_publickey==null){
            try{
                baihang_zhudai_publickey = BHRSAUtils.readRSAPublicKey("/baihang/rsa_public_key.pem");
                log.info("初始化百行助贷PublicKey实例完成");
            }catch(Exception e){
                log.error("初始化百行助贷PublicKey实例", e);
            }
        }
        return  baihang_zhudai_publickey;
    }
}
