package cn.quantgroup.report.service.manualTool;


import cn.quantgroup.report.service.CommonSuperService;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: <br>
 * 作者: Administrator <br>
 * 时间: 2019.09.24 10:34 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class ManualToolService implements CommonSuperService {

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    public void deleteRedisKey(String key1, String key2, String key3) {
        String full_rediskey = "";
        if (StringUtils.isNotEmpty(key1)) {
            full_rediskey += key1;
        }
        if (StringUtils.isNotEmpty(key2)) {
            full_rediskey += key2;
        }
        if (StringUtils.isNotEmpty(key3)) {
            full_rediskey += key3;
        }
        redisTemplate.delete(full_rediskey);
        log.info("删除RedisKey成功, key1: {} , key2: {} , key3: {} , full_rediskey: {} ", key1, key2, key3, full_rediskey);
    }

    public String getRedisVal(String key) {
        Map<String,Object> map = new HashMap<>();
        map.put("key",key);
        if(StringUtils.isBlank(key)){
            return JSONObject.toJSONString(map);
        }
        try{
            String value = redisTemplate.opsForValue().get(key);
            Long expire = redisTemplate.getExpire(key);
            map.put("value",value);
            map.put("expire", expire);
        }catch (Exception e){
            log.error("获取redis里值异常, key: {} ", key, e);
        }
        return map.toString();
    }



}
