package cn.quantgroup.report.job;

import cn.quantgroup.report.service.baihang.constant.Constant;
import cn.quantgroup.report.service.renhang.UserOcrService;
import cn.quantgroup.report.utils.dingtalk.DingTalk;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: 同步广达人行报送-新增用户ocr信息 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.06.16 10:39 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
public class SynUserOcrJob {

    private static final Logger log = LoggerFactory.getLogger(SynUserOcrJob.class);

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Autowired
    private UserOcrService userOcrService;

    @Autowired
    private DingTalk dingTalk;

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述:  其他7张表同步是DBA同步的，大概每天2点开始，4点结束；
     *          该同步ocr的身份证有效期就从4：30开始的，大概5点前肯定能同步结束。
     *          信加这边每天提取数据，建议每天5点以后开始  <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.06.16 10:37 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.06.16 10:37 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Async
    //@Scheduled(cron = "0 30 04 * * ?")
    @Scheduled(cron = "0 31 14 * * ?")
    public void startSynUserOcr() {
        if (increment()) {
            redisTemplate.expire(Constant.QG_RENHANG_REPORT_SYN_USEROCR_LOCK_KEY, 10, TimeUnit.SECONDS);

            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyy-MM-dd
            String startnyr = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
            String endnyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);
            log.info("同步广达人行报送用户ocr信息开始, newTime: {} , startnyr: {} , endnyr: {} ", LocalDateTime.now(), startnyr, endnyr);

            try {

                String msg_growing = userOcrService.synGrowingUserOcr(startnyr, endnyr);
                log.info("广达人行报送-同步新增用户ocr信息结束, result: {} ", msg_growing);

            } catch (Exception e) {
                log.error("广达人行报送-同步新增用户ocr信息异常, newTime: {}, 耗时: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), e);
                dingTalk.talk("Error", "广达人行报送-同步新增用户ocr信息异常", e);
                dingTalk.talk_ToUser("数据同步异常", "广达人行报送-同步新增用户ocr信息异常，请尽快手动处理!");
            }


            try {
                String msg_validDateEnd = userOcrService.synValidDateEndUserOcr();
                log.info("广达人行报送-同步ocr身份证有效期过期用户信息结束, result: {} ", msg_validDateEnd);
            } catch (Exception e) {
                log.error("广达人行报送-同步ocr身份证有效期过期用户信息异常, newTime: {}, 耗时: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), e);
                dingTalk.talk("Error", "广达人行报送-同步ocr身份证有效期过期用户信息异常", e);
                dingTalk.talk_ToUser("数据同步异常", "广达人行报送-同步ocr身份证有效期过期用户信息异常，请尽快手动处理!");
            }

        }
    }


    public Boolean increment(){
        Long increment = redisTemplate.opsForValue().increment(Constant.QG_RENHANG_REPORT_SYN_USEROCR_LOCK_KEY, 1);
        return increment <= 1;
    }

}
