package cn.quantgroup.report.service.renhang;

import cn.quantgroup.report.domain.renhang.UserOcrVo;
import cn.quantgroup.report.utils.RenHangHikDataSource;
import lombok.extern.slf4j.Slf4j;

import java.sql.*;
import java.util.List;


@Slf4j
public class RenHangBatchExecuteJdbc {

    private static void close(Connection conn, Statement st, ResultSet rs){
        try {
            if(rs!=null)
                rs.close();
            if(st!=null)
                st.close();
            if(conn!=null)
                conn.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }

    }



    public static void batchInsertExecute(List<UserOcrVo> ocrInfoList){
        int commit_count = 1000;
        String insert_sql = "INSERT INTO `user_ocr` (`uuid`, `address`, `birthday`, `citizen_id`, `gender`, `name`, `nation`, `agency`, `valid_date_begin`, `valid_date_end`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        Connection conn = null;
        java.sql.PreparedStatement ps = null;
        try {
            conn = RenHangHikDataSource.INSTANCE.batchDataSourceJdbc.getConnection();
            ps = conn.prepareStatement(insert_sql);
            conn.setAutoCommit(false);
            for (int i = 0; i < ocrInfoList.size(); i++) {
                try{
                    UserOcrVo bean = ocrInfoList.get(i);
                    ps.setString(1, bean.getUuid());
                    ps.setString(2, bean.getAddress());
                    ps.setString(3, bean.getBirthday());
                    ps.setString(4, bean.getCitizenId());
                    ps.setString(5, bean.getGender());
                    ps.setString(6, bean.getName());
                    ps.setString(7, bean.getNation());
                    ps.setString(8, bean.getAgency());
                    ps.setString(9, bean.getValidDateBegin());
                    ps.setString(10, bean.getValidDateEnd());
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    ps.setTimestamp(11, timestamp);
                    ps.setTimestamp(12, timestamp);
                    ps.addBatch();

                    if(i>0 && i%commit_count==0){
                        ps.executeBatch();
                        conn.commit();
                        //ps.clearBatch();
                        log.info("提交结束:"+ (i/commit_count + 1));
                    }
                }catch (Exception e){
                    log.error("执行batchInsertExecute异常, SQL:{} , count: {} ", insert_sql, e);
                }
            }
            ps.executeBatch();
            conn.commit();

            log.info("所有保存提交结束");

        }catch(Exception e){
            log.error("执行batchInsertExecute异常, SQL:{} , count: last ", insert_sql, e);
        }finally {
            close(conn, ps,null);
        }
    }

    public static void batchUpdateExecute(List<UserOcrVo> ocrInfoList){
        int commit_count = 1000;
        String update_sql = "update user_ocr set valid_date_begin=?, valid_date_end=?, updated_at=? where uuid=? ";
        Connection conn = null;
        java.sql.PreparedStatement ps = null;
        try {
            conn = RenHangHikDataSource.INSTANCE.batchDataSourceJdbc.getConnection();
            ps = conn.prepareStatement(update_sql);
            conn.setAutoCommit(false);
            for (int i = 0; i < ocrInfoList.size(); i++) {
                try{
                    UserOcrVo bean = ocrInfoList.get(i);
                    ps.setString(1, bean.getValidDateBegin());
                    ps.setString(2, bean.getValidDateEnd());
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    ps.setTimestamp(3, timestamp);
                    ps.setString(4, bean.getUuid());
                    ps.addBatch();

                    if(i>0 && i%commit_count==0){
                        ps.executeBatch();
                        conn.commit();
                        //ps.clearBatch();
                        log.info("提交结束:"+ (i/commit_count + 1));
                    }
                }catch (Exception e){
                    log.error("执行batchUpdateExecute异常, SQL:{} , count: {} ", update_sql, e);
                }
            }
            ps.executeBatch();
            conn.commit();
        }catch(Exception e){
            log.error("执行batchUpdateExecute异常, SQL:{} , count: last ", update_sql, e);
        }finally {
            close(conn, ps,null);
        }
    }


}
