package cn.quantgroup.report.utils;


import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.UUID;

public class IdUtils {
    // 起始的时间戳
    private final static long START_STMP = 1539141250000L;
    // 每一部分最大值
    private final static long MAX_SEQUENCE = -1L ^ (-1L << 12);
    private static long sequence = 0L; // 序列号
    private static long lastStmp = -1L;// 上一次时间戳


    //产生下一个ID
    public static synchronized String nextId(String seqName) {
        long seqId = (seqName + getLocalMac()).hashCode() & 0x7FFFFFFF;
        long currStmp = getNewstmp();
        if (currStmp < lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }

        if (currStmp == lastStmp) {
            //if条件里表示当前调用和上一次调用落在了相同毫秒内，只能通过第三部分，序列号自增来判断为唯一，所以+1.
            sequence = (sequence + 1) & MAX_SEQUENCE;
            //同一毫秒的序列数已经达到最大，只能等待下一个毫秒
            if (sequence == 0L) {
                currStmp = getNextMill();
            }
        } else {
            //不同毫秒内，序列号置为0
            //执行到这个分支的前提是currTimestamp > lastTimestamp，说明本次调用跟上次调用对比，已经不再同一个毫秒内了，这个时候序号可以重新回置0了。
            sequence = 0L;
        }

        lastStmp = currStmp;
        //就是用相对毫秒数、机器ID和自增序号拼接
        return "" + (currStmp - START_STMP) + seqId + sequence;
    }

    private static long getNextMill() {
        long mill = getNewstmp();
        while (mill <= lastStmp) {
            mill = getNewstmp();
        }
        return mill;
    }

    private static long getNewstmp() {
        return System.currentTimeMillis();
    }

    //获取网卡，获取地址
    private static String getLocalMac() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mac.length; i++) {
                if (i != 0) {
                    sb.append("-");
                }
                //字节转换为整数
                int temp = mac[i] & 0xff;
                String str = Integer.toHexString(temp);
                if (str.length() == 1) {
                    sb.append("0" + str);
                } else {
                    sb.append(str);
                }
            }
            return sb.toString().toUpperCase();
        }catch (Exception e){
            return UUID.randomUUID().toString();
        }
    }

    public static String getUuid(){
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        return uuid;
    }

    public static void main(String[] args) {
        System.out.println(getLocalMac());
        long seqId = ("order" + getLocalMac()).hashCode();
        System.out.println(seqId);
        int i = 0;
        while(i++<10) {
            System.out.println(IdUtils.nextId("order"));
        }
    }

}
