package cn.quantgroup.report.service.manualTool;

import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: <br>
 * 作者: Administrator <br>
 * 时间: 2020.04.05 15:37 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */


public class HomeWork {

    public static void main(String[] args) {

       //1、输入两个数a和b，输出a+b
        Object num_a = "9999999999999999999999999999999999999999999999999999999999999999999999999999999999";
        Object num_b = "1.01";
        Object result = aAddb(num_a, num_b);
        System.out.println(num_a + " + " + num_b + " = " +result.toString());

        //2、从目录A下打开文件test.txt，读取全10个字符并输出
        String filePath = "C:\\Users\\Administrator\\Desktop\\助贷\\2020-01-06_07\\test.txt";
        String str_10 = null;
        str_10 = readTxt10char1(filePath);
        System.out.printf(str_10);

        str_10 = readTxt10char2(filePath);
        System.out.printf(str_10);

        str_10 = readTxt10char3(filePath);
        System.out.printf(str_10);
    }


    public static Object aAddb(Object a, Object b) {
        if (null == a || StringUtils.isBlank(a.toString().trim())) {
            System.out.println("参数a不能为空!");
            return null;
        }
        if (null == b || StringUtils.isBlank(b.toString().trim())) {
            System.out.println("参数b不能为空!");
            return null;
        }

        String str_a = a.toString().trim();
        String str_b = b.toString().trim();

        if (!isInteger(str_a) && !isDouble(str_a)) {
            System.out.println("参数a不是数值类型!");
            return null;
        }
        if (!isInteger(str_b) && !isDouble(str_b)) {
            System.out.println("参数b不是数值类型!");
            return null;
        }

        if (isDouble(str_a) || isDouble(str_b)) {
            //if(str_a.split("[.]")[0].length()>=18 || str_b.split("[.]")[0].length()>=18){
            BigDecimal bigDecimal_a = new BigDecimal(str_a);
            BigDecimal bigDecimal_b = new BigDecimal(str_b);
            return bigDecimal_a.add(bigDecimal_b);
            /*}else {
                double d_a = Double.parseDouble(str_a);
                double d_b = Double.parseDouble(str_b);
                return d_a + d_b;
            }*/
        } else {
            //Long.MAX_VALUE 9223372036854775807
            if (str_a.length() >= 18 || str_b.length() >= 18) {
                BigInteger big_a = new BigInteger(str_a);
                BigInteger big_b = new BigInteger(str_b);
                return big_a.add(big_b);
            } else {
                long l_a = Long.parseLong(str_a);
                long l_b = Long.parseLong(str_b);
                return l_a + l_b;
            }

        }

    }


    /**
     * -----------------------------------------------------------------------------<br>
     * 描述: 获取文件前10个字符，（按行去取，中文看做1个字符）<br>
     * 作者：yanhui.Hao <br>
     * 时间：2020.04.05 <br>
     * 授权: (C) Copyright (c) 2017 <br>
     * 公司: 北京众信利民信息技术有限公司 <br>
     * -----------------------------------------------------------------------------
     */
    public static String readTxt10char1(String txtPath) {
        File file = new File(txtPath);
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        if (file.isFile() && file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader(fileInputStream, "GBK");
                bufferedReader = new BufferedReader(inputStreamReader);

                StringBuffer sb = new StringBuffer();
                String text = null;
                while ((text = bufferedReader.readLine()) != null) {
                    sb.append(text);
                    if (sb.length() >= 10) {
                        break;
                    }
                }

                if(sb.length()>=10){
                    return sb.substring(0, 10);
                }else{
                    return sb.substring(0, sb.length());
                }

            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }


    /**
     * -----------------------------------------------------------------------------<br>
     * 描述: 获取文件前10个字符，（按行读取，把中文看做2个字符）<br>
     * 作者：yanhui.Hao <br>
     * 时间：2020.04.05 <br>
     * 授权: (C) Copyright (c) 2017 <br>
     * 公司: 北京众信利民信息技术有限公司 <br>
     * -----------------------------------------------------------------------------
     */
    public static String readTxt10char2(String txtPath) {
        File file = new File(txtPath);
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        if (file.isFile() && file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader(fileInputStream, "GBK");
                bufferedReader = new BufferedReader(inputStreamReader);

                byte[] byte10 = new byte[10];
                int copy_index = 0;
                String text = null;
                while ((text = bufferedReader.readLine()) != null) {
                    byte[] tmp = text.getBytes("GBK");
                    if (tmp.length >= 10) {
                        System.arraycopy(tmp, 0, byte10, 0, 10);
                        break;
                    } else {
                        if (copy_index + tmp.length >= 10) {
                            System.arraycopy(tmp, 0, byte10, copy_index, 10 - copy_index);
                            copy_index = 10;
                            break;
                        } else {
                            System.arraycopy(tmp, 0, byte10, copy_index, tmp.length);
                            copy_index += tmp.length;
                        }
                    }
                }
                String str = new String(byte10, "GBK");
                return str;
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }


    /**
     * -----------------------------------------------------------------------------<br>
     * 描述: 获取文件前10个字符，（按字节读取，把中文看做2个字符）<br>
     * 作者：yanhui.Hao <br>
     * 时间：2020.04.05 <br>
     * 授权: (C) Copyright (c) 2017 <br>
     * 公司: 北京众信利民信息技术有限公司 <br>
     * -----------------------------------------------------------------------------
     */
    public static String readTxt10char3(String txtPath) {
        File file = new File(txtPath);
        FileInputStream fileInputStream = null;
        if (file.isFile() && file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);

               /* byte[] byte10 = new byte[10];
                int read = fileInputStream.read(byte10);
                 if(read>0){
                   String str = new String(byte10, "GBK");
                   System.out.println(str);
                   return str;
                }*/

                //byte[] byte_10 = new byte[10];
                byte[] byte_10 = getByte10(fileInputStream, 0, null, 0);

                String str = new String(byte_10, "GBK");
                return str;


            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }


    //判断整数（int）
    private static boolean isInteger(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    //判断浮点数（double和float）
    private static boolean isDouble(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-\\+]?\\d*[.]\\d+$");
        boolean isDouble = pattern.matcher(str).matches();

        if (!isDouble) {
            try {
                BigDecimal test_bigDecimal = new BigDecimal(str);
                isDouble = true;
            } catch (Exception e) {
            }
        }
        return isDouble;
    }

    private static byte[] getByte10(FileInputStream fileInputStream, int start, byte[] byte_10, int index) {
        if(byte_10==null){
            byte_10 = new byte[10];
        }
        try {
            int length = 8;
            byte[] byte_tmp = new byte[length];
            int read = fileInputStream.read(byte_tmp, 0, length);
            int i1 = fileInputStream.hashCode();
            start += length;
            if (read > 0) {
                //"\r" 回车键 13 ; "\n" 换行键 10
                for (int i = 0; i < read; i++) {
                    if (byte_tmp[i] != 10 && byte_tmp[i] != 13) {
                        if (index >= 10) {
                            break;
                        } else {
                            byte_10[index] = byte_tmp[i];
                            index++;
                        }
                    }
                }

                if (index < 10) {
                    return getByte10(fileInputStream, start, byte_10, index);
                } else {
                    return byte_10;
                }
            }


        } catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }

        byte[] byte_tmp = new byte[index];
        System.arraycopy(byte_10, 0, byte_tmp, 0, byte_tmp.length);
        return byte_tmp;
    }

}
