package cn.quantgroup.report.controller;

import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.manualTool.ManualToolService;
import cn.quantgroup.report.service.renhang.UserOcrService;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@Slf4j
@RestController
@RequestMapping(value = "/manualtool")
public class ManualToolController {

  @Autowired
  private ManualToolService manualToolService;

  @Autowired
  private UserOcrService userOcrService;




  @RequestMapping("/dealWithExcelData")
  public GlobalResponse dealWithExcelData(String filePath,String type){
    return manualToolService.dealWithExcelData(filePath,type);
  }


  @RequestMapping("/removeD3LoanIdChunfu")
  public String remove_D3_loanId_chunfu(String oldDataFile, String cfLoanIdLogFile, String newFileName, String rmIdFileName,String rmPhoneFileName){
    return manualToolService.remove_D3_loanId_chunfu(oldDataFile,cfLoanIdLogFile,newFileName,rmIdFileName,rmPhoneFileName);
  }
  @RequestMapping("/checkD3loanIdInD2")
  public String check_D3loanId_InD2(String d3LoanIdFile, String d2File, String inFileName, String notInFileName){
    return manualToolService.check_D3loanId_InD2(d3LoanIdFile,d2File,inFileName,notInFileName);
  }
  @RequestMapping("/checkD2loanIdInD3WanJie")
  public String check_D2loanId_InD3WanJie(String d3LoanIdFile, String d2File, String notWJFileName){
    return manualToolService.check_D2loanId_InD3WanJie(d3LoanIdFile,d2File,notWJFileName);
  }

  @RequestMapping("/newD3ReplaceReqId")
  public String newD3ReplaceReqId(String newD3FilePath, String newD3FileNames, String oldD3ReqIdFile, String mapNotEmptyFile){
     manualToolService.newD3ReplaceReqId(newD3FilePath,newD3FileNames,oldD3ReqIdFile,mapNotEmptyFile);
    return "调用结束";
  }



  @RequestMapping("/deleteRedisKey")
  public Map<String,Object> deleteRedisKey(String key1, String key2, String key3){
    try{
      manualToolService.deleteRedisKey(key1, key2, key3);
      return ImmutableMap.of("code", 0, "msg", "手动删除redisKey成功");
    }catch(Exception e){
      return ImmutableMap.of("code", 1, "msg", "手动设置redisKey异常");
    }
  }

  @RequestMapping("/getRedisVal")
  public String getRedisVal(String key){
    try{
      return manualToolService.getRedisVal(key);
    }catch(Exception e){
      return "获取redis值异常";
    }
  }


  @RequestMapping("/synGrowingUser")
  public String synGrowingUser(String startnyr, String endnyr) {
    userOcrService.synGrowingUserOcr(startnyr, endnyr);

    return "synGrowingUser方法调度成功";
  }


  @RequestMapping("/synUserOcrByUuids")
  public String synUserOcrByUuids(String uuids) {
    if (StringUtils.isEmpty(uuids)) {
      return "参数为空";
    }
    userOcrService.synUserOcrByUuids(uuids);

    return "synUserOcrByUuids方法调度成功";
  }


  @RequestMapping("/synValidDateEndUserOcr")
  public String synValidDateEndUserOcr() {
    userOcrService.synValidDateEndUserOcr();
    return "synValidDateEndUserOcr方法调度成功";
  }


}
