
package cn.quantgroup.qgdataservice.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorUtils {

    private static final Logger log = LoggerFactory.getLogger(ThreadPoolExecutorUtils.class);

    private static ThreadPoolExecutorUtils threadPool = new ThreadPoolExecutorUtils();

    private ThreadPoolExecutor executor = null;

    private ThreadPoolExecutorUtils() {
        executor = new ThreadPoolExecutor(50, 200, 50, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(20));
    }

    public static ThreadPoolExecutorUtils getThreadPoolUtil() {
        return threadPool;
    }

    public void execute(Runnable r) {
        try {
            int activeCount = executor.getActiveCount();
            int size = executor.getQueue().size();
            log.info("数据清洗线程池活跃数: {} , queueSize: {} ", activeCount, size);
        } catch (Exception e) {
            log.info("TASK_POOL KA Exception : {}", e);
        }
        executor.execute(r);
    }

    public void shutDown() {
        executor.shutdown();
    }

}
