package cn.quantgroup.qgdataservice.utils;

import cn.quantgroup.qgdataservice.constant.Constant;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import static cn.quantgroup.qgdataservice.config.datasource.TidbDataSource.HIK_DATA_SOURCE;

/**
 * Created by renfeng on 2019/4/22.
 */
public class JdbcExecuters {

    private static final Logger log = LoggerFactory.getLogger(JdbcExecuters.class);

    /**
     * 批量插入
     *
     * @param sql
     */
    public static void batchUpdateExecute(String sql, String userSource, String phone) {
        Connection conn = null;
        Statement st = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            st = conn.createStatement();
            try {
                st.executeUpdate(sql);
            } catch (SQLException e) {
                log.error("执行sql异常, sql: {} ", sql, e);
            } catch (Exception e) {
                log.error("未知异常, sql: {} ", sql, e);
            }
        } catch (Exception e) {
            log.error("执行sqlException异常, sqls: {} ", sql, e);
        } finally {
            close(conn, st, null);
        }
    }


    /**
     * 批量插入
     *
     * @param sqls
     */
    public static void batchUpdateExecute(List<String> sqls) {
        Connection conn = null;
        Statement st = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            st = conn.createStatement();
            conn.setAutoCommit(false);
            for (String sql : sqls) {
                try {
                    st.executeUpdate(sql);
                } catch (SQLException e) {
                    log.error("执行sql异常, sql: {} ", sql, e);
                } catch (Exception e) {
                    log.error("未知异常, sql: {} ", sql, e);
                }
            }
            conn.commit();
        } catch (Exception e) {
            log.error("执行sqlException异常, sqls: {} ", sqls, e);
        } finally {
            close(conn, st, null);
        }
    }

    public static void prepareBatchUpdate(String sql, List<List<Object>> paramList) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            statement = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for (List<Object> param : paramList) {
                try {
                    for (int i = 0; i < param.size(); i++) {
                        Object object = param.get(i);
                        if (object == null || "".equals(object)) {
                            statement.setObject(i + 1, null);
                        } else if (object instanceof String) {
                            statement.setString(i + 1, (String) object);
                        } else if (object instanceof Long) {
                            statement.setLong(i + 1, (Long) object);
                        } else {
                            statement.setObject(i + 1, object);
                        }
                    }
                    statement.addBatch();
                } catch (SQLException e) {
                    log.error("设备指纹清洗数据批量插入数据SQL异常 , param: {} ", JSON.toJSONString(param), e);
                } catch (Exception e) {
                    log.error("设备指纹清洗数据批量插入数据未知异常, param: {} ", JSON.toJSONString(param), e);
                }
            }
            statement.executeBatch();
            conn.commit();
        } catch (Exception e) {
            log.error("设备指纹清洗数据批量插入数据未知异常, sql: {} ", sql, e);
        } finally {
            close(conn, statement, null);
        }
    }

    public static int batchExecute(List<List<String>> list, String sql) {
        Connection conn = null;
        PreparedStatement ps = null;
        AtomicInteger atomicInteger = new AtomicInteger();
        try {

            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);

            for (int i = 0; i < list.size(); i++) {

                List<String> params = list.get(i);

                for (int j = 0; j < params.size(); j++) {
                    ps.setString(j + 1, params.get(j));
                }

                ps.addBatch();
                atomicInteger.getAndIncrement();

                if (i > 0 && i % Constant.BATCH.BATCH_SIZE == 0) {
                    ps.executeBatch();
                    conn.commit();
                    ps.clearBatch();
                }
            }

            ps.executeBatch();
            conn.commit();

        } catch (Exception e) {
            log.error("清洗数据批量插入数据异常", e);
        } finally {
            close(conn, ps, null);
        }
        return atomicInteger.get();
    }

//    public static void batchExecute(List<String> list) {
//        Connection conn = null;
//        PreparedStatement ps = null;
//        try {
//
////            String sql = "INSERT IGNORE INTO comservice_i_unicom_call_info (uuid,businessType,cTime,tradeTime,callType,receiverPhone,tradeAddr,tradeType,basePay,ldPay,otherPay,totalPay,phone,iscm,reductionPay,timestamp) " +
////                    "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
//
//            conn = HIK_DATA_SOURCE.dataSource.getConnection();
//            ps = conn.prepareStatement("");
//            conn.setAutoCommit(false);
//            for (int i = 0; i < list.size(); i++) {
//                ps.addBatch(list.get(i));
//                if (i>0 && i % Constant.BATCH.BATCH_SIZE == 0) {
//                    ps.executeBatch();
//                    ps.clearBatch();
//                }
//            }
//            ps.executeBatch();
//            conn.commit();
//            ps.clearBatch();
//
//
//        } catch (Exception e) {
//            log.error("清洗数据批量插入数据异常", e);
//        } finally {
//            close(conn, ps, null);
//        }
//    }

    /**
     * 关闭资源
     *
     * @param conn
     * @param st
     * @param rs
     */
    private static void close(Connection conn, Statement st, ResultSet rs) {
        try {
            if (rs != null)
                rs.close();
            if (st != null)
                st.close();
            if (conn != null)
                conn.close();
        } catch (SQLException e) {
            log.error("清洗数据关闭jdbc资源异常", e);
        }

    }

//    public static void main(String[] args) {
//        Connection conn = null;
//        PreparedStatement ps = null;
//        AtomicInteger atomicInteger = new AtomicInteger();
//        try {
//
//            conn = HIK_DATA_SOURCE.dataSource.getConnection();
//            System.out.println(conn);
//        }catch(Exception e){}
//    }


}
