
package cn.quantgroup.qgdataservice.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutor2Utils {

    private static final Logger log = LoggerFactory.getLogger(ThreadPoolExecutor2Utils.class);

    private static ThreadPoolExecutor2Utils threadPool = new ThreadPoolExecutor2Utils();

    private ThreadPoolExecutor executor = null;

    private ThreadPoolExecutor2Utils() {
        executor = new ThreadPoolExecutor(50, 200, 50, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(20));
    }

    public static ThreadPoolExecutor2Utils getThreadPoolUtil() {
        return threadPool;
    }

    public void execute(Runnable r) {
        try {
            int activeCount = executor.getActiveCount();
            int size = executor.getQueue().size();
            log.info("发送kafka线程池活跃数: {} , queueSize: {} ", activeCount, size);
        } catch (Exception e) {
            log.info("TASK_POOL KA Exception2 : {}", e);
        }
        executor.execute(r);
    }

    public void shutDown() {
        executor.shutdown();
    }

}
