package cn.quantgroup.qgdataservice.config.kafka;

import cn.quantgroup.qgdataservice.constant.Constant;
import com.alibaba.fastjson.JSON;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.serialization.StringSerializer;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

/**
 * @Author fengjunkai
 * @Date 2019-08-20 19:01
 */
public enum KafkaProducers {


    KAFKA_PRODUCER_API;

    public KafkaProducer kafkaProducer;

    KafkaProducers() {

        if (kafkaProducer == null) {
            ResourceBundle rs = ResourceBundle.getBundle(Constant.KAFKA.APPLICATION);
            Map<String, Object> props = new HashMap<>();
            String boot = rs.getString(Constant.KAFKA.BOOT_STRAPSERVER);

            props.put(ProducerConfig.BOOTSTRAP_SERVERS_CONFIG, boot);
            props.put(ProducerConfig.KEY_SERIALIZER_CLASS_CONFIG, StringSerializer.class);
            props.put(ProducerConfig.VALUE_SERIALIZER_CLASS_CONFIG, StringSerializer.class);
            props.put(ProducerConfig.RETRIES_CONFIG, 1);
            props.put(ProducerConfig.RETRY_BACKOFF_MS_CONFIG, 30000);

            props.put(ProducerConfig.BUFFER_MEMORY_CONFIG, 67108864);
            props.put(ProducerConfig.MAX_BLOCK_MS_CONFIG, 60000);

            props.put(ProducerConfig.REQUEST_TIMEOUT_MS_CONFIG, 20000);

            props.put(ProducerConfig.LINGER_MS_CONFIG, 1);
            props.put(ProducerConfig.BATCH_SIZE_CONFIG, 16384);

            props.put(ProducerConfig.ACKS_CONFIG, "all");

            kafkaProducer = new KafkaProducer(props);

            System.out.println("初始化kafka配置完成" + JSON.toJSONString(props));

        }

    }

}
