package cn.quantgroup.qgdatadc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;

//@EnableJpaRepositories(basePackages = {"cn.quantgroup.qgrtdc.repository.jpa"})
//@EntityScan(basePackages = {"cn.quantgroup.qgrtdc.repository.jpa.entity"})
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableCaching
@EnableAsync
@EnableAspectJAutoProxy
@Slf4j
@EnableApolloConfig
@SpringBootApplication
public class QgDataDcApplication {

    public static void main(String[] args) {
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.WriteEnumUsingToString.getMask();
        SpringApplication springApplication = new SpringApplication(QgDataDcApplication.class);
        springApplication.addInitializers(new ApolloPropertySourceInitializer());
        springApplication.run(args);
        log.info("QUANTGROUP-数据实时清洗-系统启动完成 ^_^ ");
    }

}
