package cn.quantgroup.qgdataservice.service.kafka;

import cn.quantgroup.qgdataservice.config.kafka.KafkaProducers;
import cn.quantgroup.qgdataservice.constant.Constant;
import cn.quantgroup.qgdataservice.model.mobile.MobileCallDetailInfo;
import cn.quantgroup.qgdataservice.model.telcom.TelecomCallDetailInfo;
import cn.quantgroup.qgdataservice.model.unicom.UnicomCallDetailInfo;
import cn.quantgroup.qgdataservice.utils.ThreadPoolExecutor2Utils;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @Author fengjunkai
 * @Date 2019-08-21 19:09
 */
public class OperatorCallDetailListSendToKafkaService {

    private static final Logger log = LoggerFactory.getLogger(OperatorCallDetailListSendToKafkaService.class);

    public static void sendMobileCallDetailListMessage(List<MobileCallDetailInfo> mobileCallDetailInfos) {

        ThreadPoolExecutor2Utils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {

                try {

                    Stopwatch stopwatch = Stopwatch.createStarted();

                    for(int i=0;i<mobileCallDetailInfos.size();i++){

                        ProducerRecord producerRecord = new ProducerRecord(Constant.KAFKA.OPERATOR_CALL_TOPIC, JSON.toJSONString(mobileCallDetailInfos.get(i)));
                        KafkaProducers.KAFKA_PRODUCER_API.kafkaProducer.send(producerRecord, new Callback() {
                            @Override
                            public void onCompletion(RecordMetadata metadata, Exception exception) {
                                if (Objects.nonNull(exception)) {
                                    log.error("移动通话详单发送至kafka(清洗后)回调提示异常, 异常: {} ", exception);
                                }
                            }
                        });

                    }

                    log.info("移动通话详单发送至kafka(清洗后)数据结束, 耗时: {} ", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                } catch (Exception e) {
                    log.error("移动通话详单发送至kafka(清洗后)数据异常", e);
                }

            }
        });

    }

    public static void sendTelecomCallDetailListMessage(List<TelecomCallDetailInfo> telecomCallDetailInfos) {

        ThreadPoolExecutor2Utils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {

                Stopwatch stopwatch = Stopwatch.createStarted();
                try {
                    for(int i=0;i<telecomCallDetailInfos.size();i++){

                        ProducerRecord producerRecord = new ProducerRecord(Constant.KAFKA.OPERATOR_CALL_TOPIC, JSON.toJSONString(telecomCallDetailInfos.get(i)));
                        KafkaProducers.KAFKA_PRODUCER_API.kafkaProducer.send(producerRecord, new Callback() {
                            @Override
                            public void onCompletion(RecordMetadata metadata, Exception exception) {
                                if(Objects.nonNull(exception)){
                                    log.error("电信通话详单发送至kafka(清洗后)回调结果提示异常, {}", exception);
                                }
                            }
                        });

                    }

                    log.info("电信通话详单发送至kafka(清洗后)数据结束, 耗时: {} ", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                } catch (Exception e) {
                    log.error("电信通话详单发送至kafka(清洗后)数据异常", e);
                }

            }
        });

    }

    public static void sendUnicomCallDetailListMessage(List<UnicomCallDetailInfo> unicomCallDetailInfos) {

        ThreadPoolExecutor2Utils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {

                Stopwatch stopwatch = Stopwatch.createStarted();

                try {

                    for(int i=0;i<unicomCallDetailInfos.size();i++){

                        ProducerRecord producerRecord = new ProducerRecord(Constant.KAFKA.OPERATOR_CALL_TOPIC, JSON.toJSONString(unicomCallDetailInfos.get(i)));
                        KafkaProducers.KAFKA_PRODUCER_API.kafkaProducer.send(producerRecord, new Callback() {
                            @Override
                            public void onCompletion(RecordMetadata metadata, Exception exception) {
                                if(Objects.nonNull(exception)){
                                    log.error("联通通话详单发送至kafka(清洗后)回调结果提示异常, {}", exception);
                                }
                            }
                        });

                    }

                    log.info("联通通话详单发送至kafka(清洗后)数据结束, 耗时: {} ", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                } catch (Exception e) {
                    log.error("联通通话详单发送至kafka(清洗后)数据记异常", e);
                }

            }
        });

    }

}
