package cn.quantgroup.qgdataservice.service.tidb;

import cn.quantgroup.qgdataservice.constant.Constant;
import cn.quantgroup.qgdataservice.model.mobile.MobileCallDetailInfo;
import cn.quantgroup.qgdataservice.model.telcom.TelecomCallDetailInfo;
import cn.quantgroup.qgdataservice.model.unicom.UnicomCallDetailInfo;
import cn.quantgroup.qgdataservice.service.kafka.OperatorCallDetailListSendToKafkaService;
import cn.quantgroup.qgdataservice.utils.*;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import com.lkb.data.hbase.row.SpiderUserItemDataRow;
import com.lkb.data.hbase.row.operators.PhoneBillDataRow;
import com.lkb.data.hbase.row.operators.PhonePaymentDataRow;
import com.lkb.data.hbase.row.operators.mobile.MobileCallInfoRow;
import com.lkb.data.hbase.row.operators.mobile.MobileFlowInfoRow;
import com.lkb.data.hbase.row.operators.mobile.MobileSmsInfoRow;
import com.lkb.data.hbase.row.operators.telecom.TelecomCallInfoRow;
import com.lkb.data.hbase.row.operators.telecom.TelecomFlowInfoRow;
import com.lkb.data.hbase.row.operators.telecom.TelecomSmsInfoRow;
import com.lkb.data.hbase.row.operators.unicom.UnicomCallInfoRow;
import com.lkb.data.hbase.row.operators.unicom.UnicomFlowInfoRow;
import com.lkb.data.hbase.row.operators.unicom.UnicomSmsInfoRow;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author fengjunkai
 * @Date 2019-05-28 14:08
 */
public class OperatorInfoCleaningService {

    private static final Logger log = LoggerFactory.getLogger(OperatorInfoCleaningService.class);

    /**
     * 入网时间/手机余额/手机号
     *
     * @param spiderUserItemDataRow
     * @param uuid
     * @param ka
     */
    public static void cleaningAndSaveUserInfo(SpiderUserItemDataRow spiderUserItemDataRow, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {

                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                try {

                    String userSource = spiderUserItemDataRow.getUserSource();
                    String phone = spiderUserItemDataRow.getPhone();

                    List<String> list = new ArrayList<>();

                    list.add(StringUtils.isBlank(uuid) ? null : uuid);

                    String realName = spiderUserItemDataRow.getRealName();
                    list.add(StringUtils.isBlank(realName) ? null : realName);

                    Date registerDate = spiderUserItemDataRow.getRegisterDate();
                    list.add(TimeUtils.registerDateFormat(registerDate, userSource, phone));

                    String idCard = spiderUserItemDataRow.getIdCard();
                    list.add(StringUtils.isBlank(idCard) ? null : idCard);

                    Float phoneRemain = spiderUserItemDataRow.getPhoneRemain();
                    list.add(NumberUtils.formatPhoneRemain(phoneRemain, userSource, phone));

                    list.add(PhoneUtils.getPhoneNoByRegx(phone, userSource, phone));

                    String addr = spiderUserItemDataRow.getAddr();
                    list.add(StringUtils.isBlank(addr) ? null : addr);

                    String merry = spiderUserItemDataRow.getMerry();
                    list.add(StringUtils.isBlank(merry) ? null : merry);

                    String cardType = spiderUserItemDataRow.getCardType();
                    list.add(StringUtils.isBlank(cardType) ? null : cardType);

                    String cardNo = spiderUserItemDataRow.getCardNo();
                    list.add(StringUtils.isBlank(cardNo) ? null : cardNo);

                    String sex = spiderUserItemDataRow.getSex();
                    list.add(StringUtils.isBlank(sex) ? null : sex);

                    String loginName = spiderUserItemDataRow.getLoginName();
                    list.add(StringUtils.isBlank(loginName) ? null : loginName);

                    list.add(StringUtils.isBlank(userSource) ? null : userSource);

                    list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), userSource, phone));

                    sqls.add(list);
                } catch (Exception e) {
                    log.error("用户详情清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(spiderUserItemDataRow), e);
                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.USER_INFO_ITEM);

                log.info("用户详情清洗数据完成, uuid: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });
    }

    public static void cleaningAndSaveMobileCallDetailInfo(List<MobileCallInfoRow> mobileCallInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {

                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();
                List<MobileCallDetailInfo> mobileCallDetailInfos = new ArrayList<>();

                for (int i = 0; i < mobileCallInfoRows.size(); i++) {

                    MobileCallInfoRow mobileCallInfoRow = mobileCallInfoRows.get(i);

                    try {
                        String phone = mobileCallInfoRow.getPhone();
                        List<String> list = new ArrayList<>();

                        String cTime = mobileCallInfoRow.getcTime();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);
                        list.add(TimeUtils.getCTimeFormat(cTime, Constant.OPERATOR.MOBILE_USERSOURCE_CALL, phone));

                        String tradeAddr = mobileCallInfoRow.getTradeAddr();
                        list.add(StringUtils.isBlank(tradeAddr) ? null : tradeAddr);

                        String tradeWay = mobileCallInfoRow.getTradeWay();
                        list.add(StringUtils.isBlank(tradeWay) ? null : tradeWay);

                        String tradeType = mobileCallInfoRow.getTradeType();
                        list.add(StringUtils.isBlank(tradeType) ? null : tradeType);

                        String receiverPhone = mobileCallInfoRow.getReceiverPhone();
                        list.add(PhoneUtils.getPhoneNoByRegx(receiverPhone, Constant.OPERATOR.MOBILE_USERSOURCE_CALL, phone));

                        String useTime = mobileCallInfoRow.getTradeTime();
                        list.add(NumberUtils.getUseTimeFormat(useTime, Constant.OPERATOR.MOBILE_USERSOURCE_CALL, phone));

                        String taocan = mobileCallInfoRow.getTaocan();
                        list.add(StringUtils.isBlank(taocan) ? null : taocan);

                        String onlinePay = mobileCallInfoRow.getOnlinePay();
                        list.add(StringUtils.isBlank(onlinePay) ? null : onlinePay);

                        list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.MOBILE_USERSOURCE_CALL, phone));

                        String iscm = mobileCallInfoRow.getIscm();
                        list.add(StringUtils.isBlank(iscm) ? null : iscm);

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.MOBILE_USERSOURCE_CALL, phone));

                        sqls.add(list);

                        mobileCallDetailInfos.add(mobileList2Bean(list));

                    } catch (Exception e) {
                        log.error("移动通话详单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(mobileCallInfoRow), e);
                    }

                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.MOBILE_DETAIL_INFOS);

                OperatorCallDetailListSendToKafkaService.sendMobileCallDetailListMessage(mobileCallDetailInfos);

                log.info("移动通话详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, mobileCallInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static void cleaningAndSaveMobileSmsDetainInfo(List<MobileSmsInfoRow> mobileSmsInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {

                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                for (int i = 0; i < mobileSmsInfoRows.size(); i++) {
                    MobileSmsInfoRow mobileSmsInfoRow = mobileSmsInfoRows.get(i);

                    try {
                        List<String> list = new ArrayList<>();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);

                        String phone = mobileSmsInfoRow.getPhone();

                        String allPay = mobileSmsInfoRow.getAllPay();
                        list.add(StringUtils.isBlank(allPay) ? null : allPay);

                        String createTs = mobileSmsInfoRow.getCreateTs();
                        list.add(StringUtils.isBlank(createTs) ? null : createTs);

                        list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.MOBILE_USERSOURCE_SMS, phone));

                        String receiverPhone = mobileSmsInfoRow.getReceiverPhone();
                        list.add(PhoneUtils.getPhoneNoByRegx(receiverPhone, Constant.OPERATOR.MOBILE_USERSOURCE_SMS, phone));

                        String sendAddr = mobileSmsInfoRow.getSentAddr();
                        list.add(StringUtils.isBlank(sendAddr) ? null : sendAddr);

                        String sendTime = mobileSmsInfoRow.getSentTime();
                        list.add(TimeUtils.getCTimeFormat(sendTime, Constant.OPERATOR.MOBILE_USERSOURCE_SMS, phone));

                        String tradeway = mobileSmsInfoRow.getTradeWay();
                        list.add(StringUtils.isBlank(tradeway) ? null : tradeway);

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.MOBILE_USERSOURCE_SMS, phone));

                        sqls.add(list);

                    } catch (Exception e) {
                        log.error("移动短信详单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(mobileSmsInfoRow), e);
                    }
                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.MOBILE_SMS_DETAIL_INFOS);

                log.info("移动短信详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, mobileSmsInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static void cleaningAndSaveMobileFlowDetailInfo(List<MobileFlowInfoRow> mobileFlowInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                for (int i = 0; i < mobileFlowInfoRows.size(); i++) {
                    MobileFlowInfoRow mobileFlowInfoRow = mobileFlowInfoRows.get(i);

                    try {
                        List<String> list = new ArrayList<>();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);

                        String phone = mobileFlowInfoRow.getPhone();

                        String cTime = mobileFlowInfoRow.getcTime();
                        list.add(TimeUtils.getCTimeFormat(cTime, Constant.OPERATOR.MOBILE_USERSOURCE_FLOW, phone));

                        String cheapService = mobileFlowInfoRow.getCheapService();
                        list.add(StringUtils.isBlank(cheapService) ? null : cheapService);

                        String communicationFees = mobileFlowInfoRow.getCommunicationFees();
                        list.add(StringUtils.isBlank(communicationFees) ? null : communicationFees);

                        String onlineTime = mobileFlowInfoRow.getOnlineTime();
                        list.add(NumberUtils.getUseTimeFormat(onlineTime, Constant.OPERATOR.MOBILE_USERSOURCE_FLOW, phone));

                        String onlineType = mobileFlowInfoRow.getOnlineType();
                        list.add(StringUtils.isBlank(onlineType) ? null : onlineType);

                        list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.MOBILE_USERSOURCE_FLOW, phone));

                        String totalFlow = mobileFlowInfoRow.getTotalFlow();
                        list.add(NumberUtils.flowFormat(totalFlow, Constant.OPERATOR.MOBILE_USERSOURCE_FLOW, phone));

                        String tradeAddr = mobileFlowInfoRow.getTradeAddr();
                        list.add(StringUtils.isBlank(tradeAddr) ? null : tradeAddr);

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.MOBILE_USERSOURCE_FLOW, phone));

                        sqls.add(list);

                    } catch (Exception e) {
                        log.error("移动流量详单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(mobileFlowInfoRow), e);
                    }

                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.MOBILE_FLOW_DETAIL_INFOS);

                log.info("移动流量详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, mobileFlowInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static void cleaningAndSaveTelecomCallDetailInfo(List<TelecomCallInfoRow> telecomCallInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();
                List<TelecomCallDetailInfo> telecomCallDetailInfos = new ArrayList<>();

                for (int i = 0; i < telecomCallInfoRows.size(); i++) {
                    TelecomCallInfoRow telecomCallInfoRow = telecomCallInfoRows.get(i);

                    try {
                        List<String> list = new ArrayList<>();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);

                        String phoneNo = telecomCallInfoRow.getPhone();

                        String tradeType = telecomCallInfoRow.getTradeType();
                        list.add(StringUtils.isBlank(tradeType) ? null : tradeType);

                        String cTime = telecomCallInfoRow.getcTime();
                        list.add(TimeUtils.getCTimeFormat(cTime, Constant.OPERATOR.TELECOM_USERSOURCE_CALL, phoneNo));

                        String tradeTime = telecomCallInfoRow.getTradeTime();
                        list.add(NumberUtils.getUseTimeFormat(tradeTime, Constant.OPERATOR.TELECOM_USERSOURCE_CALL, phoneNo));

                        String callWay = telecomCallInfoRow.getCallWay();
                        list.add(StringUtils.isBlank(callWay) ? null : callWay);

                        String receiverPhone = telecomCallInfoRow.getReceiverPhone();
                        list.add(PhoneUtils.getPhoneNoByRegx(receiverPhone, Constant.OPERATOR.TELECOM_USERSOURCE_CALL, phoneNo));

                        String tradeAddr = telecomCallInfoRow.getTradeAddr();
                        list.add(StringUtils.isBlank(tradeAddr) ? null : tradeAddr);

                        String basePay = telecomCallInfoRow.getBasePay();
                        list.add(StringUtils.isBlank(basePay) ? null : basePay);

                        String longPay = telecomCallInfoRow.getLongPay();
                        list.add(StringUtils.isBlank(longPay) ? null : longPay);

                        String infoPay = telecomCallInfoRow.getInfoPay();
                        list.add(StringUtils.isBlank(infoPay) ? null : infoPay);

                        String otherPay = telecomCallInfoRow.getOtherPay();
                        list.add(StringUtils.isBlank(otherPay) ? null : otherPay);

                        String allPay = telecomCallInfoRow.getAllPay();
                        list.add(StringUtils.isBlank(allPay) ? null : allPay);

                        list.add(PhoneUtils.getPhoneNoByRegx(phoneNo, Constant.OPERATOR.TELECOM_USERSOURCE_CALL, phoneNo));

                        String iscm = telecomCallInfoRow.getIscm();
                        list.add(StringUtils.isBlank(iscm) ? null : iscm);

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.TELECOM_USERSOURCE_CALL, phoneNo));

                        sqls.add(list);
                        telecomCallDetailInfos.add(telecomList2Bean(list));
                    } catch (Exception e) {
                        log.error("电信通话详单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(telecomCallInfoRow), e);
                    }

                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.TELECOM_DETAIL_INFOS);

                log.info("电信通话详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, telecomCallInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static void cleaningAndSaveTelecomSmsDetailInfo(List<TelecomSmsInfoRow> telecomSmsInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                for (int i = 0; i < telecomSmsInfoRows.size(); i++) {
                    TelecomSmsInfoRow telecomSmsInfoRow = telecomSmsInfoRows.get(i);

                    try {
                        List<String> list = new ArrayList<>();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);

                        String phone = telecomSmsInfoRow.getPhone();

                        String allPay = telecomSmsInfoRow.getAllPay();
                        list.add(StringUtils.isBlank(allPay) ? null : allPay);

                        String businessType = telecomSmsInfoRow.getBusinessType();
                        list.add(StringUtils.isBlank(businessType) ? null : businessType);

                        String createTs = telecomSmsInfoRow.getCreateTs();
                        list.add(StringUtils.isBlank(createTs) ? null : createTs);

                        list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.TELECOM_USERSOURCE_SMS, phone));

                        String receiverPhone = telecomSmsInfoRow.getReceiverPhone();
                        list.add(PhoneUtils.getPhoneNoByRegx(receiverPhone, Constant.OPERATOR.TELECOM_USERSOURCE_SMS, phone));

                        String sendTime = telecomSmsInfoRow.getSentTime();
                        list.add(TimeUtils.getCTimeFormat(sendTime, Constant.OPERATOR.TELECOM_USERSOURCE_SMS, phone));

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.TELECOM_USERSOURCE_SMS, phone));

                        sqls.add(list);

                    } catch (Exception e) {
                        log.error("电信短信详单解析异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(telecomSmsInfoRow), e);
                    }
                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.TELECOM_SMS_DETAIL_INFOS);

                log.info("电信短信详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, telecomSmsInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static void cleaningAndSaveTelecomFlowDetailInfo(List<TelecomFlowInfoRow> telecomFlowInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                for (int i = 0; i < telecomFlowInfoRows.size(); i++) {

                    TelecomFlowInfoRow telecomFlowInfoRow = telecomFlowInfoRows.get(i);

                    try {
                        List<String> list = new ArrayList<>();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);

                        String phone = telecomFlowInfoRow.getPhone();

                        String beginTime = telecomFlowInfoRow.getBeginTime();
                        list.add(TimeUtils.getCTimeFormat(beginTime, Constant.OPERATOR.TELECOM_USERSOURCE_FLOW, phone));

                        String busienss = telecomFlowInfoRow.getBusiness();
                        list.add(StringUtils.isBlank(busienss) ? null : busienss);

                        String fee = telecomFlowInfoRow.getFee();
                        list.add(StringUtils.isBlank(fee) ? null : fee);

                        String flow = telecomFlowInfoRow.getFlow();
                        list.add(NumberUtils.flowFormat(flow, Constant.OPERATOR.TELECOM_USERSOURCE_FLOW, phone));

                        String iscm = telecomFlowInfoRow.getIscm();
                        list.add(StringUtils.isBlank(iscm) ? null : iscm);

                        String location = telecomFlowInfoRow.getLocation();
                        list.add(StringUtils.isBlank(location) ? null : location);

                        String netType = telecomFlowInfoRow.getNetType();
                        list.add(StringUtils.isBlank(netType) ? null : netType);

                        list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.TELECOM_USERSOURCE_FLOW, phone));

                        String tradeTime = telecomFlowInfoRow.getTradeTime();
                        list.add(NumberUtils.getUseTimeFormat(tradeTime, Constant.OPERATOR.TELECOM_USERSOURCE_FLOW, phone));

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.TELECOM_USERSOURCE_FLOW, phone));

                        sqls.add(list);

                    } catch (Exception e) {
                        log.error("电信流量详单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(telecomFlowInfoRow), e);
                    }

                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.TELECOM_FLOW_DETAIL_INFOS);

                log.info("电信流量详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} ,  耗时: {} ", uuid, telecomFlowInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static void cleaningAndSaveUnicomCallDetailInfo(List<UnicomCallInfoRow> unicomCallInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();
                List<UnicomCallDetailInfo> unicomCallDetailInfos = new ArrayList<>();

                for (int i = 0; i < unicomCallInfoRows.size(); i++) {
                    UnicomCallInfoRow unicomCallInfoRow = unicomCallInfoRows.get(i);

                    try {
                        String phone = unicomCallInfoRow.getPhone();

                        List<String> list = new ArrayList<>();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);

                        String businessType = unicomCallInfoRow.getBusinessType();
                        list.add(StringUtils.isBlank(businessType) ? null : businessType);

                        String cTime = unicomCallInfoRow.getcTime();
                        list.add(TimeUtils.getCTimeFormat(cTime, Constant.OPERATOR.UNICOM_USERSOURCE_CALL, phone));

                        String tradeTime = unicomCallInfoRow.getTradeTime();
                        list.add(NumberUtils.getUseTimeFormat(tradeTime, Constant.OPERATOR.UNICOM_USERSOURCE_CALL, phone));

                        String callType = unicomCallInfoRow.getCallType();
                        list.add(StringUtils.isBlank(callType) ? null : callType);

                        String receiverPhone = unicomCallInfoRow.getReceiverPhone();
                        list.add(PhoneUtils.getPhoneNoByRegx(receiverPhone, Constant.OPERATOR.UNICOM_USERSOURCE_CALL, phone));

                        String tradeAddr = unicomCallInfoRow.getTradeAddr();
                        list.add(StringUtils.isBlank(tradeAddr) ? null : tradeAddr);

                        String tradeType = unicomCallInfoRow.getTradeType();
                        list.add(StringUtils.isBlank(tradeType) ? null : tradeType);

                        String basePay = unicomCallInfoRow.getBasePay();
                        list.add(StringUtils.isBlank(basePay) ? null : basePay);

                        String ldPay = unicomCallInfoRow.getLdPay();
                        list.add(StringUtils.isBlank(ldPay) ? null : ldPay);

                        String otherPay = unicomCallInfoRow.getOtherPay();
                        list.add(StringUtils.isBlank(otherPay) ? null : otherPay);

                        String totalPay = unicomCallInfoRow.getTotalPay();
                        list.add(StringUtils.isBlank(totalPay) ? null : totalPay);

                        list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.UNICOM_USERSOURCE_CALL, phone));

                        String iscm = unicomCallInfoRow.getIscm();
                        list.add(StringUtils.isBlank(iscm) ? null : iscm);

                        String reductionPay = unicomCallInfoRow.getReductionPay();
                        list.add(StringUtils.isBlank(reductionPay) ? null : reductionPay);

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.UNICOM_USERSOURCE_CALL, phone));

                        sqls.add(list);
                        unicomCallDetailInfos.add(unicomList2Bean(list));
                    } catch (Exception e) {
                        log.error("联通通话详单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(unicomCallInfoRow), e);
                    }

                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.UNICOM_DETAIL_INFOS);

                log.info("联通通话详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, unicomCallInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static void cleaningAndSaveUnicomSmsDetailInfo(List<UnicomSmsInfoRow> unicomSmsInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                for (int i = 0; i < unicomSmsInfoRows.size(); i++) {
                    UnicomSmsInfoRow unicomSmsInfoRow = unicomSmsInfoRows.get(i);

                    try {
                        List<String> list = new ArrayList<>();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);

                        String phone = unicomSmsInfoRow.getPhone();

                        String allPay = unicomSmsInfoRow.getAllPay();
                        list.add(StringUtils.isBlank(allPay) ? null : allPay);

                        String createTs = unicomSmsInfoRow.getCreateTs();
                        list.add(StringUtils.isBlank(createTs) ? null : createTs);

                        list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.UNICOM_USERSOURCE_SMS, phone));

                        String receiverPhone = unicomSmsInfoRow.getReceiverPhone();
                        list.add(StringUtils.isBlank(receiverPhone) ? null : receiverPhone);

                        String sendTime = unicomSmsInfoRow.getSentTime();
                        list.add(TimeUtils.getCTimeFormat(sendTime, Constant.OPERATOR.UNICOM_USERSOURCE_SMS, phone));

                        String tradeType = unicomSmsInfoRow.getTradeType();
                        list.add(StringUtils.isBlank(tradeType) ? null : tradeType);

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.UNICOM_USERSOURCE_SMS, phone));

                        sqls.add(list);

                    } catch (Exception e) {
                        log.error("联通短信详单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(unicomSmsInfoRow), e);
                    }

                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.UNICOM_SMS_DETAIL_INFOS);

                log.info("联通短信详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, unicomSmsInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static void cleaningAndSaveUnicomFlowDetailInfo(List<UnicomFlowInfoRow> unicomFlowInfoRows, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                for (int i = 0; i < unicomFlowInfoRows.size(); i++) {

                    UnicomFlowInfoRow unicomFlowInfoRow = unicomFlowInfoRows.get(i);

                    try {
                        List<String> list = new ArrayList<>();

                        list.add(StringUtils.isBlank(uuid) ? null : uuid);

                        String phone = unicomFlowInfoRow.getPhone();

                        String allFlow = unicomFlowInfoRow.getAllFlow();
                        list.add(NumberUtils.flowFormat(allFlow, Constant.OPERATOR.UNICOM_USERSOURCE_FLOW, phone));

                        String allPay = unicomFlowInfoRow.getAllPay();
                        list.add(StringUtils.isBlank(allPay) ? null : allPay);

                        String createTs = unicomFlowInfoRow.getCreateTs();
                        list.add(StringUtils.isBlank(createTs) ? null : createTs);

                        list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.UNICOM_USERSOURCE_FLOW, phone));

                        String startTime = unicomFlowInfoRow.getStartTime();
                        list.add(TimeUtils.getCTimeFormat(startTime, Constant.OPERATOR.UNICOM_USERSOURCE_FLOW, phone));

                        String tradeAddr = unicomFlowInfoRow.getTradeAddr();
                        list.add(StringUtils.isBlank(tradeAddr) ? null : tradeAddr);

                        String tradeType = unicomFlowInfoRow.getTradeType();
                        list.add(StringUtils.isBlank(tradeType) ? null : tradeType);

                        list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.UNICOM_USERSOURCE_FLOW, phone));

                        sqls.add(list);

                    } catch (Exception e) {
                        log.error("联通流量详单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(unicomFlowInfoRow), e);
                    }

                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.UNICOM_FLOW_DETAIL_INFOS);

                log.info("联通流量详单清洗完成, uuid: {} , 原始大小: {} , 清洗后大小: {} , 入库大小: {} , ka: {} ,  耗时: {} ", uuid, unicomFlowInfoRows.size(), sqls.size(), size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    /**
     * 手机号/账单月/账单金额
     *
     * @param phoneBillDataRow
     * @param uuid
     * @param ka
     */
    public static void cleaningAndSavePhoneBillInfo(PhoneBillDataRow phoneBillDataRow, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                try {
                    String phone = phoneBillDataRow.getPhoneNo();

                    List<String> list = new ArrayList<>();

                    list.add(StringUtils.isBlank(uuid) ? null : uuid);

                    list.add(PhoneUtils.getPhoneNoByRegx(phone, Constant.OPERATOR.PHONE_CALL_BILL, phone));

                    Date date = phoneBillDataRow.getBillDay();
                    list.add(TimeUtils.billDayFormat(date, Constant.OPERATOR.PHONE_CALL_BILL, phone));

                    String name = phoneBillDataRow.getName();
                    list.add(StringUtils.isBlank(name) ? null : name);

                    float amount = phoneBillDataRow.getAmount();

                    list.add(NumberUtils.amountToFormat(String.valueOf(amount), Constant.OPERATOR.PHONE_CALL_BILL, phone));

                    String dependCycle = phoneBillDataRow.getDependCycle();
                    list.add(StringUtils.isBlank(dependCycle) ? null : dependCycle);

                    String billPackage = phoneBillDataRow.getBillPackage();
                    list.add(StringUtils.isBlank(billPackage) ? null : billPackage);

                    String content = phoneBillDataRow.getContent();
                    list.add(StringUtils.isBlank(content) ? null : content);

                    list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.PHONE_CALL_BILL, phone));

                    sqls.add(list);

                } catch (Exception e) {
                    log.error("通话账单清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(phoneBillDataRow), e);
                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.PHONE_BILL_INFOS);

                log.info("通话账单清洗完成, uuid: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    /**
     *
     * @param phonePaymentDataRow
     * @param uuid
     * @param ka
     */
    public static void cleaningAndSaveRechargeInfo(PhonePaymentDataRow phonePaymentDataRow, String uuid, boolean ka) {

        ThreadPoolExecutorUtils.getThreadPoolUtil().execute(new Runnable() {
            @Override
            public void run() {
                Stopwatch stopwatch = Stopwatch.createStarted();

                List<List<String>> sqls = new ArrayList<>();

                try {
                    List<String> list = new ArrayList<>();

                    String phone = phonePaymentDataRow.getPhone();

                    list.add(StringUtils.isBlank(uuid) ? null : uuid);

                    list.add(phone);

                    Double payAmount = phonePaymentDataRow.getPayAmount();
                    list.add(NumberUtils.amountToFormat(String.valueOf(payAmount), Constant.OPERATOR.PHONE_RECHARGE_RECORDS, phone));

                    list.add(TimeUtils.payTimeToFormat(phonePaymentDataRow.getPayTime(), Constant.OPERATOR.PHONE_RECHARGE_RECORDS, phone));

                    String payMethod = phonePaymentDataRow.getPayMethod();
                    list.add(StringUtils.isBlank(payMethod) ? null : payMethod);

                    String payChannel = phonePaymentDataRow.getPayChannel();
                    list.add(StringUtils.isBlank(payChannel) ? null : payChannel);

                    String paySpare = phonePaymentDataRow.getPaySpare();
                    list.add(StringUtils.isBlank(paySpare) ? null : paySpare);

                    list.add(TimeUtils.timeStamp2Date(String.valueOf(System.currentTimeMillis()), Constant.OPERATOR.PHONE_RECHARGE_RECORDS, phone));

                    sqls.add(list);

                } catch (Exception e) {
                    log.error("充值记录清洗异常, uuid: {} , ka: {} , param: {} ", uuid, ka, JSON.toJSONString(phonePaymentDataRow), e);
                }

                int size = JdbcExecuters.batchExecute(sqls, Constant.SQL.PHONE_RECHARGE_INFOS);

                log.info("充值记录清洗完成, uuid: {} , 入库大小: {} , ka: {} , 耗时: {} ", uuid, size, ka, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        });

    }

    public static MobileCallDetailInfo mobileList2Bean(List<String> list){
//        uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,taocan,onlinePay,phone,iscm,timestamp

        MobileCallDetailInfo mobileCallDetailInfo = new MobileCallDetailInfo();
        mobileCallDetailInfo.setUuid(list.get(0));
        mobileCallDetailInfo.setcTime(list.get(1));
        mobileCallDetailInfo.setTradeAddr(list.get(2));
        mobileCallDetailInfo.setTradeWay(list.get(3));
        mobileCallDetailInfo.setTradeType(list.get(4));
        mobileCallDetailInfo.setReceiverPhone(list.get(5));
        mobileCallDetailInfo.setTradeTime(list.get(6));
        mobileCallDetailInfo.setTaocan(list.get(7));
        mobileCallDetailInfo.setOnlinePay(list.get(8));
        mobileCallDetailInfo.setPhone(list.get(9));
        mobileCallDetailInfo.setIscm(list.get(10));
        mobileCallDetailInfo.setTimestamp(list.get(11));
        mobileCallDetailInfo.setSource(Constant.OPERATOR.MOBILE);
        return mobileCallDetailInfo;
    }

    public static TelecomCallDetailInfo telecomList2Bean(List<String> list){
//uuid,tradeType,cTime,tradeTime,callWay,receiverPhone,tradeAddr,basePay,longPay,infoPay,otherPay,allPay,phone,iscm,timestamp
        TelecomCallDetailInfo telecomCallDetailInfo = new TelecomCallDetailInfo();
        telecomCallDetailInfo.setUuid(list.get(0));
        telecomCallDetailInfo.setTradeType(list.get(1));
        telecomCallDetailInfo.setcTime(list.get(2));
        telecomCallDetailInfo.setTradeTime(list.get(3));
        telecomCallDetailInfo.setCallWay(list.get(4));
        telecomCallDetailInfo.setReceiverPhone(list.get(5));
        telecomCallDetailInfo.setTradeAddr(list.get(6));
        telecomCallDetailInfo.setBasePay(list.get(7));
        telecomCallDetailInfo.setLongPay(list.get(8));
        telecomCallDetailInfo.setInfoPay(list.get(9));
        telecomCallDetailInfo.setOtherPay(list.get(10));
        telecomCallDetailInfo.setAllPay(list.get(11));
        telecomCallDetailInfo.setPhone(list.get(12));
        telecomCallDetailInfo.setIscm(list.get(13));
        telecomCallDetailInfo.setTimestamp(list.get(14));
        telecomCallDetailInfo.setSource(Constant.OPERATOR.TELECOM);
        return telecomCallDetailInfo;
    }

    public static UnicomCallDetailInfo unicomList2Bean(List<String> list){
//uuid,businessType,cTime,tradeTime,callType,receiverPhone,tradeAddr,tradeType,basePay,ldPay,otherPay,totalPay,phone,iscm,reductionPay,timestamp
        UnicomCallDetailInfo unicomCallDetailInfo = new UnicomCallDetailInfo();
        unicomCallDetailInfo.setUuid(list.get(0));
        unicomCallDetailInfo.setBusinessType(list.get(1));
        unicomCallDetailInfo.setcTime(list.get(2));
        unicomCallDetailInfo.setTradeTime(list.get(3));
        unicomCallDetailInfo.setReceiverPhone(list.get(5));
        unicomCallDetailInfo.setCallType(list.get(4));
        unicomCallDetailInfo.setTradeAddr(list.get(6));
        unicomCallDetailInfo.setTradeType(list.get(7));
        unicomCallDetailInfo.setBasePay(list.get(8));
        unicomCallDetailInfo.setLdPay(list.get(9));
        unicomCallDetailInfo.setOtherPay(list.get(10));
        unicomCallDetailInfo.setTotalPay(list.get(11));
        unicomCallDetailInfo.setPhone(list.get(12));
        unicomCallDetailInfo.setIscm(list.get(13));
        unicomCallDetailInfo.setReductionPay(list.get(14));
        unicomCallDetailInfo.setTimestamp(list.get(15));
        unicomCallDetailInfo.setSource(Constant.OPERATOR.UNICOM);
        return unicomCallDetailInfo;
    }


}
