package cn.quantgroup.qgdataservice.utils;


import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.regex.Pattern;

/**
 * @Author fengjunkai
 * @Date 2019-05-14 18:08
 */
public class PhoneUtils {

    private static final Logger log = LoggerFactory.getLogger(PhoneUtils.class);

    public static String getPhoneNoByRegx(String enterStr, String userSource, String phone) {

        if (StringUtils.isBlank(enterStr)) {
            return null;
        }

        try {
            String phoneNo = Pattern.compile("[^0-9]").matcher(enterStr).replaceAll("");

            if (StringUtils.startsWith(phoneNo, "86125832")) {
                return phoneNo.replaceFirst("86125832", "");
            } else if (StringUtils.startsWith(phoneNo, "0086125832")) {
                return StringUtils.replaceFirst(phoneNo, "0086125832", "");
            } else if (13 == phoneNo.length() && StringUtils.startsWith(phoneNo, "86")) {
                return phoneNo.replaceFirst("86", "");
            } else if (13 == phoneNo.length() && StringUtils.startsWith(phoneNo, "001")) {
                return phoneNo.replaceFirst("00", "");
            } else if (StringUtils.startsWith(phoneNo, "+86")) {
                return phoneNo.replaceFirst("\\+86", "");
            } else if (StringUtils.startsWith(phoneNo, "0086")) {
                return phoneNo.replaceFirst("0086", "");
            }

        } catch (Exception e) {
            log.error("运营商 ( {} ) 解析用户余额异常, phone: {} , enterStr: {} ", userSource, phone, enterStr, e);
        }

        return enterStr;

    }

}
