package cn.quantgroup.qgdataservice.utils;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

/**
 * 数据清洗时间工具类
 *
 * @Author fengjunkai
 * @Date 2019-05-14 16:52
 */
public class TimeUtils {

    private static final Logger log = LoggerFactory.getLogger(TimeUtils.class);

    private static final String ERROR_TIME = "1960-01-01 00:00:00";

    public static String registerDateFormat(Date enterDate, String userSource, String phone) {

        if (Objects.isNull(enterDate)) {
            return null;
        }

        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            if (timeCompar(enterDate, enterDate)) return null;

            String outDate = simpleDateFormat.format(enterDate);

            if (!outDate.startsWith("1") && !outDate.startsWith("2")) return null;

            return outDate;
        } catch (Exception e) {
            log.error("运营商 ( {} ) 解析用户注册时间异常, phone: {} , enterStr: {} ", userSource, phone, enterDate, e);
            return null;
        }
    }

    public static String registerDateFormat(String enterStr, String userSource, String phone) {

        if (StringUtils.isBlank(enterStr)) {
            return null;
        }

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        try {
            Date errorDate = sdf.parse(ERROR_TIME);

            if (!enterStr.startsWith("1") && !enterStr.startsWith("2")) { //将YYYY第一个Y不是1或2的错误数据，填为空
                return null;
            }

            if (isLongDate(enterStr, userSource, phone)) {  //时间戳（1590909284321）这种，转为YYYY-MM-DD HH:mm:ss
                String enterTime = sdf.format(new Date(Long.valueOf(enterStr)));
                Date enterDate = sdf.parse(enterTime);

                if (timeCompar(enterDate, errorDate)) return null;

                return enterTime;
            }

            if (enterStr.contains("年") && enterStr.contains("月") && enterStr.contains("秒")) {  //时间带年/月的这种，比如“2019年1月1日”，转为2019-01-01 00:00:00

                String tempTime = enterStr.replaceAll("年", "-").replaceAll("月", "-")
                        .replaceAll("日", "").replaceAll("时", ":").replaceAll("分", ":")
                        .replaceAll("秒", "");
                String time = sdf.format(tempTime);

                if (timeCompar(sdf.parse(time), errorDate)) return null;

                return time;

            }

            Date date = sdf.parse(enterStr);

            if (timeCompar(date, errorDate)) return null;

            return enterStr;

        } catch (Exception e) {
            log.error("运营商 ( {} ) 解析用户注册时间异常, phone: {} , enterStr: {} ", userSource, phone, enterStr, e);
        }

        return enterStr;
    }

    public static String getCTimeFormat(String cTime, String userSource, String phone) {


        if (StringUtils.isBlank(cTime)) {
            return null;
        }

        if (!cTime.startsWith("1") && !cTime.startsWith("2")) {
            return null;
        }

        String errorTime = "1960-01-01 00:00:00";
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date errorDate = simpleDateFormat1.parse(errorTime);

            int cTimeLength = cTime.length();
            String cTimeStr = cTime.trim();
            if (19 == cTimeLength) {

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = simpleDateFormat.parse(cTimeStr);
                if (date.compareTo(errorDate) <= 0 || date.compareTo(new Date()) > 0) {
                    return null;
                }
                return cTimeStr;

            } else if (20 == cTimeLength && cTimeStr.contains("年") && cTimeStr.contains("分")) {

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd日HH时mm分ss秒");
                Date date = simpleDateFormat.parse(cTimeStr);
                if (date.compareTo(errorDate) <= 0 || date.compareTo(new Date()) > 0) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return simpleDateFormat2.format(date);

            } else if (21 == cTimeLength && cTimeStr.contains("年") && cTimeStr.contains("分")) {

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd日 HH时mm分ss秒");
                Date date = simpleDateFormat.parse(cTimeStr);
                if (date.compareTo(errorDate) <= 0 || date.compareTo(new Date()) > 0) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return simpleDateFormat2.format(cTimeStr);

            } else if (13 == cTimeLength && isLongDate(cTimeStr, userSource, phone)) { //1590909284321

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date(Long.valueOf(cTimeStr));
                if (date.compareTo(errorDate) <= 0 || date.compareTo(new Date()) > 0) {
                    return null;
                }
                return simpleDateFormat.format(date);

            }

        } catch (ParseException e) {
            log.error("运营商详单 ( {} ) 解析用户通话开始时间异常, phone: {} , enterStr: {} ", userSource, phone, cTime, e);
        }

        return cTime;

    }

    public static String billDayFormat(Date enterDate, String userSource, String phone) {

        if (Objects.isNull(enterDate)) {
            return null;
        }

        String dateFormatStr = "";

        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
            dateFormatStr = simpleDateFormat.format(enterDate);
            if (!dateFormatStr.startsWith("1") && !dateFormatStr.startsWith("2")) {
                return null;
            }

            return dateFormatStr;

        } catch (Exception e) {
            log.error("运营商详单 ( {} ) 解析用户账单开始时间异常, phone: {} , enterStr: {} ", userSource, phone, enterDate, e);
            return null;
        }

//
//        if (StringUtils.isBlank(dateFormatStr)) {
//            return null;
//        }


//        String dateStr = dateFormatStr.replaceAll("年", "").replaceAll("月", "").replaceAll("日", "");
//        if (dateStr.length() == 6) {
//            try {
//                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
//                sdf.parse(dateStr);
//                return dateStr;
//            } catch (Exception e) {
////                System.out.println("======" + dataType + "异常======" + dateFormatStr);
//            }
//            return dateFormatStr;
//        }
//
//        if (isLongDate(dateFormatStr, userSource, phone)) {
//            try {
//                Date date = new Date(Long.valueOf(dateFormatStr));
//                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
//                return simpleDateFormat.format(date);
//            } catch (Exception e) {
////                System.out.println("======" + dataType + "时间戳转日期yyyyMM异常======" + dateFormatStr);
//                return dateFormatStr;
//            }
//        }
//
//        try {
//            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd,yyyy HH:mm:ss a", Locale.ENGLISH);
//            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
//            return simpleDateFormat.format(sdf.parse(dateFormatStr));
//        } catch (ParseException e) {
////            System.out.printf("======" + dataType + "异常======" + dateFormatStr);
//        }
//        return dateFormatStr;
    }

    public static String payTimeToFormat(Date payTime, String userSource, String phone) {

        String payDate = "";

        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            payDate = simpleDateFormat.format(payTime);

            if (!payDate.startsWith("1") && !payDate.startsWith("2")) {
                return null;
            } else {
                SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date errDate = simpleDateFormat1.parse(ERROR_TIME);
                return payTime.compareTo(errDate) > 0 && payTime.compareTo(new Date()) <= 0 ? payDate : null;
            }

        } catch (Exception e) {
            log.error("运营商 ( {} ) 解析用户缴费时间异常, phone: {} , enterStr: {} ", userSource, phone, payTime, e);
        }

        return null;
    }

    public static String timeStamp2Date(String enterStr, String userSource, String phone) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(new Date(Long.valueOf(enterStr)));
        } catch (Exception e) {
            log.error("运营商 ( {} ) 解析用户注册时间异常, phone: {} , enterStr: {} ", userSource, phone, enterStr, e);
        }
        return null;
    }

    private static boolean timeCompar(Date enterDate, Date errorDate) {

        if (enterDate.compareTo(errorDate) < 0) { //将小于1960-01-01 00:00:00的错误数据，填为空
            return true;
        }

        if (new Date().compareTo(enterDate) < 0) { //大于授权日的入网时间，填为空 当前时间
            return true;
        }

        return false;
    }

    private static boolean isLongDate(String enterStr, String userSource, String phone) {
        if (StringUtils.length(enterStr) == 13) {
            try {
                Long.valueOf(enterStr);
                return true;
            } catch (Exception e) {
            }
        }
        return false;
    }

    public static void main(String[] args) {
//        List<PhoneBillDataRow> phoneBillDataRows = PhoneBillDataService.get("18612632691");
//        System.out.println(JSON.toJSONString(phoneBillDataRows));
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
        System.out.println(simpleDateFormat.format(date));
    }

}
