package cn.quantgroup.dbc.utils;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Author fengjunkai
 * @Date 2019-04-26 16:00
 */
public class NumberUtil {

    public static boolean isNumeric(String str){
        Pattern pattern = Pattern.compile("-?[0-9]+(.[0-9]+)?");
        Matcher isNum = pattern.matcher(str);
        if( !isNum.matches() ){
            return false;
        }
        return true;
    }

    public static String amountToFormat(String amount, String dataType){
        try{
            String amountTmep = amount.replaceAll("元", "");
            if(isNumeric(amountTmep)){
                if(amountTmep.contains("-")){
                    return new BigDecimal(0.00).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                }
                return new BigDecimal(amountTmep).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
            }else if(amount.startsWith("-") || amount.contains("E") || amount.contains("e")){
                return new BigDecimal(0.00).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
            }
        }catch(Exception e){
            System.out.println("======"+dataType+"======"+amount);
        }

        return amount;
    }


    public static String flowFormat(String flow_temp, String dataType) {
        try {

            if(StringUtils.isBlank(flow_temp) || StringUtils.startsWith(flow_temp, "-")){
                return null;
            }

            BigDecimal mb2Kb = new BigDecimal("0");
            BigDecimal gb2Kb = new BigDecimal("0");
            BigDecimal kb = new BigDecimal("0");
            BigDecimal thou = new BigDecimal("1024");
            flow_temp = flow_temp.replaceAll(" ", "").replace("&nbsp;", "").replace("(", "").replace(")", "").replace("（", "").replace("）", "");
            // 全角空格这么霸道...by Pat。Liu
            flow_temp = flow_temp.replaceAll("　", "");
            flow_temp = flow_temp.replaceAll("-", "");
            if (flow_temp.contains("GB") || flow_temp.contains("MB") || flow_temp.contains("KB")) {
                if (flow_temp.contains("GB")) {
                    gb2Kb = new BigDecimal(flow_temp.split("GB")[0].trim()).multiply(thou).multiply(thou);
                }
                if (flow_temp.contains("MB")) {
                    if (flow_temp.contains("GB"))
                        mb2Kb = new BigDecimal(flow_temp.split("GB")[1].split("MB")[0].trim()).multiply(thou);
                    else
                        mb2Kb = new BigDecimal(flow_temp.split("MB")[0].trim()).multiply(thou);
                }
                if (flow_temp.contains("KB")) {
                    if (flow_temp.contains("MB")) {
                        kb = new BigDecimal(subStr("MB", "KB", flow_temp).trim());
                    } else if (flow_temp.contains("GB")) {
                        kb = new BigDecimal(subStr("GB", "KB", flow_temp).trim());
                    } else {
                        kb = new BigDecimal(flow_temp.split("KB")[0].trim());
                    }
                }
            }else if(isNumeric(flow_temp)){
                BigDecimal d  = new BigDecimal(flow_temp).setScale(2, BigDecimal.ROUND_HALF_UP);
                return String.valueOf(d);
            } else {
                if (flow_temp.contains("G")) {
                    gb2Kb = new BigDecimal(flow_temp.split("G")[0].trim()).multiply(thou).multiply(thou);
                }
                if (flow_temp.contains("M")) {
                    if (flow_temp.contains("G"))
                        mb2Kb = new BigDecimal(flow_temp.split("G")[1].split("M")[0].trim()).multiply(thou);
                    else
                        mb2Kb = new BigDecimal(flow_temp.split("M")[0].trim()).multiply(thou);
                }
                if (flow_temp.contains("K")) {
                    if (flow_temp.contains("M")) {
                        kb = new BigDecimal(subStr("M", "K", flow_temp).trim());
                    } else if (flow_temp.contains("G")) {
                        kb = new BigDecimal(subStr("G", "K", flow_temp).trim());
                    } else {
                        kb = new BigDecimal(flow_temp.split("K")[0].trim());
                    }
                }
            }

            BigDecimal d  = gb2Kb.add(mb2Kb).add(kb).setScale(2, BigDecimal.ROUND_HALF_UP);
            return String.valueOf(d);
        } catch (Exception e) {
            System.out.println("======"+dataType+"======异常"+flow_temp);
            return null;
        }
    }

    public static String getUseTimeFormat(String time, String dataType) {
        if(StringUtils.isBlank(time)){
            return null;
        }

        if(StringUtils.startsWith(time, "-")){
            return null;
        }

        try{
            long allTime = 0, hour2Second = 0, min2Second = 0, second = 0;
            if (time.contains(":")) {
                if(time.length() == 7 && time.indexOf(":") == 1){
                    time = "0"+time;
                }
                if(time.length() == 8){
                    second = new Long(time.substring(6, 8));
                    min2Second = new Long(time.substring(3, 5));
                    hour2Second = new Long(time.substring(0, 2));
                } else if(time.split(":").length == 3){
                    String[] timeStrs = time.split(":");
                    second = new Long(timeStrs[2]);
                    min2Second = new Long(timeStrs[1]);
                    hour2Second = new Long(timeStrs[0]);
                }
                allTime = hour2Second * 3600 + min2Second * 60 + second;
                return String.valueOf(allTime);
            } else {
                if (time.contains("时")) {
                    if (time.contains("小时"))
                        hour2Second = Long.parseLong(time.split("小时")[0].trim()) * 60 * 60;
                    else
                        hour2Second = Long.parseLong(time.split("时")[0].trim()) * 60 * 60;
                }
                if (time.contains("分")) {
                    if (time.contains("时")) {
                        min2Second = Long.parseLong(subStr("时", "分", time)) * 60;
                    } else {
                        String strs [] = time.split("分");
                        min2Second = Long.parseLong(strs[0].trim()) * 60;
                        try{
                            if(strs.length>1&&!strs[1].contains("秒") && StringUtils.isNumeric(strs[1])){
                                second =  Long.parseLong(strs[1].trim());
                            }
                        }catch(Exception e){
                            e.printStackTrace();
                        }
                    }
                }
                if (time.contains("秒")) {
                    if (time.contains("分")) {
                        if (time.contains("分钟"))
                            second = Long.parseLong(subStr("分钟", "秒", time).trim());
                        else
                            second = Long.parseLong(subStr("分", "秒", time).trim());
                    } else if (time.contains("时")) {
                        if (time.contains("小时"))
                            second = Long.parseLong(subStr("小时", "秒", time).trim());
                        else
                            second = Long.parseLong(subStr("时", "秒", time).trim());
                    } else {
                        second = Long.parseLong(time.split("秒")[0].trim());
                    }
                }
                allTime = hour2Second + min2Second + second;
                if(allTime==0){
                    if(time!=null){
                        try {
                            if(time.contains(".")){
                                time = time.substring(0,time.indexOf("."));
                            }
                            allTime = Long.parseLong(time.trim().replaceAll("\\D+?", ""));
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }

                }
                return String.valueOf(allTime);
            }
        }catch(Exception e){
            System.out.println("======"+dataType+"异常======"+time);
        }
        return time;
    }

    public static String subStr(String stext, String etext, String text) {
        int sindex = text.indexOf(stext);
        if (sindex >= 0) {
            int eindex = text.indexOf(etext, sindex);
            if (eindex >= 0) {
                String ctext = text.substring(sindex + stext.length(), eindex);
                return ctext;
            }
        }
        return "";
    }

}
