package cn.quantgroup.dbc.spark.unicom;

import cn.quantgroup.dbc.bean.MobileFlowInfo;
import cn.quantgroup.dbc.bean.UnicomFlowInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 联通流量详单
 *
 *
 * 手机号/开始时间/使用流量/上网时间
 *
 *  耗费流量/费用/未使用/手机号/上网开始时间/地点/上网类型/创建时间
 *
 *  /app/user/data/deeplearning/export_data/unicom_flow_info/mt=1556380800000
 *
 *
 * @Author fengjunkai
 * @Date 2019-05-09 15:02
 */
public class UnicomFlowDetailInfoMain {

    public static void main(String[] args) {

        System.out.println("==========联通流量详单任务开始执行=============");

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();


        //用户信息加载
        Dataset<String> user = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/user_info/part-00000");
        Dataset<UserInfo> userInfoDataset = user.map((MapFunction<String, UserInfo>) line -> {
            UserInfo person = new UserInfo();
            String[] split = line.split("\t");
            person.setPhone(split[0]);
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======"+userInfoDataset.head().getPhone());
        System.out.println("======================="+userInfoDataset.where("phone='18500192679'").head().getUuid());

        //联通流量详单加载
        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/unicom_flow_info/"+args[0]+"/*");

        Dataset<UnicomFlowInfo> mobileFlowMap = dataset.map((MapFunction<String, UnicomFlowInfo>) line -> {
            String[] split = line.split("\t");
            UnicomFlowInfo unicomFlowInfo = new UnicomFlowInfo();

            String phone = split[4];
            String beginTime = split[5];
            String totalFlow = split[1];
            String allPay = split[2];
            String createTs = split[3];
            String tradeAddr = split[6];
            String tradeType = split[7];
            String time = split[8];
            try {
                unicomFlowInfo.setAllFlow(StringUtils.isBlank(totalFlow)?null:NumberUtil.flowFormat(totalFlow, "联通流量详单耗费流量"));
                unicomFlowInfo.setAllPay(StringUtils.isBlank(allPay)?null:allPay);
                unicomFlowInfo.setCreateTs(StringUtils.isBlank(createTs)?null:createTs);
                unicomFlowInfo.setPhone(StringUtils.isBlank(phone)?null:PhoneNoUtils.getPhoneNoByRegx(phone, "联通流量详单手机号"));
                unicomFlowInfo.setStartTime(StringUtils.isBlank(beginTime)?null:DateUtil.getCTimeFormat(beginTime, "联通流量详单开始时间"));
                unicomFlowInfo.setTradeAddr(StringUtils.isBlank(tradeAddr)?null:tradeAddr);
                unicomFlowInfo.setTradeType(StringUtils.isBlank(tradeType)?null:tradeType);
                unicomFlowInfo.setTimestamp(StringUtils.isBlank(time)?null:DateUtil.timeStamp2Date(time, "联通流量详单创建时间"));

            }catch (Exception e){
                e.printStackTrace();
                System.out.println("=============未知异常============");
            }
            return unicomFlowInfo;
        }, Encoders.bean(UnicomFlowInfo.class));

        System.out.println("==========联通流量清洗完成=============");

        Dataset<Row> finalRow = mobileFlowMap.join(userInfoDataset, "phone");
        System.out.println("==============join完成================");

        Dataset<Row> limit = finalRow.limit(10);
        System.out.println("=================字段======"+limit.columns().toString());
        limit.show();
        List<Row> rows = limit.collectAsList();
        for (Row row:rows){
            System.out.println("================"+row.toString());
        }

        ArrayList<String> sqls = new ArrayList<>(300);
        finalRow.foreach(row->{
            try {
                List<String> list = new ArrayList<>();
                try {
                    list.add(row.getString(1));  //allFlow
                    list.add(row.getString(2)); //allPay
                    list.add(row.getString(3)); //createTs
                    list.add(row.getString(0)); //phone
                    list.add(row.getString(4)); //startTime
                    list.add(row.getString(6)); //tradeAddr
                    list.add(row.getString(7)); //tradeType
                    list.add(row.getString(5)); //timestamp
                    String uuid =row.getString(8);

                    String sql = "INSERT IGNORE INTO comservice_i_unicom_flow_info (uuid,allFlow,allPay,createTs,phone,startTime,tradeAddr,tradeType,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
                    if(sqls.size()!=0&&sqls.size()%200==0){
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    }else{
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }
                } catch (Exception e) {
                }
            } catch (ArrayIndexOutOfBoundsException a) {
            } catch (Exception e) {
                System.out.println("======联通流量未知异常======" + row.toString());
            }
        });

        JdbcExecuters.batchUpdateExecute(sqls);




















        /**

        List<String> list1 = Arrays.asList(args).subList(2, args.length);
        System.out.println("======入参======" + JSON.toJSONString(args));
        System.out.println("======入参数据块======" + JSON.toJSONString(list1));

        List<String> textFileList = new ArrayList<>();
        String hdfs1 = "hdfs:///app/user/data/deeplearning/export_data/unicom_flow_info/" + args[0] + "/%s";
        for (int i = 0; i < list1.size(); i++) {
            textFileList.add(String.format(hdfs1, list1.get(i)));
        }

        Map<String, String[]> textFileMap = PagingUtil.paging(textFileList, Integer.valueOf(args[1]));

        ArrayList<String> sqls = new ArrayList<>(300);

        textFileMap.forEach((k, v) -> {
            System.out.println("======" + k + "读取的hdfs======" + JSON.toJSONString(v));
            Dataset<String> dataset = ss.read().textFile(v);
            dataset.foreach(o -> {
                try {
                    String[] split = o.split("\t");
                    List<String> list = new ArrayList<>();

                    System.out.println("======原始数据======"+JSON.toJSONString(split));

                    String phone = split[4];
                    String beginTime = split[5];
                    String totalFlow = split[1];

                    try {
                        list.add(StringUtils.isBlank(totalFlow)?null:NumberUtil.flowFormat(totalFlow, "联通流量详单耗费流量"));

                        String allPay = split[2];
                        list.add(StringUtils.isBlank(allPay)?null:allPay);

                        String createTs = split[3];
                        list.add(StringUtils.isBlank(createTs)?null:createTs);

                        list.add(StringUtils.isBlank(phone)?null:PhoneNoUtils.getPhoneNoByRegx(phone, "联通流量详单手机号"));

                        list.add(StringUtils.isBlank(beginTime)?null:DateUtil.getCTimeFormat(beginTime, "联通流量详单开始时间"));

                        String tradeAddr = split[6];
                        list.add(StringUtils.isBlank(tradeAddr)?null:tradeAddr);

                        String tradeType = split[7];
                        list.add(StringUtils.isBlank(tradeType)?null:tradeAddr);

                        String time = split[8];
                        list.add(StringUtils.isBlank(time)?null:DateUtil.timeStamp2Date(time, "联通流量详单创建时间"));


                    } catch (Exception e) {
                    }


                    String uuid = JedisUtil.jedisClient.getString(phone);
//                    if (StringUtils.isEmpty(uuid)) {
//                        uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");
//                        System.out.println("===========uuid未命中==============");
//                    }

                    String sql = "INSERT IGNORE INTO comservice_i_unicom_flow_info (uuid,allFlow,allPay,createTs,phone,startTime,tradeAddr,tradeType,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";

                    if (sqls.size() != 0 && sqls.size() % 200 == 0) {
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    } else {
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }

                } catch (ArrayIndexOutOfBoundsException a) {
                    System.out.println("======联通流量详单出现关键字段数组越界======" + o);
                } catch (Exception e) {
                    System.out.println("======联通流量详单出现未知异常======" + o);
                    e.printStackTrace();
                }

            });

        });
         **/

        System.out.println("=====================联通流量详单执行完毕");
        ss.close();

    }

}
