package cn.quantgroup.dbc.spark.transactionlog;

import cn.quantgroup.dbc.utils.JdbcExecuters;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author fengjunkai
 */
public class TransactionLog {

    private String transaction_id;
    private String uuid;
    private String url_type;
    private String code;
    private Timestamp created_at;
    private Timestamp updated_at;

    public Timestamp getCreated_at() {
        return created_at;
    }

    public void setCreated_at(Timestamp created_at) {
        this.created_at = created_at;
    }

    public Timestamp getUpdated_at() {
        return updated_at;
    }

    public void setUpdated_at(Timestamp updated_at) {
        this.updated_at = updated_at;
    }

    public String getTransaction_id() {
        return transaction_id;
    }

    public void setTransaction_id(String transaction_id) {
        this.transaction_id = transaction_id;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUrl_type() {
        return url_type;
    }

    public void setUrl_type(String url_type) {
        this.url_type = url_type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static void main(String[] args) {
        try{
            String str = "5a3b9545edaf4d0a968b3725229758b4\t6352705c-8f53-4470-9db5-cc26f38d1ec8\tBaiRongSpecialList_c\t1002\t2019-01-08 09:58:35.0";
            String[] tmp = str.split("\t");
            TransactionLog transactionLog = new TransactionLog();
            transactionLog.setCode(tmp[3]);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp timestamp = new Timestamp(simpleDateFormat.parse(tmp[4]).getTime());
            transactionLog.setCreated_at(timestamp);
            transactionLog.setTransaction_id(tmp[0]);
            transactionLog.setUuid(tmp[1]);
            transactionLog.setUrl_type(tmp[2]);
            transactionLog.setUpdated_at(timestamp);
            List<TransactionLog> logs = new ArrayList<>();
            logs.add(transactionLog);
            String sql = "INSERT INTO `call_record` (`request_url`, `transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?,?,?,?,?,?,?)";
            JdbcExecuters.prepareBatchUpdateExecuteTransactionid(sql, logs);
        }catch(Exception e){
            e.printStackTrace();
        }
    }

}
