package cn.quantgroup.dbc.spark.mobile;

import cn.quantgroup.dbc.bean.MobileCallDetailInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

/**
 * 移动通话详单
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-21 11:04 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1501516800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-21 10:37 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1504108800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 11:43 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1506700800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 11:15 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1509292800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 12:12 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1511884800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 10:40 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1514476800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 11:49 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1517068800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 10:08 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1519660800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 10:34 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1522252800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 09:54 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1524844800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 10:24 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1527436800000--第11个月
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 10:15 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1530028800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 16:01 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1532620800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 14:52 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1535212800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 14:29 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1537804800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 15:51 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1540396800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 15:39 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1542988800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 14:18 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1545580800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 15:10 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1548172800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 15:26 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1550764800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-22 14:41 /app/user/data/deeplearning/export_data/mobile_call_info/mt=1553356800000 ----running
 *
 *
 *
 * spark2-submit --master yarn --deploy-mode cluster \
 * --driver-memory 4g \
 * --executor-memory 30g --num-executors 30 \
 * --executor-cores 15 --queue online_job \
 * --class cn.quantgroup.dbc.spark.mobile.MobileDetailInfo1551Main \
 * /home/feng.ren/qg-dbc-spark-4.0-SNAPSHOT-mobile-detail-info-jar-with-dependencies.jar "mt=1553356800000" "000000_0" "000001_0" "000002_0" "000003_0" "000004_0" "000005_0" "000006_0" "000007_0" "000008_0" "000009_0" "000010_0" "000011_0" "000012_0" "000013_0" "000014_0" "000015_0" "000016_0" "000017_0" "000018_0" "000019_0" "000020_0" "000021_0" "000022_0" "000023_0" "000024_0" "000025_0" "000026_0" "000027_0" "000028_0" "000029_0" "000030_0" "000031_0" "000032_0" "000033_0" "000034_0" "000035_0" "000036_0" "000037_0" "000038_0" "000039_0" "000040_0" "000041_0" "000042_0" "000043_0" "000044_0" "000045_0" "000046_0" "000047_0" "000048_0" "000049_0" "000050_0" "000051_0" "000052_0" "000053_0" "000054_0" "000055_0" "000056_0" "000057_0" "000058_0" "000059_0" "000060_0" "000061_0" "000062_0" "000063_0" "000064_0" "000065_0" "000066_0" "000067_0" "000068_0" "000069_0" "000070_0" "000071_0" "000072_0" "000073_0" "000074_0" "000075_0" "000076_0" "000077_0" "000078_0" "000079_0" "000080_0" "000081_0" "000082_0" "000083_0" "000084_0" "000085_0" "000086_0" "000087_0" "000088_0" "000089_0" "000090_0" "000091_0" "000092_0" "000093_0" "000094_0" "000095_0" "000096_0" "000097_0" "000098_0" "000099_0" "000100_0" "000101_0" "000102_0" "000103_0" "000104_0" "000105_0" "000106_0" "000107_0" "000108_0" "000109_0" "000110_0" "000111_0" "000112_0" "000113_0" "000114_0" "000115_0" "000116_0" "000117_0" "000118_0" "000119_0" "000120_0" "000121_0" "000122_0" "000123_0" "000124_0" "000125_0" "000126_0" "000127_0" "000128_0" "000129_0" "000130_0" "000131_0" "000132_0" "000133_0" "000134_0" "000135_0" "000136_0" "000137_0" "000138_0" "000139_0" "000140_0" "000141_0" "000142_0" "000143_0" "000144_0" "000145_0" "000146_0" "000147_0" "000148_0" "000149_0" "000150_0" "000151_0" "000152_0" "000153_0" "000154_0" "000155_0" "000156_0" "000157_0" "000158_0" "000159_0" "000160_0" "000161_0" "000162_0" "000163_0" "000164_0" "000165_0" "000166_0" "000167_0" "000168_0" "000169_0" "000170_0" "000171_0" "000172_0" "000173_0" "000174_0" "000175_0" "000176_0" "000177_0" "000178_0" "000179_0" "000180_0" "000181_0" "000182_0" "000183_0" "000184_0" "000185_0" "000186_0" "000187_0" "000188_0" "000189_0" "000190_0" "000191_0" "000192_0" "000193_0" "000194_0" "000195_0" "000196_0" "000197_0" "000198_0" "000199_0" "000200_0" "000201_0" "000202_0" "000203_0" "000204_0" "000205_0" "000206_0" "000207_0" "000208_0" "000209_0" "000210_0" "000211_0" "000212_0" "000213_0" "000214_0" "000215_0" "000216_0" "000217_0" "000218_0" "000219_0" "000220_0" "000221_0" "000222_0" "000223_0" "000224_0" "000225_0" "000226_0" "000227_0" "000228_0" "000229_0" "000230_0" "000231_0" "000232_0" "000233_0" "000234_0" "000235_0" "000236_0" "000237_0" "000238_0" "000239_0" "000240_0" "000241_0" "000242_0" "000243_0" "000244_0" "000245_0" "000246_0" "000247_0" "000248_0" "000249_0" "000250_0" "000251_0" "000252_0" "000253_0" "000254_0" "000255_0" "000256_0" "000257_0" "000258_0" "000259_0" "000260_0" "000261_0" "000262_0" "000263_0" "000264_0" "000265_0" "000266_0" "000267_0" "000268_0" "000269_0" "000270_0" "000271_0" "000272_0" "000273_0" "000274_0" "000275_0" "000276_0" "000277_0" "000278_0" "000279_0" "000280_0" "000281_0" "000282_0" "000283_0" "000284_0" "000285_0" "000286_0" "000287_0" "000288_0" "000289_0" "000290_0" "000291_0" "000292_0" "000293_0" "000294_0" "000295_0" "000296_0" "000297_0" "000298_0" "000299_0" "000300_0" "000301_0" "000302_0" "000303_0" "000304_0" "000305_0" "000306_0" "000307_0" "000308_0" "000309_0" "000310_0" "000311_0" "000312_0" "000313_0" "000314_0" "000315_0" "000316_0" "000317_0" "000318_0" "000319_0" "000320_0" "000321_0" "000322_0" "000323_0" "000324_0" "000325_0" "000326_0" "000327_0" "000328_0" "000329_0" "000330_0" "000331_0" "000332_0" "000333_0" "000334_0" "000335_0" "000336_0" "000337_0" "000338_0" "000339_0" "000340_0" "000341_0" "000342_0" "000343_0" "000344_0" "000345_0" "000346_0" "000347_0" "000348_0" "000349_0" "000350_0" "000351_0" "000352_0" "000353_0" "000354_0" "000355_0" "000356_0" "000357_0" "000358_0" "000359_0" "000360_0" "000361_0" "000362_0" "000363_0" "000364_0" "000365_0" "000366_0" "000367_0" "000368_0" "000369_0" "000370_0" "000371_0" "000372_0" "000373_0" "000374_0" "000375_0" "000376_0" "000377_0" "000378_0" "000379_0" "000380_0" "000381_0" "000382_0" "000383_0" "000384_0" "000385_0" "000386_0" "000387_0" "000388_0" "000389_0" "000390_0" "000391_0" "000392_0" "000393_0" "000394_0" "000395_0" "000396_0" "000397_0" "000398_0" "000399_0" "000400_0" "000401_0" "000402_0" "000403_0" "000404_0" "000405_0" "000406_0" "000407_0" "000408_0" "000409_0" "000410_0" "000411_0" "000412_0" "000413_0" "000414_0" "000415_0" "000416_0" "000417_0" "000418_0" "000419_0" "000420_0" "000421_0" "000422_0" "000423_0" "000424_0" "000425_0" "000426_0" "000427_0" "000428_0" "000429_0" "000430_0" "000431_0" "000432_0" "000433_0" "000434_0" "000435_0" "000436_0" "000437_0" "000438_0" "000439_0" "000440_0" "000441_0" "000442_0" "000443_0" "000444_0" "000445_0" "000446_0" "000447_0" "000448_0" "000449_0" "000450_0" "000451_0" "000452_0" "000453_0" "000454_0" "000455_0" "000456_0" "000457_0" "000458_0" "000459_0" "000460_0" "000461_0" "000462_0" "000463_0" "000464_0" "000465_0" "000466_0" "000467_0" "000468_0" "000469_0" "000470_0" "000471_0" "000472_0" "000473_0" "000474_0" "000475_0" "000476_0" "000477_0" "000478_0" "000479_0" "000480_0" "000481_0" "000482_0" "000483_0" "000484_0" "000485_0" "000486_0" "000487_0" "000488_0" "000489_0" "000490_0" "000491_0" "000492_0" "000493_0" "000494_0" "000495_0" "000496_0" "000497_0" "000498_0" "000499_0" "000500_0" "000501_0" "000502_0" "000503_0" "000504_0"
 *
 * @Author fengjunkai
 * @Date 2019-04-29 10:19
 */
public class MobileDetailInfo1555Main {

    public static void main(String[] args) {
        System.out.println("==========移动通话详单1555任务开始执行============");

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();

        //用户信息加载
        Dataset<String> user = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/user_info/part-00000");
        Dataset<UserInfo> userInfoDataset = user.map((MapFunction<String, UserInfo>) line -> {
            UserInfo person = new UserInfo();
            String[] split = line.split("\t");
            person.setPhone(split[0]);
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======"+userInfoDataset.head().getPhone());
        System.out.println("======================="+userInfoDataset.where("phone='18500192679'").head().getUuid());



        //移动通话详单加载
        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/mobile_call_info/"+args[0]+"/*");

        Dataset<MobileCallDetailInfo> mobileMap = dataset.map((MapFunction<String, MobileCallDetailInfo>) line -> {
            String[] split = line.split("\t");
            MobileCallDetailInfo mobileCallDetailInfo = new MobileCallDetailInfo();
            String phone = PhoneNoUtils.getPhoneNoByRegx(split[9], "移动主叫号码");
            String cTime = split[1];
            String recevPhone = split[5];
            String useTime = split[6];
            try {
                phone = StringUtils.isBlank(phone) ? null : phone.replaceAll(" ", "");
                mobileCallDetailInfo.setPhone(phone);
                mobileCallDetailInfo.setThlx(StringUtils.isBlank(split[4]) ? null : split[4]);
                mobileCallDetailInfo.setThkssj(StringUtils.isBlank(split[1]) ? null : DateUtil.getCTimeFormat(cTime, "移动通话开始时间"));
                mobileCallDetailInfo.setThsj(StringUtils.isBlank(split[6]) ? null : NumberUtil.getUseTimeFormat(useTime, "移动通话耗时"));
                mobileCallDetailInfo.setZbj(StringUtils.isBlank(split[3]) ? null : split[3]);
                mobileCallDetailInfo.setBjhm(StringUtils.isBlank(split[5]) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "移动被叫号码"));
                mobileCallDetailInfo.setThdd(StringUtils.isBlank(split[2]) ? null : split[2]);
                mobileCallDetailInfo.setWsy1(StringUtils.isBlank(split[7]) ? null : split[7]);
                mobileCallDetailInfo.setWsy2(StringUtils.isBlank(split[10]) ? null : split[10]);
                mobileCallDetailInfo.setThfy(StringUtils.isBlank(split[8]) ? null : split[8]);
                mobileCallDetailInfo.setZjhm(phone);
                mobileCallDetailInfo.setRksj(StringUtils.isBlank(split[11]) ? null : DateUtil.timeStamp2Date(split[11], "移动通话详单"));
            }catch (Exception e){
                e.printStackTrace();
                System.out.println("=============未知异常============");
            }
            return mobileCallDetailInfo;
        }, Encoders.bean(MobileCallDetailInfo.class));

        System.out.println("==========移动清洗完成=============");

        Dataset<Row> finalRow = mobileMap.join(userInfoDataset, "phone");
        System.out.println("==============join完成================");

//        Dataset<Row> limit = finalRow.limit(10);
//        System.out.println("=================字段======"+limit.columns().toString());
//        limit.show();
//        List<Row> rows = limit.collectAsList();
//        for (Row row:rows){
//            System.out.println("================"+row.toString());
//        }
        ArrayList<String> sqls = new ArrayList<>(300);
        finalRow.foreach(row->{
            try {
                List<String> list = new ArrayList<>();
                try {
                    list.add(row.getString(5));  //通话开始时间
                    list.add(row.getString(3)); //通话地点
                    list.add(row.getString(10)); //通话类型/主叫/被叫/其他
                    list.add(row.getString(6)); //通话类别
                    list.add(row.getString(1)); //被叫号码
                    list.add(row.getString(7)); //通话时间s
                    list.add(row.getString(8)); //套餐   未使用
                    list.add(row.getString(4)); //通话费用
                    list.add(row.getString(11));   //手机号
                    list.add(row.getString(9)); //未使用
                    list.add(row.getString(2)); //抓取时间,入库时间

                    String uuid =row.getString(12);

                    String sql = "INSERT IGNORE INTO comservice_i_mobile_call_info (uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,taocan,onlinePay,phone,iscm,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
                    if(sqls.size()!=0&&sqls.size()%200==0){
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    }else{
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }
                } catch (Exception e) {
                }
            } catch (ArrayIndexOutOfBoundsException a) {
            } catch (Exception e) {
                System.out.println("======移动未知异常======" + row.toString());
            }
        });
        JdbcExecuters.batchUpdateExecute(sqls);
        System.out.println("=====================移动通话详单执行完毕");
        ss.close();




/**
        dataset.foreach(o -> {
            try{
                String[] split = o.split("\t");
                List<String> list = new ArrayList<>();

                String phone = PhoneNoUtils.getPhoneNoByRegx(split[9], "移动主叫号码");


                String cTime = split[1];
                String recevPhone = split[5];
                String useTime = split[6];

                try{
                    list.add(StringUtils.isBlank(split[1]) ? null : DateUtil.getCTimeFormat(cTime, "移动通话开始时间"));  //通话开始时间
                    list.add(StringUtils.isBlank(split[2]) ? null : split[2]); //通话地点
                    list.add(StringUtils.isBlank(split[3]) ? null : split[3]); //通话类型/主叫/被叫/其他
                    list.add(StringUtils.isBlank(split[4]) ? null : split[4]); //通话类别
                    list.add(StringUtils.isBlank(split[5]) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "移动被叫号码")); //被叫号码
                    list.add(StringUtils.isBlank(split[6]) ? null : NumberUtil.getUseTimeFormat(useTime, "移动通话耗时")); //通话时间s
                    list.add(StringUtils.isBlank(split[7]) ? null : split[7]); //套餐   未使用
                    list.add(StringUtils.isBlank(split[8]) ? null : split[8]); //通话费用
                    list.add(StringUtils.isBlank(phone) ? null : StringUtils.replaceAll(phone, " ", ""));   //手机号
                    list.add(StringUtils.isBlank(split[10]) ? null : split[10]); //未使用
                    list.add(StringUtils.isBlank(split[11]) ? null : DateUtil.timeStamp2Date(split[11], "移动通话详单")); //抓取时间,入库时间
                }catch(Exception e){}

                String uuid = "";
                if (StringUtils.isNotBlank(phone)) {
                    uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");
                }

                String sql = "INSERT IGNORE INTO comservice_i_mobile_call_info (uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,taocan,onlinePay,phone,iscm,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";

                JdbcExecuters.batchUpdateExecute(SqlUtil.getExecuteSql(list, sql), o);
            }catch(ArrayIndexOutOfBoundsException a){
                System.out.println("======移动通话详单出现关键字段数组越界======"+o);
            }catch(Exception e){
                System.out.println("======移动通话详单出现位置异常======"+o);
            }

        });

        System.out.println("=====================移动通话详单执行完毕");
         */
//        ss.close();
    }

}
