package cn.quantgroup.dbc.spark.june;

import cn.quantgroup.dbc.bean.TeleconCallDetailInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

public class TelecomCallInfoApp {

    public static void main(String[] args) {

        System.out.println("==========电信通话详单任务开始执行=============任务数=" + args.length);
        System.out.println("本次导入" +  args[0]);

        SparkSession ss = SparkSession.builder().appName("TelecomCallInfoApp").getOrCreate();

        Dataset<UserInfo> userInfoDataset = ss.read().parquet("hdfs:///app/user/data/user_data/feng.ren/user_parquet").map(row -> {
            UserInfo userInfo = new UserInfo();
            userInfo.setPhone(row.getAs("phone"));
            userInfo.setUuid(row.getAs("uuid"));
            return userInfo;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======" + userInfoDataset.head().getPhone());
        System.out.println("======用户加载总数量======" + userInfoDataset.count());

        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/telecom_call_info/" + args[0]);

        Dataset<TeleconCallDetailInfo> telecomMap = dataset.filter(row -> row.split("\t", -1).length > 14)
                .map(row -> {
                    String[] split = row.split("\t", -1);
                    TeleconCallDetailInfo teleconCallDetailInfo = new TeleconCallDetailInfo();
                    String phone = PhoneNoUtils.getPhoneNoByRegx(split[12], "电信主叫号码");
                    String cTime = split[2];
                    String recevPhone = split[5];
                    String useTime = split[3];
                    try {
                        phone = StringUtils.isBlank(phone) ? null : phone.replaceAll(" ", "");
                        teleconCallDetailInfo.setPhone(phone);
                        teleconCallDetailInfo.setThlx(StringUtils.isBlank(split[1]) ? null : split[1]);
                        teleconCallDetailInfo.setThkssj(StringUtils.isBlank(split[2]) ? null : DateUtil.getCTimeFormat(cTime, "电信通话开始时间"));
                        teleconCallDetailInfo.setThsj(StringUtils.isBlank(split[3]) ? null : NumberUtil.getUseTimeFormat(useTime, "电信通话时间"));
                        teleconCallDetailInfo.setZbj(StringUtils.isBlank(split[4]) ? null : split[4]);
                        teleconCallDetailInfo.setBjhm(StringUtils.isBlank(split[5]) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "电信被叫号码"));
                        teleconCallDetailInfo.setThdd(StringUtils.isBlank(split[6]) ? null : split[6]);
                        teleconCallDetailInfo.setWsy1(StringUtils.isBlank(split[7]) ? null : split[7]);
                        teleconCallDetailInfo.setWsy2(StringUtils.isBlank(split[8]) ? null : split[8]);
                        teleconCallDetailInfo.setWsy3(StringUtils.isBlank(split[9]) ? null : split[9]);
                        teleconCallDetailInfo.setWsy4(StringUtils.isBlank(split[10]) ? null : split[10]);
                        teleconCallDetailInfo.setThfy(StringUtils.isBlank(split[11]) ? null : split[11]);
                        teleconCallDetailInfo.setZjhm(phone);
                        teleconCallDetailInfo.setWsy5(StringUtils.isBlank(split[13]) ? null : split[13]);
                        teleconCallDetailInfo.setRksj(StringUtils.isBlank(split[14]) ? null : DateUtil.timeStamp2Date(split[14], "电信通话入库时间"));
                    } catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("=============未知异常============");
                    }
                    return teleconCallDetailInfo;
                }, Encoders.bean(TeleconCallDetailInfo.class));

        System.out.println("==========电信清洗完成=============");


        Dataset<Row> finalRow = telecomMap.join(userInfoDataset, "phone");

        System.out.println("======join总数量======" + finalRow.count());


        String sql = "INSERT IGNORE INTO comservice_i_telecom_call_info (uuid,tradeType,cTime,tradeTime,callWay,receiverPhone,tradeAddr,basePay,longPay,infoPay,otherPay,allPay,phone,iscm,timestamp) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

        finalRow.foreachPartition(line -> {
            List<List<String>> paramList = new ArrayList<>(500);

            line.forEachRemaining(row -> {
                try {
                    List<String> list = new ArrayList<>();
                    String uuid = StringUtils.isBlank(row.getAs("uuid")) ? null : row.getAs("uuid");
                    list.add(uuid);

                    list.add(row.getAs("thlx"));  //通话类型
                    list.add(row.getAs("thkssj")); //通话开始时间
                    list.add(row.getAs("thsj")); //通话时间s
                    list.add(row.getAs("zbj")); //主叫、被叫、其他
                    list.add(row.getAs("bjhm")); //被叫号码
                    list.add(row.getAs("thdd")); //通话地点
                    list.add(row.getAs("wsy1")); //未使用
                    list.add(row.getAs("wsy2")); //未使用
                    list.add(row.getAs("wsy3")); //未使用
                    list.add(row.getAs("wsy4")); //未使用
                    list.add(row.getAs("thfy")); //通话费用
                    list.add(row.getAs("zjhm")); //主叫号码
                    list.add(row.getAs("wsy5")); //未使用
                    list.add(row.getAs("rksj")); //抓取时间,入库时间

                    paramList.add(list);

                    if (paramList.size() != 0 && paramList.size() % 500 == 0) {
                        JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
                        paramList.clear();
                    }

                } catch (Exception e) {
                    System.out.println("======电信位置异常======" + row.toString());
                }
            });

            JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
        });


        System.out.println("=====================电信通话详单执行完毕");
        ss.close();
    }

}
