package cn.quantgroup.dbc.spark;

import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.*;

/**
 * Created by renfeng on 2019/5/7.
 */
public class UserInputReidsMain {


    public static void main(String[] args) throws InterruptedException {



        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();

        System.out.println("===================load开始===============");

        Dataset<Row> load = ss.read()
                .format("jdbc")
                .option("driver", "com.mysql.jdbc.Driver")
                .option("url", "jdbc:mysql://10.17.115.6:4010/rc_real_time_data_pool?useUnicode=true&characterEncoding=UTF8&rewriteBatchedStatements=true")
                .option("useSSL", "false")
                .option("dbtable", "xyqb_user_i_user") // database name and table name here
                .option("isolationLevel", "NONE") // recommended to set isolationLevel to NONE if you have a large DF to load.
                .option("user", "rc_real_time_data_pool_r")
                .option("password", "0lSEnS1HtvysJbP5") // TiDB user here
                .load();


        System.out.println("===================load完成===============");


        Dataset<String> map = load.map((MapFunction<Row, String>) line -> {
            return line.getString(1) + "\t" + line.getString(4);
        }, Encoders.STRING());

        System.out.println("===================map完成===============");

//        map.write().mode(SaveMode.Overwrite).parquet("hdfs:///app/user/data/user_data/feng.ren/user_parquet");

        map.toJavaRDD().saveAsTextFile("hdfs:///app/user/data/user_data/feng.ren/user_info");


//        String phone = line.getString(1);
//        String uuid = line.getString(4);




        System.out.println("===================任务执行结束===============");



    }








}
