package cn.quantgroup.dbc.spark;

import cn.quantgroup.dbc.utils.DateUtil;
import cn.quantgroup.dbc.utils.JdbcExecuters;
import cn.quantgroup.dbc.utils.NumberUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author fengjunkai
 * @Date 2019-04-26 14:03
 */
public class PhonePaymentInfoMain {

    //uuid phone paytime paymethod payamount paychannel payspare timestamp


    public static void main(String[] args) {

        System.out.println("======充值记录任务开始执行======");

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();

        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/phone_payment_info/*/*");

        dataset.foreach(o -> {
            String[] split = o.split("\t");
            List<String> list = new ArrayList<>();
            String phone = "";
            try {
                phone = split[1];
                list.add(StringUtils.isBlank(phone) ? null : clearPhone(phone.replaceAll(" ", "")));
                list.add(StringUtils.isBlank(split[2]) ? null : NumberUtil.amountToFormat(split[2], "充值金额账单金额"));
                list.add(StringUtils.isBlank(split[3]) ? null : DateUtil.dateString2Format(split[3], "缴费充值时间"));
                try{
                    list.add(StringUtils.isBlank(split[4]) ? null : split[4]);  //充值方式
                    list.add(StringUtils.isBlank(split[5]) ? null : split[5]); //充值渠道
                    list.add(StringUtils.isBlank(split[6]) ? null : split[6]); //payspare
                    list.add(StringUtils.isBlank(split[7]) ? null : DateUtil.timeStamp2Date(split[7], "充值记录入库时间"));
                }catch(Exception e){}

                String uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");

                JdbcExecuters.batchUpdateExecute(getExecuteSql(list, uuid), o);

            } catch (ArrayIndexOutOfBoundsException q) {  //关键字段异常
                System.out.println("======关键字段数组越界======"+o);
                q.printStackTrace();
            } catch (Exception e) {
                System.out.println("======充值记录未知异常======" + o);
                e.printStackTrace();
            }

        });
        ss.close();
        System.out.println("======充值记录任务执行完毕======");


//        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
//
//        Dataset<String> ds = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/phone_payment_info/*/*");
//
//        Dataset<String> limit = ds.limit(100000);
//
//
//        Dataset<ComserviceIPhonePaymentInfo> map = limit.map((MapFunction<String, ComserviceIPhonePaymentInfo>) line -> {
//            String[] split = line.split("\t");
//
//            System.out.println("======原始数据======"+line);
//
//            String phone = split[1];
//            String uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");
//            ComserviceIPhonePaymentInfo comserviceIPhonePaymentInfo = new ComserviceIPhonePaymentInfo();
//            comserviceIPhonePaymentInfo.setPhone(StringUtils.isBlank(phone) ? null : clearPhone(phone));
//            comserviceIPhonePaymentInfo.setPayamount(StringUtils.isBlank(split[2]) ? null : NumberUtil.amountToFormat(split[2], "充值金额账单金额"));
//            comserviceIPhonePaymentInfo.setPaytime(StringUtils.isBlank(split[3]) ? null : DateUtil.dateString2Format(split[3], "缴费充值时间"));
//            comserviceIPhonePaymentInfo.setPaymethod(StringUtils.isBlank(split[4]) ? null : split[4]);
//            comserviceIPhonePaymentInfo.setPaychannel(StringUtils.isBlank(split[5]) ? null : split[5]);
//            comserviceIPhonePaymentInfo.setTimestamp(StringUtils.isBlank(split[6])?null:DateUtil.timeStamp2Date(split[6], "充值记录入库时间"));
//            comserviceIPhonePaymentInfo.setUuid(uuid);
//            return comserviceIPhonePaymentInfo;
//        }, Encoders.bean(ComserviceIPhonePaymentInfo.class));
//
//        System.out.println("======清洗数据完成");
//
//        long startTime = System.currentTimeMillis();
//        Dataset<ComserviceIPhonePaymentInfo> duplicates = map.dropDuplicates(new String[]{"phone", "paytime", "paymethod"});
//
//        long endTime = System.currentTimeMillis();
//        System.out.println("=====去重完毕======"+(endTime-startTime));
//
//
//        duplicates.repartition(36).write()
//                .mode("append")
//                .format("jdbc")
//                .option("driver", "com.mysql.jdbc.Driver")
//                .option("url", "jdbc:mysql://10.17.115.6:4010/rc_comservice_data_pool_v2?useUnicode=true&characterEncoding=UTF8&rewriteBatchedStatements=true")
//                .option("useSSL", "false")
//                .option(JDBCOptions.JDBC_BATCH_INSERT_SIZE(), 200)
//                .option("dbtable", "comservice_i_phone_payment_info") // database name and table name here
//                .option("isolationLevel", "NONE") // recommended to set isolationLevel to NONE if you have a large DF to load.
//                .option("user", "rc_comservice_data_pool_v2_w")
//                .option("password", "w9pr8IPJkLmUSBe4") // TiDB user here
//                .save();
//        ss.stop();
//        ss.close();

//        System.out.println("==========手机充值记录任务开始执行=============");
////        SparkConf conf = new SparkConf().setAppName("DBC");
//
//        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
//
//        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/phone_payment_info/*/*");
//
//        System.out.println("========phone_payment_info表总行数======" + dataset.count());
//
//        dataset = dataset.limit(10);
//
//        dataset.foreach(o -> {
//            System.out.println("======原始记录======" + o);
//            String split[] = o.split("\t");
//
//            List<String> list = new ArrayList<>();
//            String phone = split[1];
//            list.add(StringUtils.isBlank(phone) ? null : phone); //手机号
//            list.add(StringUtils.isBlank(split[2]) ? null : split[2]); //充值时间
//            list.add(StringUtils.isBlank(split[3]) ? null : split[3]); //充值方式
//            list.add(StringUtils.isBlank(split[4]) ? null : split[4]); //充值金额
//            list.add(StringUtils.isBlank(split[5]) ? null : split[5]); //充值渠道
//
//            System.out.println("======list======" + JSON.toJSONString(list));
//
//        });
//
//        System.out.println("======完事======");


    }

    public static String getExecuteSql(List<String> list, String uuid) {
        String str = "INSERT IGNORE INTO comservice_i_phone_payment_info (uuid,phone,payamount,paytime,paymethod,paychannel,payspare,timestamp) values (" + (org.apache.commons.lang3.StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
        String formatStr = "";
        for (int i = 0; i < list.size(); i++) {
            String string = list.get(i);
            if (string == null) {
                formatStr += (string + (i == list.size() - 1 ? "" : ","));
            } else {
                formatStr += ("'" + string + "'" + (i == list.size() - 1 ? "" : ","));
            }
        }
        String executeSql = String.format(str, formatStr);
//        System.out.println("===========执行sql========="+executeSql);
        return executeSql;
    }

    public static String clearPhone(String phoneNo) {
        if (StringUtils.isBlank(phoneNo)) {
            return null;
        }

        if (phoneNo.startsWith("86125832")) {
            return phoneNo.replaceFirst("86125832", "");
        } else if (phoneNo.startsWith("0086")) {
            return phoneNo.replaceFirst("0086", "");
        } else if (phoneNo.startsWith("86")) {
            return phoneNo.replaceFirst("86", "");
        }

//        if(StringUtils.startsWithAny(phoneNo, new String[]{"86", "0086", "86125832"})){
//            phoneNo = phoneNo.replaceFirst("86", "") // 单独剔除
//                    .replaceFirst("0086", "")
//                    .replaceFirst("86125832", "86125832");
//        }

        return phoneNo;
    }


}
