package cn.quantgroup.dbc.spark.unicom;

import cn.quantgroup.dbc.bean.TeleconCallDetailInfo;
import cn.quantgroup.dbc.bean.UnicomCallDetailInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

/**
 * 联通通话详单
 * <p>
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-24 12:12 /app/user/data/deeplearning/export_data/unicom_call_info/mt=1555948800000 ----running
 *
 * spark2-submit --master yarn --deploy-mode cluster \
 * --driver-memory 4g \
 * --executor-memory 24g --num-executors 20 \
 * --executor-cores 10 --queue online_job \
 * --class cn.quantgroup.dbc.spark.unicom.UnicomDetailInfoMain \
 * /home/feng.ren/qg-dbc-spark-4.0-SNAPSHOT-unicom-detail-info-jar-with-dependencies.jar "mt=1555948800000" "000000_0" "000001_0" "000002_0" "000003_0" "000004_0" "000005_0" "000006_0" "000007_0" "000008_0" "000009_0" "000010_0" "000011_0" "000012_0" "000013_0" "000014_0" "000015_0" "000016_0" "000017_0" "000018_0" "000019_0" "000020_0" "000021_0" "000022_0" "000023_0" "000024_0" "000025_0" "000026_0" "000027_0" "000028_0" "000029_0" "000030_0" "000031_0" "000032_0" "000033_0" "000034_0" "000035_0" "000036_0" "000037_0" "000038_0" "000039_0" "000040_0" "000041_0" "000042_0" "000043_0" "000044_0" "000045_0" "000046_0" "000047_0" "000048_0" "000049_0" "000050_0" "000051_0" "000052_0" "000053_0" "000054_0" "000055_0" "000056_0" "000057_0" "000058_0" "000059_0" "000060_0" "000061_0" "000062_0" "000063_0" "000064_0" "000065_0" "000066_0" "000067_0" "000068_0" "000069_0" "000070_0" "000071_0" "000072_0" "000073_0" "000074_0" "000075_0" "000076_0" "000077_0" "000078_0" "000079_0" "000080_0" "000081_0" "000082_0" "000083_0" "000084_0" "000085_0" "000086_0" "000087_0" "000088_0" "000089_0" "000090_0" "000091_0" "000092_0" "000093_0" "000094_0" "000095_0" "000096_0" "000097_0" "000098_0" "000099_0" "000100_0" "000101_0" "000102_0" "000103_0" "000104_0" "000105_0" "000106_0" "000107_0" "000108_0" "000109_0" "000110_0" "000111_0" "000112_0" "000113_0" "000114_0" "000115_0" "000116_0" "000117_0" "000118_0" "000119_0" "000120_0" "000121_0" "000122_0" "000123_0" "000124_0" "000125_0" "000126_0" "000127_0" "000128_0" "000129_0" "000130_0" "000131_0" "000132_0" "000133_0" "000134_0" "000135_0" "000136_0" "000137_0" "000138_0" "000139_0" "000140_0" "000141_0" "000142_0" "000143_0" "000144_0" "000145_0" "000146_0" "000147_0" "000148_0" "000149_0" "000150_0" "000151_0" "000152_0" "000153_0" "000154_0" "000155_0"
 *
 * @Author fengjunkai
 * @Date 2019-04-29 10:20
 */
public class UnicomDetailInfoMain {

    public static void main(String[] args) {

        System.out.println("=========联通通话详单任务开始执行=============任务数=" + args.length);

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();

        Dataset<String> user = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/user_info/part-00000");

        Dataset<UserInfo> userInfoDataset = user.map((MapFunction<String, UserInfo>) line -> {
            UserInfo person = new UserInfo();
            String[] split = line.split("\t");
            person.setPhone(split[0]);
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======"+userInfoDataset.head().getPhone());
        System.out.println("======================="+userInfoDataset.where("phone='18500192679'").head().getUuid());

        String hdfs = "hdfs:///app/user/data/deeplearning/export_data/unicom_call_info/%s/*";

        String arg[] = new String[args.length];

        for(int i=0;i<args.length;i++){
            arg[i] = String.format(hdfs, args[i]);
        }

        System.out.println("======读取参数======"+ JSON.toJSONString(arg));
//        System.out.println("======读取参数======"+ JSON.toJSONString(args));
        Dataset<String> dataset = ss.read().textFile(arg);
//        Dataset<String> dataset = ss.read().textFile(hdfs);

        Dataset<UnicomCallDetailInfo> unicomCallMap = dataset.map((MapFunction<String, UnicomCallDetailInfo>) line -> {
            String[] split = line.split("\t");
            UnicomCallDetailInfo unicomCallDetailInfo = new UnicomCallDetailInfo();
            String phone = PhoneNoUtils.getPhoneNoByRegx(split[12], "联通主叫号码");

            String cTime = split[2];
            String recevPhone = split[5];
            String useTime = split[3];

            try{
                unicomCallDetailInfo.setBusinessType(StringUtils.isBlank(split[1]) ? null : split[1]);
                unicomCallDetailInfo.setcTime(StringUtils.isBlank(cTime) ? null : DateUtil.getCTimeFormat(cTime, "联通通话开始时间"));
                unicomCallDetailInfo.setTradeTime(StringUtils.isBlank(useTime) ? null : NumberUtil.getUseTimeFormat(useTime, "联通通话时间"));
                unicomCallDetailInfo.setCallType(StringUtils.isBlank(split[4]) ? null : split[4]);
                unicomCallDetailInfo.setReceiverPhone(StringUtils.isBlank(recevPhone) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "联通被叫号码"));
                unicomCallDetailInfo.setTradeAddr(StringUtils.isBlank(split[6]) ? null : split[6]);
                unicomCallDetailInfo.setTradeType(StringUtils.isBlank(split[7]) ? null : split[7]);
                unicomCallDetailInfo.setBasePay(StringUtils.isBlank(split[8]) ? null : split[8]);
                unicomCallDetailInfo.setLdPay(StringUtils.isBlank(split[9]) ? null : split[9]);
                unicomCallDetailInfo.setOtherPay(StringUtils.isBlank(split[10]) ? null : split[10]);
                unicomCallDetailInfo.setTotalPay(StringUtils.isBlank(split[11]) ? null : split[11]);
                unicomCallDetailInfo.setPhone(StringUtils.isBlank(phone) ? null : PhoneNoUtils.getPhoneNoByRegx(phone.replaceAll(" ", ""), "联通主叫号码"));
                unicomCallDetailInfo.setIscm(StringUtils.isBlank(split[13]) ? null : split[13]);
                unicomCallDetailInfo.setReductionPay(StringUtils.isBlank(split[14]) ? null : split[14]);
                unicomCallDetailInfo.setTimestamp(StringUtils.isBlank(split[15]) ? null : DateUtil.timeStamp2Date(split[15], "联通入库时间"));
            }catch(Exception e){
                System.out.println("======未知异常======");
                e.printStackTrace();
            }
            return unicomCallDetailInfo;
        }, Encoders.bean(UnicomCallDetailInfo.class));

        System.out.println("==========联通清洗完成=============");


        Dataset<Row> finalRow = unicomCallMap.join(userInfoDataset, "phone");
        System.out.println("==============join完成================");
//        Dataset<Row> limit = finalRow.limit(10);
//        System.out.println("=================字段======"+limit.columns());
//        limit.show();
//        List<Row> rows = limit.collectAsList();
//        for (Row row:rows){
//            System.out.println("================"+row.toString());
//        }

        ArrayList<String> sqls = new ArrayList<>(300);
        finalRow.foreach(row->{
            try {
                List<String> list = new ArrayList<>();
                try {
                    list.add(row.getString(2));
                    list.add(row.getString(3));
                    list.add(row.getString(13));
                    list.add(row.getString(4));
                    list.add(row.getString(8));
                    list.add(row.getString(12));
                    list.add(row.getString(14));
                    list.add(row.getString(1));
                    list.add(row.getString(6));
                    list.add(row.getString(7));
                    list.add(row.getString(11));
                    list.add(row.getString(0));
                    list.add(row.getString(5));
                    list.add(row.getString(9));
                    list.add(row.getString(10));

                    String uuid = row.getString(15);

                    String sql = "INSERT IGNORE INTO comservice_i_unicom_call_info (uuid,businessType,cTime,tradeTime,callType,receiverPhone,tradeAddr,tradeType,basePay,ldPay,otherPay,totalPay,phone,iscm,reductionPay,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
                    if(sqls.size()!=0&&sqls.size()%200==0){
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    }else{
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }
                } catch (Exception e) {
                }
            } catch (ArrayIndexOutOfBoundsException a) {
            } catch (Exception e) {
                System.out.println("======联通位置异常======" + row.toString());
            }
        });
        System.out.println("=====================联通通话详单执行完毕");
        ss.close();


//        System.out.println("==========联通通话详单任务开始执行=============任务数="+(args.length-1));
//
//        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
//
//        for(int i=1;i<args.length;i++){
//            String hdfs = "hdfs:///app/user/data/deeplearning/export_data/unicom_call_info/"+args[0]+"/"+args[i];
//
//            System.out.println("======读取hdfs======"+hdfs);
//
//            Dataset<String> dataset = ss.read().textFile(hdfs);
//
//            dataset.foreach(o -> {
//                try {
//                    String[] split = o.split("\t");
//                    List<String> list = new ArrayList<>();
//
//                    String phone = PhoneNoUtils.getPhoneNoByRegx(split[12], "联通主叫号码");
//
//
//                    String cTime = split[2];
//                    String recevPhone = split[5];
//                    String useTime = split[3];
//
//                    try {
//
//                        list.add(StringUtils.isBlank(split[1]) ? null : split[1]);  //未使用
//                        list.add(StringUtils.isBlank(cTime) ? null : DateUtil.getCTimeFormat(cTime, "联通通话开始时间")); //通话开始时间
//                        list.add(StringUtils.isBlank(useTime) ? null : NumberUtil.getUseTimeFormat(useTime, "联通通话时间")); //通话时间 秒
//                        list.add(StringUtils.isBlank(split[4]) ? null : split[4]); //主叫、被叫、其他
//                        list.add(StringUtils.isBlank(recevPhone) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "联通被叫号码")); //被叫号码
//                        list.add(StringUtils.isBlank(split[6]) ? null : split[6]); //通话地点
//                        list.add(StringUtils.isBlank(split[7]) ? null : split[7]); //通话类型
//                        list.add(StringUtils.isBlank(split[8]) ? null : split[8]); //未使用
//                        list.add(StringUtils.isBlank(split[9]) ? null : split[9]); //未使用
//                        list.add(StringUtils.isBlank(split[10]) ? null : split[10]); //未使用
//                        list.add(StringUtils.isBlank(split[11]) ? null : split[11]); //通话费用
//                        list.add(StringUtils.isBlank(phone) ? null : PhoneNoUtils.getPhoneNoByRegx(phone.replaceAll(" ", ""), "联通主叫号码")); //主叫号码
//                        list.add(StringUtils.isBlank(split[13]) ? null : split[13]); //未使用
//                        list.add(StringUtils.isBlank(split[14]) ? null : split[14]); //创建时间
//                        list.add(StringUtils.isBlank(split[15]) ? null : DateUtil.timeStamp2Date(split[15], "联通入库时间")); //抓取时间,入库时间
//                    } catch (Exception e) {
//                    }
//
//                    String uuid = "";
//                    if (StringUtils.isNotBlank(phone)) {
//                        uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");
//                    }
//
//                    String sql = "INSERT IGNORE INTO comservice_i_unicom_call_info (uuid,businessType,cTime,tradeTime,callType,receiverPhone,tradeAddr,tradeType,basePay,ldPay,otherPay,totalPay,phone,iscm,reductionPay,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
//
//                    JdbcExecuters.batchUpdateExecute(SqlUtil.getExecuteSql(list, sql), o);
//                }catch(ArrayIndexOutOfBoundsException a){
//
//                } catch (Exception e) {
//                    System.out.println("======联通通话详单位置异常======" + o);
//                }
//
//            });
//        }
//
//
//        System.out.println("=====================联通通话详单执行完毕");
//        ss.close();
    }

}
