package cn.quantgroup.dbc.spark.telecom;

import cn.quantgroup.dbc.bean.TelecomFlowInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

/**
 * 电信流量详单
 *
 * /app/user/data/deeplearning/export_data/telecom_flow_info/mt=1556380800000
 *
 *  手机号/开始时间/使用流量/上网时间
 *
 *  上网开始时间/计费类型/费用/耗费流量KB/是否当月(未使用)/上网地点/上网类型/上网手机号/上网时间/创建时间
 * @Author fengjunkai
 * @Date 2019-05-09 14:13
 */
public class TelecomFlowDetailInfomain {

    public static void main(String[] args) {

        System.out.println("==========电信流量详单任务开始执行=============任务个数=" + (args.length - 1));

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();


        //用户信息加载
        Dataset<String> user = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/user_info/part-00000");
        Dataset<UserInfo> userInfoDataset = user.map((MapFunction<String, UserInfo>) line -> {
            UserInfo person = new UserInfo();
            String[] split = line.split("\t");
            person.setPhone(split[0]);
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======"+userInfoDataset.head().getPhone());
        System.out.println("======================="+userInfoDataset.where("phone='18500192679'").head().getUuid());

        //联通流量详单加载
        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/telecom_flow_info/"+args[0]+"/*");

        Dataset<TelecomFlowInfo> mobileFlowMap = dataset.map((MapFunction<String, TelecomFlowInfo>) line -> {
            String[] split = line.split("\t");
            TelecomFlowInfo telecomFlowInfo = new TelecomFlowInfo();
            String phone = split[8];
            String beginTime = split[1];
            String totalFlow = split[4];
            String tradeTime = split[9];
            String business = split[2];
            String fee = split[3];
            String currentMonth = split[5];
            String tradeAddr = split[6];
            String onlineType = split[7];
            String time = split[10];

            try {
                telecomFlowInfo.setBeginTime(StringUtils.isBlank(beginTime)?null: DateUtil.getCTimeFormat(beginTime, "电信流量详单上网开始时间"));
                telecomFlowInfo.setBusiness(StringUtils.isBlank(business)?null:business);
                telecomFlowInfo.setFee(StringUtils.isBlank(fee)?null:fee);
                telecomFlowInfo.setFlow(StringUtils.isBlank(totalFlow)?null: NumberUtil.flowFormat(totalFlow, "电信流量详单耗费流量"));
                telecomFlowInfo.setIscm(StringUtils.isBlank(currentMonth)?null:currentMonth);
                telecomFlowInfo.setLocation(StringUtils.isBlank(tradeAddr)?null:tradeAddr);
                telecomFlowInfo.setNetType(StringUtils.isBlank(onlineType)?null:onlineType);
                telecomFlowInfo.setPhone(StringUtils.isBlank(phone)?null: PhoneNoUtils.getPhoneNoByRegx(phone, "电信流量详单手机号"));
                telecomFlowInfo.setTradeTime(StringUtils.isBlank(tradeTime)?null:NumberUtil.getUseTimeFormat(tradeTime, "电信流量详单上网时间"));
                telecomFlowInfo.setTimestamp(StringUtils.isBlank(time)?null:DateUtil.timeStamp2Date(time, "电信流量详单创建时间"));
            }catch (Exception e){
                e.printStackTrace();
                System.out.println("=============未知异常============");
            }
            return telecomFlowInfo;
        }, Encoders.bean(TelecomFlowInfo.class));

        System.out.println("==========电信流量清洗完成=============");

        Dataset<Row> finalRow = mobileFlowMap.join(userInfoDataset, "phone");
        System.out.println("==============join完成================");

//        Dataset<Row> limit = finalRow.limit(10);
//        System.out.println("=================字段======"+limit.columns().toString());
//        limit.show();
//        List<Row> rows = limit.collectAsList();
//        for (Row row:rows){
//            System.out.println("================"+row.toString());
//        }

        ArrayList<String> sqls = new ArrayList<>(300);
        finalRow.foreach(row->{
            try {
                List<String> list = new ArrayList<>();
                try {
                    list.add(row.getString(1));  //beginTime
                    list.add(row.getString(2)); //business
                    list.add(row.getString(3)); //fee
                    list.add(row.getString(4)); //flow
                    list.add(row.getString(5)); //iscm
                    list.add(row.getString(6)); //location
                    list.add(row.getString(7)); //netType
                    list.add(row.getString(0)); //phone
                    list.add(row.getString(9)); //tradeTime
                    list.add(row.getString(8)); //timestamp
                    String uuid =row.getString(10);

                    String sql = "INSERT IGNORE INTO comservice_i_telecom_flow_info (uuid,beginTime,business,fee,flow,iscm,location,netType,phone,tradeTime,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
                    if(sqls.size()!=0&&sqls.size()%200==0){
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    }else{
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }
                } catch (Exception e) {
                }
            } catch (ArrayIndexOutOfBoundsException a) {
            } catch (Exception e) {
                System.out.println("======电信流量未知异常======" + row.toString());
            }
        });

        JdbcExecuters.batchUpdateExecute(sqls);







        /**

        List<String> list1 = Arrays.asList(args).subList(2, args.length);
        System.out.println("======入参======" + JSON.toJSONString(args));
        System.out.println("======入参数据块======" + JSON.toJSONString(list1));

        List<String> textFileList = new ArrayList<>();
        String hdfs1 = "hdfs:///app/user/data/deeplearning/export_data/telecom_flow_info/" + args[0] + "/%s";
        for (int i = 0; i < list1.size(); i++) {
            textFileList.add(String.format(hdfs1, list1.get(i)));
        }

        Map<String, String[]> textFileMap = PagingUtil.paging(textFileList, Integer.valueOf(args[1]));

        ArrayList<String> sqls = new ArrayList<>(300);

        textFileMap.forEach((k, v) -> {
            System.out.println("======" + k + "读取的hdfs======" + JSON.toJSONString(v));
            Dataset<String> dataset = ss.read().textFile(v);
            dataset.foreach(o -> {
                try {
                    String[] split = o.split("\t");
                    List<String> list = new ArrayList<>();

                    System.out.println("======原始数据======"+JSON.toJSONString(split));

                    String phone = split[8];
                    String beginTime = split[1];
                    String totalFlow = split[4];
                    String tradeTime = split[9];

                    try {
                        list.add(StringUtils.isBlank(beginTime)?null:DateUtil.getCTimeFormat(beginTime, "电信流量详单上网开始时间"));

                        String business = split[2];
                        list.add(StringUtils.isBlank(business)?null:business);

                        String fee = split[3];
                        list.add(StringUtils.isBlank(fee)?null:fee);

                        list.add(StringUtils.isBlank(totalFlow)?null:NumberUtil.flowFormat(totalFlow, "电信流量详单耗费流量"));

                        String currentMonth = split[5];
                        list.add(StringUtils.isBlank(currentMonth)?null:currentMonth);

                        String tradeAddr = split[6];
                        list.add(StringUtils.isBlank(tradeAddr)?null:tradeAddr);

                        String onlineType = split[7];
                        list.add(StringUtils.isBlank(onlineType)?null:onlineType);

                        list.add(StringUtils.isBlank(phone)?null:PhoneNoUtils.getPhoneNoByRegx(phone, "电信流量详单手机号"));

                        list.add(StringUtils.isBlank(tradeTime)?null:NumberUtil.getUseTimeFormat(tradeTime, "电信流量详单上网时间"));

                        String time = split[10];
                        list.add(StringUtils.isBlank(time)?null:DateUtil.timeStamp2Date(time, "电信流量详单创建时间"));


                    } catch (Exception e) {
                    }


                    String uuid = JedisUtil.jedisClient.getString(phone);
                    if (StringUtils.isEmpty(uuid)) {
                        uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");
                        System.out.println("===========uuid未命中==============");
                    }

                    String sql = "INSERT IGNORE INTO comservice_i_telecom_flow_info (uuid,beginTime,business,fee,flow,iscm,location,netType,phone,tradeTime,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";

                    if (sqls.size() != 0 && sqls.size() % 200 == 0) {
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    } else {
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }

                } catch (ArrayIndexOutOfBoundsException a) {
                    System.out.println("======电信流量详单出现关键字段数组越界======" + o);
                } catch (Exception e) {
                    System.out.println("======电信流量详单出现未知异常======" + o);
                    e.printStackTrace();
                }

            });

        });

         **/
        System.out.println("=====================电信流量详单执行完毕");
        ss.close();

    }

}
