package cn.quantgroup.dbc.spark.telecom;

import cn.quantgroup.dbc.bean.TeleconCallDetailInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

/**
 * 电信通话详单
 * <p>
 * <p>
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:09 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1501516800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:14 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1504108800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:19 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1506700800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:24 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1509292800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:28 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1511884800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:29 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1514476800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:30 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1517068800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:31 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1519660800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:33 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1522252800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:34 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1524844800000--
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:36 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1527436800000--10
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:37 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1530028800000--
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:38 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1532620800000--
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:40 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1535212800000--
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:41 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1537804800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:43 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1540396800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:45 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1542988800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:47 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1545580800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:49 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1548172800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:51 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1550764800000 ----running
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:53 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1553356800000 ----running
 * <p>
 * <p>
 * <p>
 * spark2-submit --master yarn --deploy-mode cluster \
 * --driver-memory 4g \
 * --executor-memory 24g --num-executors 20 \
 * --executor-cores 10 --queue online_job \
 * --class cn.quantgroup.dbc.spark.telecom.TelecomDetailInfoMain \
 * /home/feng.ren/qg-dbc-spark-4.0-SNAPSHOT-telecom-detail-info-jar-with-dependencies.jar "mt=1553356800000" "000000_0" "000001_0" "000002_0" "000003_0" "000004_0" "000005_0" "000006_0" "000007_0" "000008_0" "000009_0" "000010_0" "000011_0" "000012_0" "000013_0" "000014_0" "000015_0" "000016_0" "000017_0" "000018_0" "000019_0" "000020_0" "000021_0" "000022_0" "000023_0" "000024_0" "000025_0" "000026_0" "000027_0" "000028_0" "000029_0" "000030_0" "000031_0" "000032_0" "000033_0" "000034_0" "000035_0" "000036_0" "000037_0" "000038_0" "000039_0" "000040_0" "000041_0" "000042_0" "000043_0" "000044_0" "000045_0" "000046_0" "000047_0" "000048_0" "000049_0" "000050_0" "000051_0" "000052_0" "000053_0" "000054_0" "000055_0" "000056_0" "000057_0" "000058_0" "000059_0" "000060_0" "000061_0" "000062_0" "000063_0" "000064_0" "000065_0" "000066_0" "000067_0" "000068_0" "000069_0" "000070_0" "000071_0" "000072_0" "000073_0" "000074_0" "000075_0" "000076_0" "000077_0" "000078_0" "000079_0" "000080_0" "000081_0" "000082_0" "000083_0" "000084_0" "000085_0" "000086_0" "000087_0" "000088_0" "000089_0" "000090_0" "000091_0" "000092_0" "000093_0" "000094_0" "000095_0" "000096_0" "000097_0" "000098_0" "000099_0" "000100_0" "000101_0" "000102_0" "000103_0" "000104_0" "000105_0" "000106_0" "000107_0" "000108_0" "000109_0" "000110_0" "000111_0" "000112_0" "000113_0" "000114_0" "000115_0"
 *
 * @Author fengjunkai
 * @Date 2019-04-29 10:19
 */
public class TelecomDetailInfoMain6 {

    public static void main(String[] args) {

        System.out.println("==========电信通话详单任务开始执行=============任务数=" + args.length);

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();

        Dataset<String> user = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/user_info/part-00000");

        Dataset<UserInfo> userInfoDataset = user.map((MapFunction<String, UserInfo>) line -> {
            UserInfo person = new UserInfo();
            String[] split = line.split("\t");
            person.setPhone(split[0]);
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======"+userInfoDataset.head().getPhone());
        System.out.println("======================="+userInfoDataset.where("phone='18500192679'").head().getUuid());

        String hdfs = "hdfs:///app/user/data/deeplearning/export_data/telecom_call_info/%s/*";

        String arg[] = new String[args.length];

        for(int i=0;i<args.length;i++){
            arg[i] = String.format(hdfs, args[i]);
        }

//        Dataset<String> dataset = ss.read().textFile(String.format(hdfs, args[0]), String.format(hdfs, args[1]) ,String.format(hdfs, args[2]));
        System.out.println("======读取参数======"+ JSON.toJSONString(arg));
        Dataset<String> dataset = ss.read().textFile(arg);

        Dataset<TeleconCallDetailInfo> telecomMap = dataset.map((MapFunction<String, TeleconCallDetailInfo>) line -> {
            String[] split = line.split("\t");
            TeleconCallDetailInfo teleconCallDetailInfo = new TeleconCallDetailInfo();
            String phone = PhoneNoUtils.getPhoneNoByRegx(split[12], "电信主叫号码");
            String cTime = split[2];
            String recevPhone = split[5];
            String useTime = split[3];
            try {
                phone = StringUtils.isBlank(phone) ? null : phone.replaceAll(" ", "");
                teleconCallDetailInfo.setPhone(phone);
                teleconCallDetailInfo.setThlx(StringUtils.isBlank(split[1]) ? null : split[1]);
                teleconCallDetailInfo.setThkssj(StringUtils.isBlank(split[2]) ? null : DateUtil.getCTimeFormat(cTime, "电信通话开始时间"));
                teleconCallDetailInfo.setThsj(StringUtils.isBlank(split[3]) ? null : NumberUtil.getUseTimeFormat(useTime, "电信通话时间"));
                teleconCallDetailInfo.setZbj(StringUtils.isBlank(split[4]) ? null : split[4]);
                teleconCallDetailInfo.setBjhm(StringUtils.isBlank(split[5]) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "电信被叫号码"));
                teleconCallDetailInfo.setThdd(StringUtils.isBlank(split[6]) ? null : split[6]);
                teleconCallDetailInfo.setWsy1(StringUtils.isBlank(split[7]) ? null : split[7]);
                teleconCallDetailInfo.setWsy2(StringUtils.isBlank(split[8]) ? null : split[8]);
                teleconCallDetailInfo.setWsy3(StringUtils.isBlank(split[9]) ? null : split[9]);
                teleconCallDetailInfo.setWsy4(StringUtils.isBlank(split[10]) ? null : split[10]);
                teleconCallDetailInfo.setThfy(StringUtils.isBlank(split[11]) ? null : split[11]);
                teleconCallDetailInfo.setZjhm(phone);
                teleconCallDetailInfo.setWsy5(StringUtils.isBlank(split[13]) ? null : split[13]);
                teleconCallDetailInfo.setRksj(StringUtils.isBlank(split[14]) ? null : DateUtil.timeStamp2Date(split[14], "电信通话入库时间"));
            }catch (Exception e){
                e.printStackTrace();
                System.out.println("=============未知异常============");
            }
            return teleconCallDetailInfo;
        }, Encoders.bean(TeleconCallDetailInfo.class));

        System.out.println("==========电信清洗完成=============");


        Dataset<Row> finalRow = telecomMap.join(userInfoDataset, "phone");
        System.out.println("==============join完成================");
//        Dataset<Row> limit = finalRow.limit(10);
//        System.out.println("=================字段======"+limit.columns());
//        limit.show();
//        List<Row> rows = limit.collectAsList();
//        for (Row row:rows){
//            System.out.println("================"+row.toString());
//        }

        ArrayList<String> sqls = new ArrayList<>(300);
        finalRow.foreach(row->{
            try {
                List<String> list = new ArrayList<>();
                try {
                    list.add(row.getString(6));  //通话类型
                    list.add(row.getString(5)); //通话开始时间
                    list.add(row.getString(7)); //通话时间s
                    list.add(row.getString(13)); //主叫、被叫、其他
                    list.add(row.getString(1)); //被叫号码
                    list.add(row.getString(3)); //通话地点
                    list.add(row.getString(8)); //未使用
                    list.add(row.getString(9)); //未使用
                    list.add(row.getString(10)); //未使用
                    list.add(row.getString(11)); //未使用
                    list.add(row.getString(4)); //通话费用
                    list.add(row.getString(14)); //主叫号码
                    list.add(row.getString(12)); //未使用
                    list.add(row.getString(2)); //抓取时间,入库时间
                    String uuid =row.getString(15);

                    String sql = "INSERT IGNORE INTO comservice_i_telecom_call_info (uuid,tradeType,cTime,tradeTime,callWay,receiverPhone,tradeAddr,basePay,longPay,infoPay,otherPay,allPay,phone,iscm,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
                    if(sqls.size()!=0&&sqls.size()%200==0){
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    }else{
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }
                } catch (Exception e) {
                }
            } catch (ArrayIndexOutOfBoundsException a) {
            } catch (Exception e) {
                System.out.println("======电信位置异常======" + row.toString());
            }
        });
        System.out.println("=====================电信通话详单执行完毕");
        ss.close();

        /*System.out.println("==========电信通话详单任务开始执行=============任务数=" + args.length);

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();




        Dataset<String> user = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/user_info/part-00000");

        Dataset<UserInfo> userInfoDataset = user.map((MapFunction<String, UserInfo>) line -> {
            UserInfo person = new UserInfo();
            String[] split = line.split("\t");
            person.setPhone(split[0]);
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======"+userInfoDataset.head().getPhone());
        System.out.println("======================="+userInfoDataset.where("phone='18500192679'").head().getUuid());



        String hdfs = "hdfs:///app/user/data/deeplearning/export_data/telecom_call_info/" + args[0] + "/*";
        Dataset<String> dataset = ss.read().textFile(hdfs);
        Dataset<TeleconCallDetailInfo> telecomMap = dataset.map((MapFunction<String, TeleconCallDetailInfo>) line -> {
            String[] split = line.split("\t");
            TeleconCallDetailInfo teleconCallDetailInfo = new TeleconCallDetailInfo();
            String phone = PhoneNoUtils.getPhoneNoByRegx(split[12], "电信主叫号码");
            String cTime = split[2];
            String recevPhone = split[5];
            String useTime = split[3];
            try {
                phone = StringUtils.isBlank(phone) ? null : phone.replaceAll(" ", "");
                teleconCallDetailInfo.setPhone(phone);
                teleconCallDetailInfo.setThlx(StringUtils.isBlank(split[1]) ? null : split[1]);
                teleconCallDetailInfo.setThkssj(StringUtils.isBlank(split[2]) ? null : DateUtil.getCTimeFormat(cTime, "电信通话开始时间"));
                teleconCallDetailInfo.setThsj(StringUtils.isBlank(split[3]) ? null : NumberUtil.getUseTimeFormat(useTime, "电信通话时间"));
                teleconCallDetailInfo.setZbj(StringUtils.isBlank(split[4]) ? null : split[4]);
                teleconCallDetailInfo.setBjhm(StringUtils.isBlank(split[5]) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "电信被叫号码"));
                teleconCallDetailInfo.setThdd(StringUtils.isBlank(split[6]) ? null : split[6]);
                teleconCallDetailInfo.setWsy1(StringUtils.isBlank(split[7]) ? null : split[7]);
                teleconCallDetailInfo.setWsy2(StringUtils.isBlank(split[8]) ? null : split[8]);
                teleconCallDetailInfo.setWsy3(StringUtils.isBlank(split[9]) ? null : split[9]);
                teleconCallDetailInfo.setWsy4(StringUtils.isBlank(split[10]) ? null : split[10]);
                teleconCallDetailInfo.setThfy(StringUtils.isBlank(split[11]) ? null : split[11]);
                teleconCallDetailInfo.setZjhm(phone);
                teleconCallDetailInfo.setWsy5(StringUtils.isBlank(split[13]) ? null : split[13]);
                teleconCallDetailInfo.setRksj(StringUtils.isBlank(split[14]) ? null : DateUtil.timeStamp2Date(split[14], "电信通话入库时间"));
            }catch (Exception e){
                e.printStackTrace();
                System.out.println("=============未知异常============");
            }
            return teleconCallDetailInfo;
        }, Encoders.bean(TeleconCallDetailInfo.class));

        System.out.println("==========电信清洗完成=============");


        Dataset<Row> finalRow = telecomMap.join(userInfoDataset, "phone");
        System.out.println("==============join完成================");
//        Dataset<Row> limit = finalRow.limit(10);
//        System.out.println("=================字段======"+limit.columns());
//        limit.show();
//        List<Row> rows = limit.collectAsList();
//        for (Row row:rows){
//            System.out.println("================"+row.toString());
//        }

        Dataset<Row> phone = finalRow.drop("phone");

        phone.toJavaRDD().saveAsTextFile("hdfs:///app/user/data/user_data/feng.ren/telecom_2");
        *//**
        ArrayList<String> sqls = new ArrayList<>(300);
        finalRow.foreach(row->{
            try {
                List<String> list = new ArrayList<>();
                try {
                    list.add(row.getString(6));  //通话类型
                    list.add(row.getString(5)); //通话开始时间
                    list.add(row.getString(7)); //通话时间s
                    list.add(row.getString(13)); //主叫、被叫、其他
                    list.add(row.getString(1)); //被叫号码
                    list.add(row.getString(3)); //通话地点
                    list.add(row.getString(8)); //未使用
                    list.add(row.getString(9)); //未使用
                    list.add(row.getString(10)); //未使用
                    list.add(row.getString(11)); //未使用
                    list.add(row.getString(4)); //通话费用
                    list.add(row.getString(14)); //主叫号码
                    list.add(row.getString(12)); //未使用
                    list.add(row.getString(2)); //抓取时间,入库时间
                    String uuid =row.getString(15);

                    String sql = "INSERT IGNORE INTO comservice_i_telecom_call_info (uuid,tradeType,cTime,tradeTime,callWay,receiverPhone,tradeAddr,basePay,longPay,infoPay,otherPay,allPay,phone,iscm,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
                    if(sqls.size()!=0&&sqls.size()%200==0){
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    }else{
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }
                } catch (Exception e) {
                }
            } catch (ArrayIndexOutOfBoundsException a) {
            } catch (Exception e) {
                System.out.println("======电信位置异常======" + row.toString());
            }
        });
         *//*
        System.out.println("=====================电信通话详单执行完毕");
        ss.close();*/

    }

}
