package cn.quantgroup.dbc.spark;

import cn.quantgroup.dbc.utils.JdbcExecuters;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by renfeng on 2019/4/19.
 */
public class DbcSparkMain {




    /**
     * spark2-submit --master yarn --deploy-mode cluster \
     --driver-memory 2g  \
     --executor-memory 2g --num-executors 2  \
     --executor-cores 2  --queue online_job \
     --class cn.quantgroup.dbc.spark.DbcSparkMain \
     /home/feng.ren/qg-dbc-spark-1.0-SNAPSHOT-jar-with-dependencies.jar
     * @param args
     */
    public static void main(String[] args) {

//        System.out.println("======用户基本信息开始执行======");
//
//        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
//
//        Dataset<String> ds = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/spider_user_item/*/*");
//
//
//        Dataset<ComserviceISpiderUserInfo> map = ds.map((MapFunction<String, ComserviceISpiderUserInfo>) line -> {
//            String[] split = line.split("\t");
//
//            String loginName = split[11];
//
//            String uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + loginName + "'");
//
//            ComserviceISpiderUserInfo comserviceISpiderUserInfo = new ComserviceISpiderUserInfo();
//            comserviceISpiderUserInfo.setUuid(StringUtils.isBlank(uuid)?null:uuid);
//            comserviceISpiderUserInfo.setRealName(StringUtils.isBlank(split[1])?null:split[1]);
//            String registerdate = registerDate2Date(split[2]);
//            comserviceISpiderUserInfo.setRegisterDate(StringUtils.isBlank(registerdate)?null:registerdate);
//            comserviceISpiderUserInfo.setIdCard(StringUtils.isBlank(split[3])?null:split[3]);
//            String phoneremain = phoneRemainToFormat(split[4]);
//            comserviceISpiderUserInfo.setPhoneRemain(StringUtils.isBlank(phoneremain)?null:phoneremain);
//            comserviceISpiderUserInfo.setPhone(StringUtils.isBlank(split[5])?null:split[5]);
//            comserviceISpiderUserInfo.setAddr(StringUtils.isBlank(split[6])?null:split[6]);
//            comserviceISpiderUserInfo.setMerry(StringUtils.isBlank(split[7])?null:split[7]);
//            comserviceISpiderUserInfo.setCardType(StringUtils.isBlank(split[8])?null:split[8]);
//            comserviceISpiderUserInfo.setCardNo(StringUtils.isBlank(split[9])?null:split[9]);
//            comserviceISpiderUserInfo.setSex(StringUtils.isBlank(split[10])?null:split[10]);
//            comserviceISpiderUserInfo.setLoginName(StringUtils.isBlank(split[11])?null:split[11]);
//            comserviceISpiderUserInfo.setUserSource(StringUtils.isBlank(split[12])?null:split[12]);
//            comserviceISpiderUserInfo.setTimestamp(StringUtils.isBlank(split[13])?null:timeStamp2Date(split[13]));
//            return comserviceISpiderUserInfo;
//        }, Encoders.bean(ComserviceISpiderUserInfo.class));
//
//        System.out.println("======清洗数据完成======");
//
//        System.out.println("======去重前======"+map.count());
//
//        Dataset<ComserviceISpiderUserInfo> duplicates = map.dropDuplicates(new String[]{"phone", "userSource"});
//
//        System.out.println("======去重后======"+duplicates.count());
//
//
//        duplicates.repartition(36).write()
//                .mode("append")
//                .format("jdbc")
//                .option("driver", "com.mysql.jdbc.Driver")
//                .option("url", "jdbc:mysql://10.17.115.6:4010/rc_comservice_data_pool_v2?useUnicode=true&characterEncoding=UTF8&rewriteBatchedStatements=true")
//                .option("useSSL", "false")
//                .option(JDBCOptions.JDBC_BATCH_INSERT_SIZE(), 200)
//                .option("dbtable", "comservice_i_spider_user_info") // database name and table name here
//                .option("isolationLevel", "NONE") // recommended to set isolationLevel to NONE if you have a large DF to load.
//                .option("user", "rc_comservice_data_pool_v2_w")
//                .option("password", "w9pr8IPJkLmUSBe4") // TiDB user here
//                .save();
//        ss.stop();

        System.out.println("==========任务开始执行=============");

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();

        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/spider_user_item/*/*");



        dataset.foreach(o->{
            String[] split = o.split("\t");
            List<String> list = new ArrayList<>();
            list.add(StringUtils.isBlank(split[1])?null:split[1]);

            String registerdate = registerDate2Date(split[2]);
            list.add(StringUtils.isBlank(registerdate)?null:registerdate);

            list.add(StringUtils.isBlank(split[3])?null:split[3]);

            String phoneremain = phoneRemainToFormat(split[4]);
            list.add(StringUtils.isBlank(phoneremain)?null:phoneremain);

            String loginname = split[11];

            list.add(StringUtils.isBlank(split[5])?null:split[5]);
            list.add(StringUtils.isBlank(split[6])?null:split[6]);
            list.add(StringUtils.isBlank(split[7])?null:split[7]);
            list.add(StringUtils.isBlank(split[8])?null:split[8]);
            list.add(StringUtils.isBlank(split[9])?null:split[9]);
            list.add(StringUtils.isBlank(split[10])?null:split[10]);
            list.add(StringUtils.isBlank(loginname)?null:loginname);
            list.add(StringUtils.isBlank(split[12])?null:split[12]);
            list.add(StringUtils.isBlank(split[13])?null:timeStamp2Date(split[13]));

            JdbcExecuters.batchUpdateExecute(getExecuteSql(list, JdbcExecuters.queryExecute(
                    "select uuid from xyqb_user_i_user where phone_no = '" + loginname + "'")), o);

        });




//        limit.foreach(line->{
//
//            String[] split = line.split("\t");
//            List<String> list = new ArrayList<>();
//            list.add(StringUtils.isBlank(split[1])?null:split[1]);
//
//            String registerdate = registerDate2Date(split[2]);
//            list.add(StringUtils.isBlank(registerdate)?null:registerdate);
//
//            list.add(StringUtils.isBlank(split[3])?null:split[3]);
//
//            String phoneremain = phoneRemainToFormat(split[4]);
//            list.add(StringUtils.isBlank(phoneremain)?null:phoneremain);
//
//            String phone = split[5];
//
//            list.add(StringUtils.isBlank(phone)?null:phone);
//            list.add(StringUtils.isBlank(split[6])?null:split[6]);
//            list.add(StringUtils.isBlank(split[7])?null:split[7]);
//            list.add(StringUtils.isBlank(split[8])?null:split[8]);
//            list.add(StringUtils.isBlank(split[9])?null:split[9]);
//            list.add(StringUtils.isBlank(split[10])?null:split[10]);
//            list.add(StringUtils.isBlank(split[11])?null:split[11]);
//            list.add(StringUtils.isBlank(split[12])?null:split[12]);
//            list.add(StringUtils.isBlank(split[13])?null:timeStamp2Date(split[13]));
//
//            String uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '"+phone+"'");
//            JdbcExecuters.batchUpdateExecute(new ArrayList<String>(){{
//                add(getExecuteSql(list, uuid));
//            }});
//
//        });

/**
        List<String> take = javaRDD.take(100000);
        ArrayList<String> sqlList = new ArrayList<>();
        for(String s :take){
//            System.out.println("==========原始记录============="+s);
            String[] split = s.split("\t");
//            Stopwatch clearDataStop = Stopwatch.createStarted();
            long startTime = System.currentTimeMillis();
            List<String> list = new ArrayList<>();

            list.add(StringUtils.isBlank(split[1])?null:split[1]);

            String registerdate = registerDate2Date(split[2]);
            list.add(StringUtils.isBlank(registerdate)?null:registerdate);

            list.add(StringUtils.isBlank(split[3])?null:split[3]);

            String phoneremain = phoneRemainToFormat(split[4]);
            list.add(StringUtils.isBlank(phoneremain)?null:phoneremain);

            String phone = split[5];

            list.add(StringUtils.isBlank(phone)?null:phone);
            list.add(StringUtils.isBlank(split[6])?null:split[6]);
            list.add(StringUtils.isBlank(split[7])?null:split[7]);
            list.add(StringUtils.isBlank(split[8])?null:split[8]);
            list.add(StringUtils.isBlank(split[9])?null:split[9]);
            list.add(StringUtils.isBlank(split[10])?null:split[10]);
            list.add(StringUtils.isBlank(split[11])?null:split[11]);
            list.add(StringUtils.isBlank(split[12])?null:split[12]);
            list.add(StringUtils.isBlank(split[13])?null:timeStamp2Date(split[13]));
            long endTime = System.currentTimeMillis();
            System.out.println("单条数据清洗完毕,耗时:"+(endTime-startTime));

            long queryStartTime = System.currentTimeMillis();

            String uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '"+phone+"'");
            long queryendTime = System.currentTimeMillis();
            System.out.println("根据 "+phone+" 查询userId+ "+uuid+" 耗时 "+(queryendTime-queryStartTime));

            long executeSqlStartTime = System.currentTimeMillis();
            sqlList.add(getExecuteSql(list, uuid));
            long executeSqlEndTime = System.currentTimeMillis();
            System.out.println("拼装SQL "+phone+":"+uuid+" 耗时 "+(executeSqlEndTime-executeSqlStartTime));

            if(sqlList.size()%10==0){
//                accumulator.add(1000);
                JdbcExecuters.batchUpdateExecute(sqlList);
                sqlList = new ArrayList<>(150);
            }

        }

 **/
        System.out.println("=====================执行完毕");
        ss.close();

    }


//    public static String timeStamp2Date(String timeStamp) {
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        return sdf.format(new Date(Long.valueOf(timeStamp)));
//    }

    public static String getExecuteSql(List<String> list, String uuid){
        String str = "INSERT IGNORE INTO comservice_i_spider_user_info (uuid,realName,registerDate,idCard,phoneRemain,phone,addr,merry,cardType,cardNo,sex,loginName,userSource,timestamp) values ("+(StringUtils.isBlank(uuid)?(null+","):("'"+uuid+"',"))+"%s)";
        String formatStr = "";
        for(int i=0;i<list.size();i++){
            String string = list.get(i);
            if(string==null){
                formatStr+=(string+(i==list.size()-1?"":","));
            }else{
                formatStr += ("'"+StringUtils.replaceAll(string, "'", "")+"'"+(i==list.size()-1?"":","));
            }
        }
        String executeSql = String.format(str, formatStr);
//        System.out.println("===========执行sql========="+executeSql);
        return executeSql;
    }

    public static String phoneRemainToFormat(String phoneRemain){
        if(StringUtils.isBlank(phoneRemain)){
            return null;
        }

        String phoneRemain1 = phoneRemain.replaceAll("\\.", "").replaceAll(" ", "");
        if(!StringUtils.isNumeric(phoneRemain1)){
            return phoneRemain;
        }

        try{
            return new BigDecimal(phoneRemain).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
        }catch(Exception e){
            System.out.println("======用户信息余额异常======"+phoneRemain);
            e.printStackTrace();
        }
        return phoneRemain;
    }


    public static String registerDate2Date(String timeStamp) {
        if(StringUtils.isBlank(timeStamp)){
            return null;
        }
        String errorTime = "1960-01-01 00:00:00";

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try{
            if(!timeStamp.startsWith("1") && !timeStamp.startsWith("2")){
                return null;
            }

            Date date = sdf.parse(timeStamp);
            Date errorDate = sdf.parse(errorTime);
            if(date.compareTo(errorDate)<0){
                return null;
            }

            if(new Date().compareTo(date)<0){
                return null;
            }

            return timeStamp;
        }catch(Exception e){
            System.out.println("======注册时间异常======"+timeStamp);
            e.printStackTrace();
        }
        return timeStamp;
    }

    public static String timeStamp2Date(String timeStamp) {
        if(timeStamp.contains("\\N")){
            return null;
        }
        try{
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(new Date(Long.valueOf(timeStamp)));
        }catch(Exception e){
            System.out.println("======timestamp======"+timeStamp);
            e.printStackTrace();
        }
        return null;
    }



}
