package cn.quantgroup.dbc.spark.june;

import cn.quantgroup.dbc.bean.PhoneBillInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.DateUtil;
import cn.quantgroup.dbc.utils.JdbcExecuters;
import cn.quantgroup.dbc.utils.NumberUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author fengjunkai
 * @Date 2019-04-26 14:30
 */
public class PhoneBillInfoApp {

    public static void main(String[] args) {

        System.out.println("==========通话账单任务开始执行=============");
        System.out.println("本次导入" +  args[0]);

        SparkSession ss = SparkSession.builder().appName("PhoneBillInfo").getOrCreate();

        Dataset<UserInfo> userInfoDataset = ss.read().parquet("hdfs:///app/user/data/user_data/feng.ren/user_parquet").map(row -> {
            UserInfo userInfo = new UserInfo();
            userInfo.setPhone(row.getAs("phone"));
            userInfo.setUuid(row.getAs("uuid"));
            return userInfo;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======" + userInfoDataset.head().getPhone());
        System.out.println("======用户加载总数量======" + userInfoDataset.count());

        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/phone_bill_info/" + args[0]);

        Dataset<PhoneBillInfo> phoneBillInfoDataset = dataset.filter(row -> row.split("\t", -1).length > 8).map(row -> {
            String[] split = row.split("\t", -1);
            PhoneBillInfo phoneBillInfo = new PhoneBillInfo();
            phoneBillInfo.setPhone(StringUtils.isBlank(split[1]) ? null : split[1].replaceAll(" ", ""));
            phoneBillInfo.setBillDay(StringUtils.isBlank(split[2]) ? null : DateUtil.string2DateEnglish(split[2], "手机通话账单月"));
            phoneBillInfo.setName(StringUtils.isBlank(split[3]) ? null : split[3]);
            phoneBillInfo.setAmount(StringUtils.isBlank(split[4]) ? null : NumberUtil.amountToFormat(split[4], "手机通话账单金额"));
            phoneBillInfo.setDependCycle(StringUtils.isBlank(split[5]) ? null : split[5]);
            phoneBillInfo.setBillPackage(StringUtils.isBlank(split[6]) ? null : split[6]);
            phoneBillInfo.setContent(StringUtils.isBlank(split[7]) ? null : split[7]);
            phoneBillInfo.setTimestamp(StringUtils.isBlank(split[8]) ? null : DateUtil.timeStamp2Date(split[8].replaceAll(" ", ""), "手机通话账单创建时间"));
            return phoneBillInfo;
        }, Encoders.bean(PhoneBillInfo.class));


        Dataset<Row> finalData = phoneBillInfoDataset.join(userInfoDataset, "phone");
        phoneBillInfoDataset.join(userInfoDataset, "phone");

        System.out.println("======join总数量======" + finalData.count());


        String sql = "INSERT IGNORE INTO comservice_i_phone_bill_info (uuid,phoneNo,billDay,name,amount,dependCycle,billPackage,content,timestamp) values (?,?,?,?,?,?,?,?,?)";



        finalData.foreachPartition(line -> {
            List<List<String>> paramList = new ArrayList<>(500);
            line.forEachRemaining(o -> {
                List<String> list = new ArrayList<>();
                //取前4个元素(手机号/姓名/账单月/账单金额), 主要是用到的有 手机号/账单月/账单金额
                try {
                    String uuid = StringUtils.isBlank(o.getAs("uuid")) ? null : o.getAs("uuid");
                    list.add(uuid);

                    list.add(o.getAs("phone"));
                    list.add(o.getAs("billDay"));
                    list.add(o.getAs("name"));
                    list.add(o.getAs("amount"));
                    list.add(o.getAs("dependCycle"));
                    list.add(o.getAs("billPackage"));
                    list.add(o.getAs("content"));
                    list.add(o.getAs("timestamp"));

                    paramList.add(list);

                    if (paramList.size() != 0 && paramList.size() % 500 == 0) {
                        JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
                        paramList.clear();
                    }

                } catch (Exception e) {
                    System.out.println("======通话账单未知异常======");
                    e.printStackTrace();
                }
            });

            JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
        });



        System.out.println("======通话账单数据清洗执行完毕======");
        ss.close();

    }


    public static String getExecuteSql(List<String> list, String uuid) {
        String str = "INSERT IGNORE INTO comservice_i_phone_bill_info (uuid,phoneNo,billDay,name,amount,dependCycle,billPackage,content,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
        String formatStr = "";
        for (int i = 0; i < list.size(); i++) {
            String string = list.get(i);
            if (string == null) {
                formatStr += (string + (i == list.size() - 1 ? "" : ","));
            } else {
                formatStr += ("'" + StringUtils.replaceAll(string, "'", "") + "'" + (i == list.size() - 1 ? "" : ","));
            }
        }
        return String.format(str, formatStr);
    }


}
