package cn.quantgroup.dbc.spark.june;

import cn.quantgroup.dbc.bean.MobileCallDetailInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.*;

import java.util.ArrayList;
import java.util.List;


public class MobileCallInfoApp {

    public static void main(String[] args) {
        System.out.println("==========移动通话详单1556任务开始执行============");

        SparkSession ss = SparkSession.builder().appName("MobileCallInfoApp").getOrCreate();

        System.out.println("本次导入" +  args[0]);

        //用户信息加载
//        Dataset<String> user = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/user");
//        Dataset<UserInfo> userInfoDataset = user.map(line -> {
//            UserInfo person = new UserInfo();
//            String[] split = line.split("\t", -1);
//            person.setPhone(split[0]);
//            person.setUuid(split[1]);
//            return person;
//        }, Encoders.bean(UserInfo.class));

        Dataset<UserInfo> userInfoDataset = ss.read().parquet("hdfs:///app/user/data/user_data/feng.ren/user_parquet").map(row -> {
            UserInfo userInfo = new UserInfo();
            userInfo.setPhone(row.getAs("phone"));
            userInfo.setUuid(row.getAs("uuid"));
            return userInfo;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======" + userInfoDataset.head().getPhone());
        System.out.println("======用户加载总数量======" + userInfoDataset.count());

        //方便后面使用
//        user.write().mode(SaveMode.Overwrite).parquet("hdfs:///app/user/data/user_data/feng.ren/user_parquet");


        //移动通话详单加载
        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/mobile_call_info/" + args[0]);

        Dataset<MobileCallDetailInfo> mobileMap = dataset.filter(row -> row.split("\t", -1).length > 11)
                .map(row -> {
                    String[] split = row.split("\t", -1);
                    MobileCallDetailInfo mobileCallDetailInfo = new MobileCallDetailInfo();
                    String phone = PhoneNoUtils.getPhoneNoByRegx(split[9], "移动主叫号码");
                    String cTime = split[1];
                    String recevPhone = split[5];
                    String useTime = split[6];
                    try {
                        phone = StringUtils.isBlank(phone) ? null : phone.replaceAll(" ", "");
                        mobileCallDetailInfo.setPhone(phone);
                        mobileCallDetailInfo.setThlx(StringUtils.isBlank(split[4]) ? null : split[4]);
                        mobileCallDetailInfo.setThkssj(StringUtils.isBlank(split[1]) ? null : DateUtil.getCTimeFormat(cTime, "移动通话开始时间"));
                        mobileCallDetailInfo.setThsj(StringUtils.isBlank(split[6]) ? null : NumberUtil.getUseTimeFormat(useTime, "移动通话耗时"));
                        mobileCallDetailInfo.setZbj(StringUtils.isBlank(split[3]) ? null : split[3]);
                        mobileCallDetailInfo.setBjhm(StringUtils.isBlank(split[5]) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "移动被叫号码"));
                        mobileCallDetailInfo.setThdd(StringUtils.isBlank(split[2]) ? null : split[2]);
                        mobileCallDetailInfo.setWsy1(StringUtils.isBlank(split[7]) ? null : split[7]);
                        mobileCallDetailInfo.setWsy2(StringUtils.isBlank(split[10]) ? null : split[10]);
                        mobileCallDetailInfo.setThfy(StringUtils.isBlank(split[8]) ? null : split[8]);
                        mobileCallDetailInfo.setZjhm(phone);
                        mobileCallDetailInfo.setRksj(StringUtils.isBlank(split[11]) ? null : DateUtil.timeStamp2Date(split[11], "移动通话详单"));
                    } catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("=============未知异常============");
                    }
                    return mobileCallDetailInfo;
                }, Encoders.bean(MobileCallDetailInfo.class));

        System.out.println("==========移动清洗完成=============");

        Dataset<Row> finalRow = mobileMap.join(userInfoDataset, "phone");

//        System.out.println("======join总数量======" + finalRow.count());

        String sql = "INSERT IGNORE INTO comservice_i_mobile_call_info (uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,taocan,onlinePay,phone,iscm,timestamp) values (?,?,?,?,?,?,?,?,?,?,?,?)";


        finalRow.foreachPartition(line -> {
            List<List<String>> paramList = new ArrayList<>(500);
            line.forEachRemaining(row -> {
                try {
                    List<String> list = new ArrayList<>();
                    String uuid = StringUtils.isBlank(row.getAs("uuid")) ? null : row.getAs("uuid");
                    list.add(uuid);

                    //通话开始时间
                    list.add(row.getAs("thkssj"));
                    //通话地点
                    list.add(row.getAs("thdd"));
                    //通话类型/主叫/被叫/其他
                    list.add(row.getAs("zbj"));
                    //通话类别
                    list.add(row.getAs("thlx"));
                    //被叫号码
                    list.add(row.getAs("bjhm"));
                    //通话时间s
                    list.add(row.getAs("thsj"));
                    //套餐   未使用
                    list.add(row.getAs("wsy1"));
                    //通话费用
                    list.add(row.getAs("thfy"));
                    //手机号
                    list.add(row.getAs("zjhm"));
                    //未使用
                    list.add(row.getAs("wsy2"));
                    //抓取时间,入库时间
                    list.add(row.getAs("rksj"));

                    paramList.add(list);


                    if (paramList.size() != 0 && paramList.size() % 500 == 0) {
                        JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
                        paramList.clear();
                    }
                } catch (Exception e) {
                    System.out.println("======移动未知异常======" + row.toString());
                }

            });
            JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);

        });


        System.out.println("=====================移动通话详单执行完毕");
        ss.close();
    }

}
