package cn.quantgroup.dbc.spark.applyList;

import cn.quantgroup.dbc.utils.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.*;
import org.apache.spark.util.LongAccumulator;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @Author fengjunkai
 * @Date 2019-09-03 14:56
 */
public class ApplyListExportToBizFlowMain {

    public static void main(String[] args) {

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
        System.out.println("开始加载数据");
        Dataset<String> userInfoListDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/userInfoNew/part-m-00000");

        Dataset<UserInfoDataRow> userInfoListDataSetMap = userInfoListDataSet.map((MapFunction<String, UserInfoDataRow>) line -> {
            UserInfoDataRow person = new UserInfoDataRow();
            String[] split = line.split("\t");
            person.setId(Long.valueOf(split[0]));
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfoDataRow.class));

        System.out.println("转换用户信息完成" + userInfoListDataSetMap.count());

        Dataset<String> quotaCreditDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/quota_credit/part-m-00000");

        Dataset<QuotaCredit> quotaCreditDataSetMap = quotaCreditDataSet.map((MapFunction<String, QuotaCredit>) line -> {
            String quotaCreditTmp[] = line.split("\t");
            QuotaCredit quotaCreditRow = new QuotaCredit();
            try {
                quotaCreditRow.setUser_id(quotaCreditTmp[1]);
                quotaCreditRow.setCustomer_id(quotaCreditTmp[2]);
                quotaCreditRow.setProduct_id(quotaCreditTmp[3]);
                quotaCreditRow.setProduct_type(quotaCreditTmp[4]);
                quotaCreditRow.setChannel(quotaCreditTmp[6]);
                quotaCreditRow.setOrder_no(quotaCreditTmp[7]);
                quotaCreditRow.setReceive_at(Timestamp.valueOf(quotaCreditTmp[11]));
                quotaCreditRow.setCredit_status(quotaCreditTmp[12]);
            } catch (Exception e) {
                System.out.println("申请单异常" + JSON.toJSONString(quotaCreditTmp));
            }
            return quotaCreditRow;
        }, Encoders.bean(QuotaCredit.class));

        System.out.println("转换申请单完成" + quotaCreditDataSetMap.count());

        Dataset<String> applyQuotaRecordDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/apply_quota_record/part-m-00000");

        Dataset<ApplyQuotaRecord> applyQuotaRecordDataSetMap = applyQuotaRecordDataSet.map((MapFunction<String, ApplyQuotaRecord>) line -> {
            String applyQuotaRecordTmp[] = line.split("\t");
            ApplyQuotaRecord applyQuotaRecordRow = new ApplyQuotaRecord();
            try {
                applyQuotaRecordRow.setUser_id(applyQuotaRecordTmp[1]);
                applyQuotaRecordRow.setUuid(applyQuotaRecordTmp[3]);
                applyQuotaRecordRow.setApply_time(Timestamp.valueOf(applyQuotaRecordTmp[4]));
                applyQuotaRecordRow.setApply_from(applyQuotaRecordTmp[5]);
                applyQuotaRecordRow.setProduct_type(applyQuotaRecordTmp[7]);
                applyQuotaRecordRow.setApply_status(applyQuotaRecordTmp[8]);
                applyQuotaRecordRow.setRisk_notify_time(Timestamp.valueOf(applyQuotaRecordTmp[11]));
                applyQuotaRecordRow.setOrder_no(applyQuotaRecordTmp[12]);
            } catch (Exception e) {
                System.out.println("提交申请单异常" + JSON.toJSONString(applyQuotaRecordTmp));
            }
            return applyQuotaRecordRow;
        }, Encoders.bean(ApplyQuotaRecord.class));

        System.out.println("转换提交的申请单完成" + applyQuotaRecordDataSetMap.count());

        userInfoListDataSetMap.createOrReplaceTempView("userInfoListDataSetMapView");
        quotaCreditDataSetMap.createOrReplaceTempView("quotaCreditDataSetMapView");
        applyQuotaRecordDataSetMap.createOrReplaceTempView("applyQuotaRecordDataSetMapView");
        System.out.println("创建三张表视图完成");

        SQLContext sqlContext = ss.sqlContext();
        String sql = "INSERT INTO `apply_list` (`channel_group_no`, `channel_id`, `product_type`, `uuid`, `apply_no`, `apply_status`, `audit_result`, `apply_submit_time`) VALUES (?,?,?,?,?,?,?,?)";
//        String sql = "INSERT INTO `apply_list` (`apply_no`) VALUES (?)";

        Dataset<Row> dataset = sqlContext.sql("select a.product_type,a.channel,a.order_no,a.receive_at,a.credit_status,b.apply_time,b.apply_status,b.risk_notify_time,c.uuid  from quotaCreditDataSetMapView a left join applyQuotaRecordDataSetMapView b on a.order_no = b.order_no left join userInfoListDataSetMapView c on a.user_id = c.id");
        System.out.println("dataset" + dataset.count());
        LongAccumulator longAccumulator = ss.sparkContext().longAccumulator();
        LongAccumulator channelLongAccumulator = ss.sparkContext().longAccumulator();
        LongAccumulator productTypeLongAccumulator = ss.sparkContext().longAccumulator();
        LongAccumulator uuidLongAccumulator = ss.sparkContext().longAccumulator();
        LongAccumulator orderNoLongAccumulator = ss.sparkContext().longAccumulator();
        LongAccumulator creditStatusLongAccumulator = ss.sparkContext().longAccumulator();
        dataset.foreachPartition(line -> {
            List<ApplyListRow> applyListRows = new ArrayList<>(1000);
            line.forEachRemaining(result -> {
                try {
//                    ApplyListRow applyListRow = new ApplyListRow();
//                    applyListRow.setChannelGroupNo(result.getAs("channel"));
//                    applyListRow.setChannelId(result.getAs("channel"));
//                    applyListRow.setProductType(result.getAs("product_type"));
//                    applyListRow.setUuid(result.getAs("uuid"));
//                    applyListRow.setApplyNo(result.getAs("order_no"));
////
//                    String credit_status = result.getAs("credit_status");
//                    applyListRow.setApplyStatus(getApplyStatus(credit_status, result.getAs("apply_status")));
//
//                    String apply_status = result.getAs("apply_status");
//                    applyListRow.setAuditResult("0".equals(apply_status) ? null : "1".equals(apply_status) ? "0" : "1");
//
//                    Timestamp receive_at = result.getAs("receive_at");
//                    String str = "2000-01-01 00:00:00";
//                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//                    Date parse = dateFormat.parse(str);
//                    applyListRow.setApplySubmitTime(receive_at.compareTo(new Timestamp(parse.getTime())) == 0 ? null : receive_at);
//                    applyListRows.add(applyListRow);
//
//                    longAccumulator.add(1);
//
//                    if (applyListRows.size() != 0 && applyListRows.size() % 200 == 0) {
//                        JdbcExecuters.prepareBatchUpdateExecuteApply(sql, applyListRows);
//                        applyListRows.clear();
//                    }
                    Object channel = result.getAs("channel");
                    if(Objects.isNull(channel)){
                        System.out.println("channel 为空--->"+result.toString());
                        channelLongAccumulator.add(1);
                    }
                    Object product_type = result.getAs("product_type");
                    if(Objects.isNull(product_type)){
                        System.out.println("product_type 为空--->"+result.toString());
                        productTypeLongAccumulator.add(1);
                    }
                    Object uuid = result.getAs("uuid");
                    if(Objects.isNull(uuid)){
                        System.out.println("uuid 为空--->"+result.toString());
                        uuidLongAccumulator.add(1);
                    }
                    Object order_no = result.getAs("order_no");
                    if(Objects.isNull(order_no)){
                        System.out.println("order_no 为空--->"+result.toString());
                        orderNoLongAccumulator.add(1);
                    }
                    Object credit_status = result.getAs("credit_status");
                    if(Objects.isNull(credit_status)){
                        System.out.println("apply_status 为空--->"+result.toString());
                        creditStatusLongAccumulator.add(1);
                    }


                } catch (Exception e) {
                    System.out.println("申请单清洗异常" + result.toString() + "----" + JSON.toJSONString(applyListRows));
                    e.printStackTrace();
                }
            });
//            JdbcExecuters.prepareBatchUpdateExecuteApply(sql, applyListRows);
        });
        System.out.println("longAccumulator 大小:"+longAccumulator.count());
        System.out.println("channelLongAccumulator 大小:"+channelLongAccumulator.count());
        System.out.println("productTypeLongAccumulator 大小:"+productTypeLongAccumulator.count());
        System.out.println("uuidLongAccumulator 大小:"+uuidLongAccumulator.count());
        System.out.println("orderNoLongAccumulator 大小:"+orderNoLongAccumulator.count());
        System.out.println("applyStatusLongAccumulator 大小:"+creditStatusLongAccumulator.count());

        ss.stop();
        System.out.println("完事");


    }

    public static Timestamp getCreditStatus(String credit_status, Row result) {
        if ("0".equals(credit_status) || "2".equals(credit_status) || "3".equals(credit_status)) {
            return null;
        }
        return result.getAs("receive_at");   ///4 也有receive_at
    }

    public static String getApplyStatus(String creditStatus, String applyStatus) {  //TODO applyStatus = 3 ???
        if (StringUtils.isNotBlank(applyStatus)) {
            if ("0".equals(applyStatus)) {
                return "3";
            } else if ("2".equals(applyStatus)) {
                return "4";
            } else if ("1".equals(applyStatus)) {
                return "4";
            }
        } else {
            if ("0".equals(creditStatus) || "2".equals(creditStatus) || "3".equals(creditStatus) || "4".equals(creditStatus)) {
                return "1";
            } else if ("1".equals(creditStatus)) {
                return "2";
            }
        }
        return "1";
    }

}
