package cn.quantgroup.dbc.utils;

import cn.quantgroup.dbc.spark.applyList.ApplyListRow;
import org.apache.commons.lang3.StringUtils;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;

import static cn.quantgroup.dbc.utils.HikDataSource.HIK_DATA_SOURCE;

/**
 * Created by renfeng on 2019/4/22.
 */
public class JdbcExecuters {


    /**
     * 查询
     * @return
     */
    public static String queryExecute(String sql)  {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource2.getConnection();
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            if(rs!=null&&rs.next())
                return rs.getString(1);
        }catch(SQLException e){
            e.printStackTrace();
        }finally {
            close(conn,st,rs);
        }
        return null;
    }

    public static List<String> queryListExecute(String sql){
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<>(20000);
        try {
            conn = HIK_DATA_SOURCE.dataSource2.getConnection();
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            while(rs!=null&&rs.next()) {
                list.add(rs.getString(1)+"\t"+rs.getString(2));
            }
        }catch(SQLException e){
            e.printStackTrace();
        }finally {
            close(conn,st,rs);
        }
        return list;
    }

    /**
     * 批量插入
     * @param sql
     */
    public static void batchUpdateExecute(String sql, String data){
        Connection conn = null;
        Statement st = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            st = conn.createStatement();
            try{
                st.executeUpdate(sql);
            }catch(SQLException e){
                System.out.println("======执行sql异常======"+sql+"\r\n"+"接上文原始数据======"+data+"======");
            }catch(Exception e){
                e.printStackTrace();
                System.out.println("======未知异常======"+sql+"\r\n"+"上文======"+data+"======");
            }
        }catch(Exception e){
            System.out.println("======执行sqlException异常======"+sql+"\r\n"+"接上文原始数据======"+data+"======");
            e.printStackTrace();
        }finally {
            close(conn,st,null);
        }
    }

    /**
     * 批量插入
     * @param sql
     * @param paramList
     */
    public static void prepareBatchUpdateExecute(String sql, List<List<String>> paramList){
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            statement = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for(List<String> param : paramList){
                try{
                    for (int i = 0; i < param.size(); i++) {
                        statement.setString(i + 1, param.get(i));
                    }
                    statement.addBatch();
                }catch(SQLException e){
                    System.out.println("======执行sql异常======"+sql+"\r\n");
                }catch(Exception e){
                    e.printStackTrace();
                    System.out.println("======未知异常======"+sql+"\r\n");
                }
            }
            statement.executeBatch();
            conn.commit();
        }catch(Exception e){
            System.out.println("======执行sqlException异常======"+sql+"\r\n");
            e.printStackTrace();
        }finally {
            close(conn, statement,null);
        }
    }


    public static void prepareBatchUpdateExecuteApply(String sql, List<ApplyListRow> applyListRows){
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for (int i = 0; i < applyListRows.size(); i++) {
                ApplyListRow applyListRow = applyListRows.get(i);
//                `channel_group_no`, `channel_id`, `product_type`, `uuid`, `apply_no`, `apply_status`, `audit_result`, `apply_submit_time`, `audit_valid_time`, `assets_result`, `assets_finish_time`, created_at
                ps.setString(1, applyListRow.getChannelGroupNo());
                ps.setString(2, applyListRow.getChannelId());
                ps.setString(3, applyListRow.getProductType());
                String uuid = applyListRow.getUuid();
                if(StringUtils.isBlank(uuid)){
                    System.out.println("orderNo: "+applyListRow.getApplyNo());
                    continue;
                }
                ps.setString(4, applyListRow.getUuid());
                ps.setString(5, applyListRow.getApplyNo());
                ps.setString(6, applyListRow.getApplyStatus());
                ps.setString(7, applyListRow.getAuditResult());
                ps.setTimestamp(8, applyListRow.getApplySubmitTime()==null?null:applyListRow.getApplySubmitTime());
                ps.setTimestamp(9, applyListRow.getAuditValidTime()==null?null:applyListRow.getAuditValidTime());
                ps.setString(10, applyListRow.getAssetsResult()==null?null:applyListRow.getAssetsResult());
                ps.setTimestamp(11, applyListRow.getAssetsFinishTime()==null?null:applyListRow.getAssetsFinishTime());
                ps.setTimestamp(12, applyListRow.getCreatedAt()==null?null:applyListRow.getCreatedAt());


                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
        }catch(Exception e){
            System.out.println("======执行sqlException异常======"+sql+"\r\n");
            e.printStackTrace();
        }finally {
            close(conn, ps,null);
        }
    }

    /**
     * 批量插入
     * @param sql
     * @param paramList
     */
    public static void prepareBatchUpdate(String sql, List<List<Object>> paramList){
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            statement = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for(List<Object> param : paramList){
                try{
                    for (int i = 0; i < param.size(); i++) {
                        Object object = param.get(i);
                        if (object == null || "".equals(object)) {
                            statement.setObject(i + 1, null);
                        }
                        else if (object instanceof String) {
                            statement.setString(i + 1, (String) object);
                        }
                        else if (object instanceof Long) {
                            statement.setLong(i + 1, (Long) object);
                        }
                        else {
                            statement.setObject(i + 1, object);
                        }
                    }
                    statement.addBatch();
                }catch(SQLException e){
                    e.printStackTrace();
                    System.out.println("======执行sql异常======"+param+"\r\n");
                }catch(Exception e){
                    e.printStackTrace();
                    System.out.println("======未知异常======"+param+"\r\n");
                }
            }
            statement.executeBatch();
            conn.commit();

        }catch(Exception e){
            System.out.println("======执行sqlException异常======"+sql+"\r\n");
            e.printStackTrace();
        }finally {
            close(conn, statement,null);
        }
    }


    /**
     * 批量插入
     * @param sqls
     */
    public static void batchUpdateExecute(List<String> sqls){
        Connection conn = null;
        Statement st = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            st = conn.createStatement();
            conn.setAutoCommit(false);
            for(String sql:sqls){
                try{
                    st.executeUpdate(sql);
                }catch(SQLException e){
                    System.out.println("======执行sql异常======"+sql+"\r\n");
                }catch(Exception e){
                    e.printStackTrace();
                    System.out.println("======未知异常======"+sql+"\r\n");
                }
            }
            conn.commit();
        }catch(Exception e){
            System.out.println("======执行sqlException异常======"+sqls+"\r\n");
            e.printStackTrace();
        }finally {
            close(conn,st,null);
        }
    }

    /**
     * 批量插入2
     * @param sqls
     */
    public static void batchUpdateExecutes(List<String> sqls) {
        Connection conn = null;
        Statement st = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            st = conn.createStatement();
            for(String sql:sqls){
                st.addBatch(sql);
            }
            try{
                st.executeBatch();
            }catch(SQLException e){
                System.out.println("======执行sql异常======\r\n");
            }catch(Exception e){
                e.printStackTrace();
                System.out.println("======未知异常======\r\n");
            }
        }catch(Exception e){
            System.out.println("======执行sqlException异常======"+sqls+"\r\n");
            e.printStackTrace();
        }finally {
            close(conn,st,null);
        }
    }


    /**
     * load
     * @param sql
     */
    public static void load(String sql) {
        Connection conn = null;
        Statement st = null;
        try {
            conn = HIK_DATA_SOURCE.dataSource.getConnection();
            st = conn.createStatement();

            st.execute(sql);

        }catch(Exception e){
            System.out.println("======执行sqlException异常======"+sql+"\r\n");
            e.printStackTrace();
        }finally {
            close(conn,st,null);
        }
    }





    /**
     * 关闭资源
     * @param conn
     * @param st
     * @param rs
     */
    private static void close(Connection conn,Statement st,ResultSet rs){
        try {
            if(rs!=null)
                rs.close();
            if(st!=null)
                st.close();
            if(conn!=null)
                conn.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }

    }


    public static void main(String[] args) {
        String s = queryExecute("select uuid from xyqb_user_i_user where phone_no = '18061666169'");
        System.out.println("========"+s);
    }




}
