package cn.quantgroup.dbc.spark.mobile;

import cn.quantgroup.dbc.bean.MobileCallDetailInfo;
import cn.quantgroup.dbc.bean.MobileSmsInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 *
 * 移动短信详单
 *
 * 手机号/发送时间/接收号码
 *
 * 费用/未使用/授权号码/对方号码/地点/发送时间/(发送标示 发送/接收)/创建时间
 *
 * @Author fengjunkai
 * @Date 2019-05-09 15:39
 */
public class MobileSmsDetailMain {

    public static void main(String[] args) {


        System.out.println("==========移动短信详单任务开始执行============");

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();

        //用户信息加载
        Dataset<String> user = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/user_info/part-00000");
        Dataset<UserInfo> userInfoDataset = user.map((MapFunction<String, UserInfo>) line -> {
            UserInfo person = new UserInfo();
            String[] split = line.split("\t");
            person.setPhone(split[0]);
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======"+userInfoDataset.head().getPhone());
        System.out.println("======================="+userInfoDataset.where("phone='18500192679'").head().getUuid());

        //移动通话详单加载
        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/mobile_sms_info/"+args[0]+"/*");

        Dataset<MobileSmsInfo> mobileMap = dataset.map((MapFunction<String, MobileSmsInfo>) line -> {
            String[] split = line.split("\t");
            MobileSmsInfo mobileSmsInfo = new MobileSmsInfo();

            try{
                String phone = split[3];
                String sendTime = split[6];
                String recePhone = split[4];
                String time = split[8];
                String tradeway = split[7];
                String allPay = split[1];
                String createTs = split[2];
                String sendAddr = split[5];

                mobileSmsInfo.setAllPay(StringUtils.isBlank(allPay)?null:allPay);
                mobileSmsInfo.setCreateTs(StringUtils.isBlank(createTs)?null:createTs);
                mobileSmsInfo.setPhone(PhoneNoUtils.getPhoneNoByRegx(phone, "移动短信详单授权手机号"));
                mobileSmsInfo.setReceiverPhone(PhoneNoUtils.getPhoneNoByRegx(recePhone, "移动短信详单接收号码"));
                mobileSmsInfo.setSentAddr(StringUtils.isBlank(sendAddr)?null:sendAddr);
                mobileSmsInfo.setSentTime(DateUtil.getCTimeFormat(sendTime, "移动短信详单发送时间"));
                mobileSmsInfo.setTradeway(StringUtils.isBlank(tradeway)?null:tradeway);
                mobileSmsInfo.setTimestamp(DateUtil.timeStamp2Date(time, "移动短信详单创建时间"));
            }catch(Exception e){
                System.out.println("=============未知异常============"+JSON.toJSONString(split));
                e.printStackTrace();
            }


            return mobileSmsInfo;
        }, Encoders.bean(MobileSmsInfo.class));

        System.out.println("==========移动短信清洗完成=============");

        Dataset<Row> finalRow = mobileMap.join(userInfoDataset, "phone");
        System.out.println("==============join完成================");

//        Dataset<Row> limit = finalRow.limit(10);
//        System.out.println("=================字段======"+limit.columns().toString());
//        limit.show();
//        List<Row> rows = limit.collectAsList();
//        for (Row row:rows){
//            System.out.println("================"+row.toString());
//        }

        ArrayList<String> sqls = new ArrayList<>(300);
        finalRow.foreach(row->{
            try {
                List<String> list = new ArrayList<>();
                try {

                    list.add(row.getString(1));
                    list.add(row.getString(2));
                    list.add(row.getString(0));
                    list.add(row.getString(3));
                    list.add(row.getString(4));
                    list.add(row.getString(5));
                    list.add(row.getString(7));
                    list.add(row.getString(6));
                    String uuid = row.getString(8);
                    String sql = "INSERT IGNORE INTO comservice_i_mobile_sms_info (uuid,allPay,createTs,phone,receiverPhone,sentAddr,sentTime,tradeway,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
                    if(sqls.size()!=0&&sqls.size()%200==0){
                        JdbcExecuters.batchUpdateExecute(sqls);
                        sqls.clear();
                    }else{
                        sqls.add(SqlUtil.getExecuteSql(list, sql));
                    }
                } catch (Exception e) {
                }
            } catch (ArrayIndexOutOfBoundsException a) {
            } catch (Exception e) {
                System.out.println("======移动未知异常======" + row.toString());
            }
        });
        JdbcExecuters.batchUpdateExecute(sqls);
        System.out.println("=====================移动短信详单执行完毕");
        ss.close();









//        System.out.println("==========移动短信详单任务开始执行=============任务个数="+(args.length-1));
//
//        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
//
//        List<String> list1 = Arrays.asList(args).subList(2, args.length);
//        System.out.println("======入参======"+ JSON.toJSONString(args));
//        System.out.println("======入参数据块======"+JSON.toJSONString(list1));
//
//        List<String> textFileList = new ArrayList<>();
//        String hdfs1 = "hdfs:///app/user/data/deeplearning/export_data/mobile_sms_info/"+args[0]+"/%s";
//        for(int i=0;i<list1.size();i++){
//            textFileList.add(String.format(hdfs1, list1.get(i)));
//        }
//
//        Map<String,String[]> textFileMap = PagingUtil.paging(textFileList, Integer.valueOf(args[1]));
//
//        ArrayList<String> sqls = new ArrayList<>(300);
//
//        textFileMap.forEach((k,v)->{
//            System.out.println("======"+k+"读取的hdfs======"+JSON.toJSONString(v));
//            Dataset<String> dataset = ss.read().textFile(v);
//            dataset.foreach(o -> {
//                try{
//                    String[] split = o.split("\t");
//                    List<String> list = new ArrayList<>();
//
//
//                    String phone = split[3];
//                    String sendTime = split[6];
//                    String recePhone = split[4];
//
//                    try{
//                        String allPay = split[1];
//                        list.add(StringUtils.isBlank(allPay)?null:allPay);
//                        String createTs = split[2];
//                        list.add(StringUtils.isBlank(createTs)?null:createTs);
//                        list.add(StringUtils.isBlank(phone)?null:PhoneNoUtils.getPhoneNoByRegx(phone, "移动短信详单授权手机号"));
//
//                        list.add(StringUtils.isBlank(recePhone)?null:PhoneNoUtils.getPhoneNoByRegx(recePhone, "移动短信详单接收号码"));
//
//                        String sendAddr = split[5];
//                        list.add(StringUtils.isBlank(sendAddr)?null:sendAddr);
//
//                        list.add(StringUtils.isBlank(sendTime)?null:DateUtil.getCTimeFormat(sendTime, "移动短信详单发送时间"));
//
//                        String tradeway = split[7];
//                        list.add(StringUtils.isBlank(tradeway)?null:tradeway);
//
//                        String time = split[8];
//                        list.add(StringUtils.isBlank(time)?null:DateUtil.timeStamp2Date(time, "移动短信详单创建时间"));
//
//                    }catch(Exception e){}
//
//                    String uuid = JedisUtil.jedisClient.getString(phone);
////                    if(StringUtils.isEmpty(uuid)){
////                        uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");
////                        System.out.println("===========uuid未命中==============");
////                    }
//
//                    String sql = "INSERT IGNORE INTO comservice_i_mobile_sms_info (uuid,allPay,createTs,phone,receiverPhone,sentAddr,sentTime,tradeway,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
//
//                    if(sqls.size()!=0&&sqls.size()%200==0){
//                        JdbcExecuters.batchUpdateExecute(sqls);
//                        sqls.clear();
//                    }else{
//                        sqls.add(SqlUtil.getExecuteSql(list, sql));
//                    }
//
//                }catch(ArrayIndexOutOfBoundsException a){
//                    System.out.println("======移动短信详单出现关键字段数组越界======"+o);
//                }catch(Exception e){
//                    System.out.println("======移动短信详单出现位置异常======"+o);
//                    e.printStackTrace();
//                }
//
//            });
//
//        });
//
//        System.out.println("=====================移动短信详单执行完毕");
//        ss.close();
    }

}
