package cn.quantgroup.dbc.spark.june;

import cn.quantgroup.dbc.bean.UnicomCallDetailInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.*;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

public class UnicomCallInfoApp {

    public static void main(String[] args) {

        System.out.println("=========联通通话详单任务开始执行=============任务数=" + args.length);
        System.out.println("本次导入" +  args[0]);

        SparkSession ss = SparkSession.builder().appName("UnicomCallInfoApp").getOrCreate();

        Dataset<UserInfo> userInfoDataset = ss.read().parquet("hdfs:///app/user/data/user_data/feng.ren/user_parquet").map(row -> {
            UserInfo userInfo = new UserInfo();
            userInfo.setPhone(row.getAs("phone"));
            userInfo.setUuid(row.getAs("uuid"));
            return userInfo;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======" + userInfoDataset.head().getPhone());
        System.out.println("======用户加载总数量======" + userInfoDataset.count());

        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/unicom_call_info/" + args[0]);

        Dataset<UnicomCallDetailInfo> unicomCallMap = dataset.filter(row -> row.split("\t", -1).length > 15)
                .map(row -> {
                    String[] split = row.split("\t", -1);
                    UnicomCallDetailInfo unicomCallDetailInfo = new UnicomCallDetailInfo();
                    String phone = PhoneNoUtils.getPhoneNoByRegx(split[12], "联通主叫号码");

                    String cTime = split[2];
                    String recevPhone = split[5];
                    String useTime = split[3];

                    try {
                        unicomCallDetailInfo.setBusinessType(StringUtils.isBlank(split[1]) ? null : split[1]);
                        unicomCallDetailInfo.setcTime(StringUtils.isBlank(cTime) ? null : DateUtil.getCTimeFormat(cTime, "联通通话开始时间"));
                        unicomCallDetailInfo.setTradeTime(StringUtils.isBlank(useTime) ? null : NumberUtil.getUseTimeFormat(useTime, "联通通话时间"));
                        unicomCallDetailInfo.setCallType(StringUtils.isBlank(split[4]) ? null : split[4]);
                        unicomCallDetailInfo.setReceiverPhone(StringUtils.isBlank(recevPhone) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "联通被叫号码"));
                        unicomCallDetailInfo.setTradeAddr(StringUtils.isBlank(split[6]) ? null : split[6]);
                        unicomCallDetailInfo.setTradeType(StringUtils.isBlank(split[7]) ? null : split[7]);
                        unicomCallDetailInfo.setBasePay(StringUtils.isBlank(split[8]) ? null : split[8]);
                        unicomCallDetailInfo.setLdPay(StringUtils.isBlank(split[9]) ? null : split[9]);
                        unicomCallDetailInfo.setOtherPay(StringUtils.isBlank(split[10]) ? null : split[10]);
                        unicomCallDetailInfo.setTotalPay(StringUtils.isBlank(split[11]) ? null : split[11]);
                        unicomCallDetailInfo.setPhone(StringUtils.isBlank(phone) ? null : PhoneNoUtils.getPhoneNoByRegx(phone.replaceAll(" ", ""), "联通主叫号码"));
                        unicomCallDetailInfo.setIscm(StringUtils.isBlank(split[13]) ? null : split[13]);
                        unicomCallDetailInfo.setReductionPay(StringUtils.isBlank(split[14]) ? null : split[14]);
                        unicomCallDetailInfo.setTimestamp(StringUtils.isBlank(split[15]) ? null : DateUtil.timeStamp2Date(split[15], "联通入库时间"));
                    } catch (Exception e) {
                        System.out.println("======未知异常======");
                        e.printStackTrace();
                    }
                    return unicomCallDetailInfo;
                }, Encoders.bean(UnicomCallDetailInfo.class));

        System.out.println("==========联通清洗完成=============");


        Dataset<Row> finalRow = unicomCallMap.join(userInfoDataset, "phone");

        System.out.println("======join总数量======" + finalRow.count());


        String sql = "INSERT IGNORE INTO comservice_i_unicom_call_info (uuid,businessType,cTime,tradeTime,callType,receiverPhone,tradeAddr,tradeType,basePay,ldPay,otherPay,totalPay,phone,iscm,reductionPay,timestamp) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

        finalRow.foreachPartition(line -> {
            List<List<String>> paramList = new ArrayList<>(500);

            line.forEachRemaining(row -> {
                try {
                    List<String> list = new ArrayList<>();
                    String uuid = StringUtils.isBlank(row.getAs("uuid")) ? null : row.getAs("uuid");
                    list.add(uuid);

                    list.add(row.getAs("businessType"));
                    list.add(row.getAs("cTime"));
                    list.add(row.getAs("tradeTime"));
                    list.add(row.getAs("callType"));
                    list.add(row.getAs("receiverPhone"));
                    list.add(row.getAs("tradeAddr"));
                    list.add(row.getAs("tradeType"));
                    list.add(row.getAs("basePay"));
                    list.add(row.getAs("ldPay"));
                    list.add(row.getAs("otherPay"));
                    list.add(row.getAs("totalPay"));
                    list.add(row.getAs("phone"));
                    list.add(row.getAs("iscm"));
                    list.add(row.getAs("reductionPay"));
                    list.add(row.getAs("timestamp"));

                    paramList.add(list);

                    if (paramList.size() != 0 && paramList.size() % 500 == 0) {
                        JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
                        paramList.clear();
                    }
                } catch (Exception e) {
                    System.out.println("======联通位置异常======" + row.toString());
                }
            });

            JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
        });


        System.out.println("=====================联通通话详单执行完毕");
        ss.close();
    }

}
