package cn.quantgroup.dbc.utils;


import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

import java.util.Map;
import java.util.Set;

/**
 * Created by renfeng on 2019/5/7.
 */
public enum JedisUtil {

    jedisClient;
    private JedisPool jedisPool;

    JedisUtil() {
        try {
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxIdle(20);
            config.setMaxTotal(20);
            config.setMinIdle(10);
            config.setTestOnBorrow(true);
            config.setMaxWaitMillis(3000);
            jedisPool = new JedisPool(config,"172.20.1.189",6379,20000);
            System.out.println("========redis.init完成=====");
        } catch (Exception e) {
            System.out.println("========redis.init异常=====");
            e.printStackTrace();
        }
    }


   public void setString(String key, String value, int expire){
        Jedis jedis =null;
        try{
            jedis = jedisPool.getResource();
            jedis.set(key, value);
            jedis.expire(key,expire);
        }catch(Exception e){
            System.out.println("========redis.setString异常=====");
            e.printStackTrace();
        }finally {
            if(jedis!=null){
                jedis.close();
            }
        }
    }

    public void setStringList(Map<String,String> map, int expire){
        Jedis jedis =null;
        try{
            jedis = jedisPool.getResource();
            for(Map.Entry<String, String> e:map.entrySet()){
                jedis.set(e.getKey(), e.getValue());
                jedis.expire(e.getKey(),expire);
            }
        }catch(Exception e){
            System.out.println("========redis.setString异常=====");
            e.printStackTrace();
        }finally {
            if(jedis!=null){
                jedis.close();
            }
        }
    }

   public String getString(String key){
      Jedis jedis =null;
      try{
          jedis = jedisPool.getResource();
          return jedis.get(key);
      }catch(Exception e){
          System.out.println("========redis.getString异常=====");
          e.printStackTrace();
      }finally {
          if(jedis!=null){
              jedis.close();
          }
      }
      return null;
   }





}

