package cn.quantgroup.dbc.spark.applyList;

import cn.quantgroup.dbc.utils.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.*;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author fengjunkai
 * @Date 2019-09-03 14:56
 */
public class ApplyListExportToBizFlowMain {

    public static void main(String[] args) {

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
        System.out.println("开始加载数据");
        Dataset<String> userInfoListDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/userInfoNew/part-m-00000");

        Dataset<UserInfoDataRow> userInfoListDataSetMap = userInfoListDataSet.map((MapFunction<String, UserInfoDataRow>) line -> {
            UserInfoDataRow person = new UserInfoDataRow();
            String[] split = line.split("\t");
            person.setId(Long.valueOf(split[0]));
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfoDataRow.class));

        System.out.println("转换用户信息完成" + userInfoListDataSetMap.count());

        Dataset<String> quotaCreditDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/quota_credit/part-m-00000");

        Dataset<QuotaCredit> quotaCreditDataSetMap = quotaCreditDataSet.map((MapFunction<String, QuotaCredit>) line -> {
            String quotaCreditTmp[] = line.split("\t");
            QuotaCredit quotaCreditRow = new QuotaCredit();
            try {
                quotaCreditRow.setUser_id(quotaCreditTmp[1]);
                quotaCreditRow.setCustomer_id(quotaCreditTmp[2]);
                quotaCreditRow.setProduct_id(quotaCreditTmp[3]);
                quotaCreditRow.setProduct_type(quotaCreditTmp[4]);
                quotaCreditRow.setChannel(quotaCreditTmp[6]);
                quotaCreditRow.setOrder_no(quotaCreditTmp[7]);
                quotaCreditRow.setReceive_at(Timestamp.valueOf(quotaCreditTmp[11]));
                quotaCreditRow.setCredit_status(quotaCreditTmp[12]);
                quotaCreditRow.setCreated_at(Timestamp.valueOf(quotaCreditTmp[13]));
            } catch (Exception e) {
                System.out.println("申请单异常" + JSON.toJSONString(quotaCreditTmp));
                e.printStackTrace();
            }
            return quotaCreditRow;
        }, Encoders.bean(QuotaCredit.class));

        System.out.println("转换申请单完成" + quotaCreditDataSetMap.count());

        Dataset<String> applyQuotaRecordDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/apply_quota_record/part-m-00000");

        Dataset<ApplyQuotaRecord> applyQuotaRecordDataSetMap = applyQuotaRecordDataSet.map((MapFunction<String, ApplyQuotaRecord>) line -> {
            String applyQuotaRecordTmp[] = line.split("\t");
            ApplyQuotaRecord applyQuotaRecordRow = new ApplyQuotaRecord();
            try {
                applyQuotaRecordRow.setUser_id(applyQuotaRecordTmp[1]);
                applyQuotaRecordRow.setUuid(applyQuotaRecordTmp[3]);
                applyQuotaRecordRow.setApply_time(Timestamp.valueOf(applyQuotaRecordTmp[4]));
                applyQuotaRecordRow.setApply_from(applyQuotaRecordTmp[5]);
                applyQuotaRecordRow.setProduct_type(applyQuotaRecordTmp[7]);
                applyQuotaRecordRow.setApply_status(applyQuotaRecordTmp[8]);
                applyQuotaRecordRow.setRisk_notify_time(Timestamp.valueOf(applyQuotaRecordTmp[11]));
                applyQuotaRecordRow.setOrder_no(applyQuotaRecordTmp[12]);
                try{
                    String s = applyQuotaRecordTmp[15];
                    applyQuotaRecordRow.setFund_result_at(StringUtils.isNotBlank(s) ? Timestamp.valueOf(applyQuotaRecordTmp[15]) : null);
                }catch(Exception e){

                }
            } catch (Exception e) {
                System.out.println("提交申请单异常" + JSON.toJSONString(applyQuotaRecordTmp));
                e.printStackTrace();
            }
            return applyQuotaRecordRow;
        }, Encoders.bean(ApplyQuotaRecord.class));

        System.out.println("转换提交的申请单完成" + applyQuotaRecordDataSetMap.count());

        userInfoListDataSetMap.createOrReplaceTempView("userInfoListDataSetMapView");
        quotaCreditDataSetMap.createOrReplaceTempView("quotaCreditDataSetMapView");
        applyQuotaRecordDataSetMap.createOrReplaceTempView("applyQuotaRecordDataSetMapView");
        System.out.println("创建三张表视图完成");

        SQLContext sqlContext = ss.sqlContext();
//        String sql = "INSERT INTO `apply_list` (`channel_group_no`, `channel_id`, `product_type`, `uuid`, `apply_no`, `apply_status`, `audit_result`, `apply_submit_time`) VALUES (?,?,?,?,?,?,?,?)";
        String sql = "INSERT INTO `apply_list` (`channel_group_no`, `channel_id`, `product_type`, `uuid`, `apply_no`, `apply_status`, `audit_result`, `apply_submit_time`, `audit_valid_time`, `assets_result`, `assets_finish_time`, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";

        Dataset<Row> dataset = sqlContext.sql("select a.product_type,a.channel,a.order_no,a.receive_at,a.credit_status,b.apply_time,a.created_at, b.apply_status,b.risk_notify_time,b.fund_result_at, c.uuid  from quotaCreditDataSetMapView a left join applyQuotaRecordDataSetMapView b on a.order_no = b.order_no left join userInfoListDataSetMapView c on a.user_id = c.id");
        System.out.println("dataset" + dataset.count());
        dataset.foreachPartition(line -> {
            List<ApplyListRow> applyListRows = new ArrayList<>(1000);
            line.forEachRemaining(result -> {
                try {
                    ApplyListRow applyListRow = new ApplyListRow();
                    applyListRow.setChannelGroupNo(result.getAs("channel"));
                    applyListRow.setChannelId(result.getAs("channel"));
                    applyListRow.setProductType(result.getAs("product_type"));
                    applyListRow.setUuid(result.getAs("uuid"));
                    applyListRow.setApplyNo(result.getAs("order_no"));

                    String credit_status = result.getAs("credit_status");
                    String apply_status = result.getAs("apply_status");
                    applyListRow.setApplyStatus(getApplyStatus(credit_status, apply_status));

                    applyListRow.setAuditResult("0".equals(apply_status) ? null : "1".equals(apply_status) ? "0" : "1");

                    Timestamp receive_at = result.getAs("receive_at");
                    String str = "2000-01-01 00:00:00";
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date parse = dateFormat.parse(str);
                    applyListRow.setApplySubmitTime(receive_at.compareTo(new Timestamp(parse.getTime())) == 0 ? null : receive_at);

                    Timestamp risk_notify_time = result.getAs("risk_notify_time");
                    applyListRow.setAuditValidTime(getAuditValidTime(risk_notify_time, parse));

                    Timestamp fund_result_at = result.getAs("fund_result_at");
                    applyListRow.setAssetsResult(getAssetsResult(apply_status, fund_result_at));
                    applyListRow.setAssetsFinishTime(getAssetsFinishTime(fund_result_at, apply_status));

                    Timestamp applyNoCreatedAt = result.getAs("created_at");
                    applyListRow.setCreatedAt(applyNoCreatedAt);

                    applyListRows.add(applyListRow);

                    if (applyListRows.size() != 0 && applyListRows.size() % 200 == 0) {
                        JdbcExecuters.prepareBatchUpdateExecuteApply(sql, applyListRows);
                        applyListRows.clear();
                    }

                } catch (Exception e) {
                    System.out.println("申请单清洗异常" + result.toString() + "----" + JSON.toJSONString(applyListRows));
                    e.printStackTrace();
                }
            });
            JdbcExecuters.prepareBatchUpdateExecuteApply(sql, applyListRows);
        });

        ss.stop();
        System.out.println("完事");


    }

    public static Timestamp getAssetsFinishTime(Timestamp fund_result_at, String apply_status) {
        if ("3".equals(apply_status)) {
            return fund_result_at;
        }
        return null;
    }

    public static String getAssetsResult(String apply_status, Timestamp fund_result_at) {

        if (fund_result_at == null && "2".equals(apply_status)) {
            return "1";
        }
        return "0";
    }

    public static Timestamp getAuditValidTime(Timestamp riskNotifyTime, Date parse) {
        if (new Timestamp(parse.getTime()).compareTo(riskNotifyTime) == 0) {
            return null;
        }
        LocalDateTime riskNotifyTimeLocaDateTime = riskNotifyTime.toLocalDateTime().plusDays(30);
        return Timestamp.valueOf(riskNotifyTimeLocaDateTime);
    }

    public static String getApplyStatus(String creditStatus, String applyStatus) {
        if (StringUtils.isNotBlank(applyStatus)) {
            if ("0".equals(applyStatus)) {
                return "3";
            } else if ("1".equals(applyStatus) || "2".equals(applyStatus)) {
                return "4";
            } else if ("3".equals(applyStatus)) {
                return "5";
            }
        }/* else {
            if ("0".equals(creditStatus) || "2".equals(creditStatus) || "3".equals(creditStatus) || "4".equals(creditStatus)) {
                return "1";
            } else if ("1".equals(creditStatus)) {
                return "2";
            }
        }*/
        if ("1".equals(creditStatus)) {
            return "2";
        }
        return "1";
    }

}
