package cn.quantgroup.dbc.spark;

import cn.quantgroup.dbc.utils.DateUtil;
import cn.quantgroup.dbc.utils.JdbcExecuters;
import cn.quantgroup.dbc.utils.NumberUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author fengjunkai
 * @Date 2019-04-26 14:30
 */
public class PhoneBillInfoMain {

    public static void main(String[] args) {

        System.out.println("==========通话账单任务开始执行=============");

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();

        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/phone_bill_info/*/*");

        dataset.foreach(o -> {
            String[] split = o.split("\t");
            List<String> list = new ArrayList<>();
            String phone = "";
            //取前4个元素(手机号/姓名/账单月/账单金额), 主要是用到的有 手机号/账单月/账单金额
            try {
                phone = split[1];
                list.add(StringUtils.isBlank(phone) ? null : phone.replaceAll(" ", ""));
                list.add(StringUtils.isBlank(split[2]) ? null : DateUtil.string2DateEnglish(split[2], "手机通话账单月"));
                list.add(StringUtils.isBlank(split[3]) ? null : split[3]);
                list.add(StringUtils.isBlank(split[4]) ? null : NumberUtil.amountToFormat(split[4], "手机通话账单金额"));
                try{
                    list.add(StringUtils.isBlank(split[5]) ? null : split[5]);
                    list.add(StringUtils.isBlank(split[6]) ? null : split[6]);
                    list.add(StringUtils.isBlank(split[7]) ? null : split[7]);
                    list.add(StringUtils.isBlank(split[8]) ? null : DateUtil.timeStamp2Date(split[8].replaceAll(" ", ""), "手机通话账单创建时间"));
                }catch(Exception e){
                }

//                "INSERT IGNORE INTO comservice_i_phone_bill_info (uuid,phoneNo,billDay,name,amount,dependCycle,billPackage,content,timestamp)
//                values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";

                String uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");

                JdbcExecuters.batchUpdateExecute(getExecuteSql(list, uuid), JSON.toJSONString(split));

            }catch(ArrayIndexOutOfBoundsException a){  //已知异常不管
            } catch (Exception e) {
                System.out.println("======通话账单未知异常======");
                e.printStackTrace();
            }


        });
        System.out.println("======通话账单数据清洗执行完毕======");
        ss.close();


//        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
//
//        Dataset<String> ds = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/phone_bill_info/*/*");
//
//        Dataset<String> limit = ds.limit(100000);
//
//
//        Dataset<ComserviceIPhoneBillInfo> map = limit.map((MapFunction<String, ComserviceIPhoneBillInfo>) line -> {
//            String[] split = line.split("\t");
//
//            System.out.println("======原始数据======"+line);
//
//            String uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + split[1] + "'");
//
//            ComserviceIPhoneBillInfo comserviceIPhoneBillInfo = new ComserviceIPhoneBillInfo();
//            comserviceIPhoneBillInfo.setUuid(uuid);
//            comserviceIPhoneBillInfo.setPhoneNo(split[1]);
//            comserviceIPhoneBillInfo.setBillDay(StringUtils.isBlank(split[2]) ? null : DateUtil.string2DateEnglish(split[2], "手机通话账单月"));
//            comserviceIPhoneBillInfo.setName(StringUtils.isBlank(split[3]) ? null : split[3]);
//            comserviceIPhoneBillInfo.setAmount(StringUtils.isBlank(split[4]) ? null : NumberUtil.amountToFormat(split[4], "手机通话账单金额"));
//            comserviceIPhoneBillInfo.setDependCycle(StringUtils.isBlank(split[5]) ? null : split[5]);
//            comserviceIPhoneBillInfo.setBillPackage(StringUtils.isBlank(split[6]) ? null : split[6]);
//            comserviceIPhoneBillInfo.setContent(StringUtils.isBlank(split[7]) ? null : split[7]);
//            comserviceIPhoneBillInfo.setTimestamp(StringUtils.isBlank(split[8]) ? null : DateUtil.timeStamp2Date(split[8], "手机通话账单创建时间"));
//            return comserviceIPhoneBillInfo;
//        }, Encoders.bean(ComserviceIPhoneBillInfo.class));
//
//        System.out.println("======清洗数据完成");
//
//        System.out.println("======去重前======"+map.count());
//
//        Dataset<ComserviceIPhoneBillInfo> duplicates = map.dropDuplicates(new String[]{"phoneNo", "billDay"});
//
//        System.out.println("======去重后======"+duplicates.count());
//
//
//        duplicates.repartition(36).write()
//                .mode("append")
//                .format("jdbc")
//                .option("driver", "com.mysql.jdbc.Driver")
//                .option("url", "jdbc:mysql://10.17.115.6:4010/rc_comservice_data_pool_v2?useUnicode=true&characterEncoding=UTF8&rewriteBatchedStatements=true")
//                .option("useSSL", "false")
//                .option(JDBCOptions.JDBC_BATCH_INSERT_SIZE(), 200)
//                .option("dbtable", "comservice_i_phone_bill_info") // database name and table name here
//                .option("isolationLevel", "NONE") // recommended to set isolationLevel to NONE if you have a large DF to load.
//                .option("user", "rc_comservice_data_pool_v2_w")
//                .option("password", "w9pr8IPJkLmUSBe4") // TiDB user here
//                .save();
//        ss.stop();
//        ss.close();

//        System.out.println("==========手机通话账单任务开始执行=============");
////        SparkConf conf = new SparkConf().setAppName("DBC");
//
//        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
//
//        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/phone_bill_info/*/*");
//
//        System.out.println("========phone_bill_info表总行数======" + dataset.count());
//
//        dataset = dataset.limit(10);
//
//        // phoneNo billDay name amount dependCycle billPackage content timestamp
//
//        dataset.foreach(o -> {
//            System.out.println("======原始记录======" + o);
//            String split[] = o.split("\t");
//
//        List<String> list = new ArrayList<>();
//        String phoneNo = split[1];
//        list.add(phoneNo); //手机号
//        list.add(StringUtils.isBlank() ? null : DateUtil.string2DateEnglish(split[2], "手机通话账单解析账单月")); //账单月份
//        list.add(); //姓名
//        list.add(StringUtils.isBlank() ? null : NumberUtil.amountToFormat(split[4], "手机通话账单账单金额")); //账单金额
//        list.add(StringUtils.isBlank(split[5]) ? null : split[5]); //账单周期
//        list.add(StringUtils.isBlank(split[6]) ? null : split[6]); //当月账单套餐名称
//        list.add(StringUtils.isBlank(split[7]) ? null : split[7]); //费用详情
//        list.add(StringUtils.isBlank(split[8]) ? null : DateUtil.timeStamp2Date(split[8], "手机通话账单")); //创建时间
//
//            System.out.println("======list======" + JSON.toJSONString(list));
//
//        });
//
//        System.out.println("======完事======");


    }


    public static String getExecuteSql(List<String> list, String uuid) {
        String str = "INSERT IGNORE INTO comservice_i_phone_bill_info (uuid,phoneNo,billDay,name,amount,dependCycle,billPackage,content,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
        String formatStr = "";
        for (int i = 0; i < list.size(); i++) {
            String string = list.get(i);
            if (string == null) {
                formatStr += (string + (i == list.size() - 1 ? "" : ","));
            } else {
                formatStr += ("'" + StringUtils.replaceAll(string, "'", "") + "'" + (i == list.size() - 1 ? "" : ","));
            }
        }
        return String.format(str, formatStr);
    }


}
