package cn.quantgroup.dbc.spark.applyList;

import cn.quantgroup.dbc.utils.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.*;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author fengjunkai
 * @Date 2019-09-03 14:56
 */
public class ApplyListExportToBizFlowMain {

    public static void main(String[] args) {

        SparkSession ss = SparkSession.builder().appName("DBC").getOrCreate();
        System.out.println("开始加载数据");
//        Dataset<String> userInfoListDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/userInfoNew11/part-m-00000");
        Dataset<String> userInfoListDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/userInfoNew22/part-m-00000");

        Dataset<UserInfoDataRow> userInfoListDataSetMap = userInfoListDataSet.map((MapFunction<String, UserInfoDataRow>) line -> {
            UserInfoDataRow person = new UserInfoDataRow();
            String[] split = line.split("\t");
            person.setId(Long.valueOf(split[0]));
            person.setUuid(split[1]);
            return person;
        }, Encoders.bean(UserInfoDataRow.class));

        System.out.println("转换用户信息完成" + userInfoListDataSetMap.count());

//        Dataset<String> quotaCreditDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/quota_credit11/part-m-00000");
        Dataset<String> quotaCreditDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/quota_credit22/part-m-00000");

        Dataset<QuotaCredit> quotaCreditDataSetMap = quotaCreditDataSet.map((MapFunction<String, QuotaCredit>) line -> {
            String quotaCreditTmp[] = line.split("\t");
            QuotaCredit quotaCreditRow = new QuotaCredit();
            try {
                quotaCreditRow.setUser_id(quotaCreditTmp[1]);
                quotaCreditRow.setCustomer_id(quotaCreditTmp[2]);
                quotaCreditRow.setProduct_id(quotaCreditTmp[3]);
                quotaCreditRow.setProduct_type(quotaCreditTmp[4]);
                quotaCreditRow.setChannel(quotaCreditTmp[6]);
                quotaCreditRow.setOrder_no(quotaCreditTmp[7]);
                quotaCreditRow.setReceive_at(Timestamp.valueOf(quotaCreditTmp[11]));
                quotaCreditRow.setCredit_status(quotaCreditTmp[12]);
                quotaCreditRow.setCreated_at(Timestamp.valueOf(quotaCreditTmp[13]));
            } catch (Exception e) {
                System.out.println("申请单异常" + JSON.toJSONString(quotaCreditTmp));
                e.printStackTrace();
            }
            return quotaCreditRow;
        }, Encoders.bean(QuotaCredit.class));

        System.out.println("转换申请单完成" + quotaCreditDataSetMap.count());

//        Dataset<String> applyQuotaRecordDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/apply_quota_record11/part-m-00000");
        Dataset<String> applyQuotaRecordDataSet = ss.read().textFile("hdfs:///app/user/data/user_data/feng.ren/applyList/apply_quota_record22/part-m-00000");

        Dataset<ApplyQuotaRecord> applyQuotaRecordDataSetMap = applyQuotaRecordDataSet.map((MapFunction<String, ApplyQuotaRecord>) line -> {
            String applyQuotaRecordTmp[] = line.split("\t");
            ApplyQuotaRecord applyQuotaRecordRow = new ApplyQuotaRecord();
            try {
                applyQuotaRecordRow.setUser_id(applyQuotaRecordTmp[1]);
                applyQuotaRecordRow.setUuid(applyQuotaRecordTmp[3]);
                applyQuotaRecordRow.setApply_time(Timestamp.valueOf(applyQuotaRecordTmp[4]));
                applyQuotaRecordRow.setApply_from(applyQuotaRecordTmp[5]);
                applyQuotaRecordRow.setProduct_type(applyQuotaRecordTmp[7]);
                applyQuotaRecordRow.setApply_status(applyQuotaRecordTmp[8]);
                applyQuotaRecordRow.setRisk_notify_time(Timestamp.valueOf(applyQuotaRecordTmp[11]));
                applyQuotaRecordRow.setOrder_no(applyQuotaRecordTmp[12]);
                try{
                    String s = applyQuotaRecordTmp[15];
                    applyQuotaRecordRow.setFund_result_at(StringUtils.isNotBlank(s) ? Timestamp.valueOf(applyQuotaRecordTmp[15]) : null);
                }catch(Exception e){

                }
            } catch (Exception e) {
                System.out.println("提交申请单异常" + JSON.toJSONString(applyQuotaRecordTmp));
                e.printStackTrace();
            }
            return applyQuotaRecordRow;
        }, Encoders.bean(ApplyQuotaRecord.class));

        System.out.println("转换提交的申请单完成" + applyQuotaRecordDataSetMap.count());

        userInfoListDataSetMap.createOrReplaceTempView("userInfoListDataSetMapView");
        quotaCreditDataSetMap.createOrReplaceTempView("quotaCreditDataSetMapView");
        applyQuotaRecordDataSetMap.createOrReplaceTempView("applyQuotaRecordDataSetMapView");
        System.out.println("创建三张表视图完成");

        SQLContext sqlContext = ss.sqlContext();
//        String sql = "INSERT INTO `apply_list` (`channel_group_no`, `channel_id`, `product_type`, `uuid`, `apply_no`, `apply_status`, `audit_result`, `apply_submit_time`) VALUES (?,?,?,?,?,?,?,?)";
        String sql = "INSERT IGNORE INTO `apply_list` (`channel_group_no`, `channel_id`, `product_type`, `uuid`, `apply_no`, `apply_status`, `audit_result`, `apply_submit_time`, `audit_valid_time`, `assets_result`, `assets_finish_time`, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
//        String sql = "INSERT IGNORE INTO `apply_list_test` (`channel_group_no`, `channel_id`, `product_type`, `uuid`, `apply_no`, `apply_status`, `audit_result`, `apply_submit_time`, `audit_valid_time`, `assets_result`, `assets_finish_time`, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";

        Dataset<Row> dataset = sqlContext.sql("select a.product_type,a.channel,a.order_no,a.receive_at,a.credit_status,b.apply_time,a.created_at, b.apply_status,b.risk_notify_time,b.fund_result_at, c.uuid  from quotaCreditDataSetMapView a left join applyQuotaRecordDataSetMapView b on a.order_no = b.order_no left join userInfoListDataSetMapView c on a.user_id = c.id");
        System.out.println("dataset" + dataset.count());
        dataset.repartition(2).foreachPartition(line -> {
//        dataset.foreachPartition(line -> {
            List<ApplyListRow> applyListRows = new ArrayList<>(1000);
            line.forEachRemaining(result -> {
                try {
                    ApplyListRow applyListRow = new ApplyListRow();
                    applyListRow.setChannelGroupNo(result.getAs("channel"));
                    applyListRow.setChannelId(result.getAs("channel"));
                    applyListRow.setProductType(result.getAs("product_type"));
                    applyListRow.setUuid(result.getAs("uuid"));
                    String orderNo = result.getAs("order_no");
                    applyListRow.setApplyNo(orderNo);

                    String credit_status = result.getAs("credit_status");
                    String apply_status = result.getAs("apply_status");
                    applyListRow.setApplyStatus(getApplyStatus(credit_status, apply_status));

                    applyListRow.setAuditResult(getAuditResult(apply_status, orderNo));

                    Timestamp receive_at = result.getAs("receive_at");
                    String str = "2000-01-01 00:00:00";
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date parse = dateFormat.parse(str);
                    applyListRow.setApplySubmitTime(receive_at.compareTo(new Timestamp(parse.getTime())) == 0 ? null : receive_at);

                    Timestamp risk_notify_time = result.getAs("risk_notify_time");
                    applyListRow.setAuditValidTime(getAuditValidTime(risk_notify_time, parse, apply_status, orderNo));

                    Timestamp fund_result_at = result.getAs("fund_result_at");
                    applyListRow.setAssetsResult(getAssetsResult(apply_status, fund_result_at));
                    applyListRow.setAssetsFinishTime(getAssetsFinishTime(fund_result_at, apply_status, risk_notify_time, orderNo, parse));

                    Timestamp applyNoCreatedAt = result.getAs("created_at");
                    applyListRow.setCreatedAt(applyNoCreatedAt);

                    applyListRows.add(applyListRow);

                    if (applyListRows.size() != 0 && applyListRows.size() % 200 == 0) {
                        JdbcExecuters.prepareBatchUpdateExecuteApply(sql, applyListRows);
                        applyListRows.clear();
                    }

                } catch (Exception e) {
                    System.out.println("申请单清洗异常" + result.toString() + "----" + JSON.toJSONString(applyListRows));
                    e.printStackTrace();
                }
            });
            JdbcExecuters.prepareBatchUpdateExecuteApply(sql, applyListRows);
        });

        ss.stop();
        System.out.println("完事");


    }

    public static String getAuditResult(String apply_status, String orderNo){  //已提交申请表
        if(StringUtils.isBlank(apply_status) || "0".equals(apply_status)){  //未提交申请的 直接返回null       //0发起申请风控审核中
            return null;
        }

        if("1".equals(apply_status)){   // 1 审核拒绝
            return "0"; //biz 拒绝
        }
        if("2".equals(apply_status) || "3".equals(apply_status)){ // 2风控审核通过 3 资方拒绝
            return "1"; //biz 风控审核一定是通过
        }

        System.out.println("getAuditResult出现未知结果"+orderNo);
        return null; //未知情况为空
    }

    public static Timestamp getAssetsFinishTime(Timestamp fund_result_at, String apply_status, Timestamp risk_notify_time, String orderNo, Date parse) {

        if(StringUtils.isBlank(apply_status)){ //apply_status = null 一定是未提交申请单
            return null;
        }

        if(fund_result_at!=null || "3".equals(apply_status)){ //fund_result_at 不为空 即 apply_status = 3 一定不为空
            return fund_result_at;
        }

        if("1".equals(apply_status)){  //说明该申请单提交成功授信了 1-风控审核拒绝
            if(new Timestamp(parse.getTime()).compareTo(risk_notify_time) == 0){
                return null; //召回
            }
            return risk_notify_time; //返回风控审核通知时间
        }

//        System.out.println("getAssetsFinishTime出现未知结果"+orderNo);
        return null;
    }

    public static String getAssetsResult(String apply_status, Timestamp fund_result_at) { // fund_result_at为null 且 apply_status为2 并不清楚资方是否审核通过还是拒绝

        if("3".equals(apply_status) || "1".equals(apply_status)){ //资方审核拒绝  只有这个时候才知道资产分发状态是成功还是失败   apply_status = 1 拒绝 资方拒绝
            return "0"; //biz 0 失败
        }

        return null;
    }

    public static Timestamp getAuditValidTime(Timestamp riskNotifyTime, Date parse, String apply_status, String orderNo) {
        if (riskNotifyTime==null || new Timestamp(parse.getTime()).compareTo(riskNotifyTime) == 0) {  // null 未提交申请  风控没有通知审核结果比如apply_status为3的时候 默认"2000-01-01 00:00:00" 都返回null
            return null;
        }
        if(StringUtils.equalsAny(apply_status, "1", "2", "3")){ //1 拒绝 2 通过 3 资方拒绝 这个时候一定会有风控审核完成通知时间
            LocalDateTime riskNotifyTimeLocaDateTime = riskNotifyTime.toLocalDateTime().plusDays(30); //已提交 且风控通知审核结果
            return Timestamp.valueOf(riskNotifyTimeLocaDateTime);
        }
        System.out.println("获取审核有效期字段值出现未知结果"+orderNo);
        return null; //未知情况返回null；

    }

    public static String getApplyStatus(String creditStatus, String applyStatus) {

        if(StringUtils.isNotBlank(applyStatus)){   //已提交的申请
            if("0".equals(applyStatus)){  //发起授信
                return "3";  //biz   授信审核中
            }else if(StringUtils.equalsAny(applyStatus, "1", "2", "3")){  //拒绝 通过 资方拒绝
                return "5"; //biz 资产分发完成
            }
        }
        if("1".equals(creditStatus)){        //未提交的申请   授信成功
            return "2";  //biz 已填写为授信
        }else{  // 0发起授信  2提交申请失败 3授信处理中
            return "1";  // biz 创建申请单
        }
    }

}
