package cn.quantgroup.dbc.utils;

import org.apache.commons.lang.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * @Author fengjunkai
 * @Date 2019-04-26 16:03
 */
public class DateUtil {

    public static String getCTimeFormat(String cTime, String dataType) {


        if (StringUtils.isBlank(cTime)) {
            return null;
        }

        if (!cTime.startsWith("1") && !cTime.startsWith("2")) {
            return null;
        }

        String errorTime = "1960-01-01 00:00:00";
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date errorDate = simpleDateFormat1.parse(errorTime);

            int cTimeLength = cTime.length();
            String cTimeStr = cTime.trim();
            if (19 == cTimeLength) {

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = simpleDateFormat.parse(cTimeStr);
                if (date.compareTo(errorDate) <= 0 || date.compareTo(new Date()) > 0) {
                    return null;
                }
                return cTimeStr;

            } else if (20 == cTimeLength && cTimeStr.contains("年") && cTimeStr.contains("分")) {

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd日HH时mm分ss秒");
                Date date = simpleDateFormat.parse(cTimeStr);
                if (date.compareTo(errorDate) <= 0 || date.compareTo(new Date()) > 0) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return simpleDateFormat2.format(date);

            } else if (21 == cTimeLength && cTimeStr.contains("年") && cTimeStr.contains("分")) {

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd日 HH时mm分ss秒");
                Date date = simpleDateFormat.parse(cTimeStr);
                if (date.compareTo(errorDate) <= 0 || date.compareTo(new Date()) > 0) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return simpleDateFormat2.format(cTimeStr);

            } else if (13 == cTimeLength && isLongDate(cTimeStr, dataType)) { //1590909284321

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date(Long.valueOf(cTimeStr));
                if (date.compareTo(errorDate) <= 0 || date.compareTo(new Date()) > 0) {
                    return null;
                }
                return simpleDateFormat.format(date);

            }

        } catch (ParseException e) {
            System.out.println("======" + dataType + "异常======" + cTime);
        }

        return cTime;

    }

    public static String string2DateEnglish(String dateFormatStr, String dataType) {
        if (StringUtils.isBlank(dateFormatStr)) {
            return null;
        }

        if (!dateFormatStr.startsWith("1") && !dateFormatStr.startsWith("2")) {
            return null;
        }

        String dateStr = dateFormatStr.replaceAll("年", "").replaceAll("月", "").replaceAll("日", "");
        if (dateStr.length() == 6) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
                sdf.parse(dateStr);
                return dateStr;
            } catch (Exception e) {
                System.out.println("======" + dataType + "异常======" + dateFormatStr);
            }
            return dateFormatStr;
        }

        if (isLongDate(dateFormatStr, dataType + "判断是否long类型时间戳异常")) {
            try {
                Date date = new Date(Long.valueOf(dateFormatStr));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
                return simpleDateFormat.format(date);
            } catch (Exception e) {
                System.out.println("======" + dataType + "时间戳转日期yyyyMM异常======" + dateFormatStr);
                return dateFormatStr;
            }
        }

        try {
            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd,yyyy HH:mm:ss a", Locale.ENGLISH);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
            return simpleDateFormat.format(sdf.parse(dateFormatStr));
        } catch (ParseException e) {
            System.out.printf("======" + dataType + "异常======" + dateFormatStr);
        }
        return dateFormatStr;
    }

    public static String timeStamp2Date(String timeStamp, String dataType) {
        if (timeStamp.contains("\\N")) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(new Date(Long.valueOf(timeStamp)));
        } catch (Exception e) {
            System.out.println("======" + dataType + "======" + timeStamp);
        }
        return null;
    }

    public static String dateString2Format(String date, String dataType) {
        try {
            if (!date.startsWith("1") && !date.startsWith("2")) {
                return null;
            }

            try {
                if (date.contains("年") && date.contains("秒")) { //2019年09月18日 23时23分23秒
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd HH时mm分ss秒");
                    SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return simpleDateFormat1.format(simpleDateFormat.parse(date));
                }
            } catch (Exception e) {
                System.out.println("======" + dataType + "年月日类型日期解析异常======" + date);
                e.printStackTrace();
                return date;
            }

            if (isLongDate(dataType, dataType)) {
                try {
                    SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date1 = new Date(Long.valueOf(date));
                    return simpleDateFormat1.format(date1);
                } catch (Exception e) {
                    System.out.println("======Long类型" + dataType + "异常======" + dataType);
                    e.printStackTrace();
                }
                return date;
            }

            String errTime = "1960-01-01 00:00:00";
            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date errDate = simpleDateFormat1.parse(errTime);

            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date dateTime = simpleDateFormat.parse(date);

            if (dateTime.compareTo(errDate) <= 0 || dateTime.compareTo(new Date()) > 0) {
                return null;
            }


            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(dateTime);
        } catch (Exception e) {
            System.out.println("======" + dataType + "======" + date);
        }
        return date;
    }

    public static boolean isLongDate(String longStr, String dataType) {
        if (StringUtils.length(longStr) == 13) {
            try {
                Long.valueOf(longStr);
                return true;
            } catch (Exception e) {
                System.out.println("======" + dataType + "======" + longStr);
                return false;
            }
        } else {
            return false;
        }
    }

}
