package cn.quantgroup.dbc.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * 手机号清洗规则
 *
 * @Author fengjunkai
 * @Date 2019-04-29 15:02
 */
public class PhoneNoUtils {

    public static String getPhoneNoByRegx(String phone, String dataType){

        if(StringUtils.isBlank(phone)){
            return null;
        }

        try{
            String phoneNo = Pattern.compile("[^0-9]").matcher(phone).replaceAll("");


            if(StringUtils.length(phoneNo)==7 && StringUtils.startsWith(phoneNo, "86")){
                return StringUtils.replaceFirst(phoneNo, "86", "");
            }else if(StringUtils.startsWith(phoneNo, "86125832")){
                return StringUtils.replaceFirst(phoneNo, "86125832", "");
            }else if(StringUtils.startsWith(phoneNo, "0086125832")){
                return StringUtils.replaceFirst(phoneNo, "0086125832", "");
            }else if(13==phoneNo.length() && StringUtils.startsWith(phoneNo, "86")){
                return StringUtils.replaceFirst(phoneNo, "86", "");
            }else if(13==phoneNo.length() && StringUtils.startsWith(phoneNo, "001")){
                return StringUtils.replaceFirst(phoneNo, "00", "");
            }else if(StringUtils.startsWith(phoneNo, "+86")){
                return StringUtils.replaceFirst(phoneNo, "+86", "");
            }else if(StringUtils.startsWith(phoneNo, "0086")){
                return StringUtils.replaceFirst(phoneNo, "0086", "");
            }
        }catch(Exception e){
            System.out.println("======"+dataType+"异常======"+phone);
        }

        return phone;

    }

}
