package cn.quantgroup.dbc.spark.telecom;

import cn.quantgroup.dbc.utils.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

/**
 * 电信通话详单
 * <p>
 * <p>
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:09 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1501516800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:14 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1504108800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:19 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1506700800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:24 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1509292800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:28 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1511884800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:29 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1514476800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:30 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1517068800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:31 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1519660800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:33 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1522252800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:34 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1524844800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:36 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1527436800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:37 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1530028800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:38 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1532620800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:40 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1535212800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:41 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1537804800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:43 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1540396800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:45 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1542988800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:47 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1545580800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:49 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1548172800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:51 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1550764800000
 * drwxr-xr-x   - deeplearning deeplearning          0 2019-04-23 10:53 /app/user/data/deeplearning/export_data/telecom_call_info/mt=1553356800000 ----running
 * <p>
 * <p>
 * <p>
 * spark2-submit --master yarn --deploy-mode cluster \
 * --driver-memory 4g \
 * --executor-memory 24g --num-executors 20 \
 * --executor-cores 10 --queue online_job \
 * --class cn.quantgroup.dbc.spark.telecom.TelecomDetailInfoMain \
 * /home/feng.ren/qg-dbc-spark-4.0-SNAPSHOT-telecom-detail-info-jar-with-dependencies.jar "mt=1553356800000" "000000_0" "000001_0" "000002_0" "000003_0" "000004_0" "000005_0" "000006_0" "000007_0" "000008_0" "000009_0" "000010_0" "000011_0" "000012_0" "000013_0" "000014_0" "000015_0" "000016_0" "000017_0" "000018_0" "000019_0" "000020_0" "000021_0" "000022_0" "000023_0" "000024_0" "000025_0" "000026_0" "000027_0" "000028_0" "000029_0" "000030_0" "000031_0" "000032_0" "000033_0" "000034_0" "000035_0" "000036_0" "000037_0" "000038_0" "000039_0" "000040_0" "000041_0" "000042_0" "000043_0" "000044_0" "000045_0" "000046_0" "000047_0" "000048_0" "000049_0" "000050_0" "000051_0" "000052_0" "000053_0" "000054_0" "000055_0" "000056_0" "000057_0" "000058_0" "000059_0" "000060_0" "000061_0" "000062_0" "000063_0" "000064_0" "000065_0" "000066_0" "000067_0" "000068_0" "000069_0" "000070_0" "000071_0" "000072_0" "000073_0" "000074_0" "000075_0" "000076_0" "000077_0" "000078_0" "000079_0" "000080_0" "000081_0" "000082_0" "000083_0" "000084_0" "000085_0" "000086_0" "000087_0" "000088_0" "000089_0" "000090_0" "000091_0" "000092_0" "000093_0" "000094_0" "000095_0" "000096_0" "000097_0" "000098_0" "000099_0" "000100_0" "000101_0" "000102_0" "000103_0" "000104_0" "000105_0" "000106_0" "000107_0" "000108_0" "000109_0" "000110_0" "000111_0" "000112_0" "000113_0" "000114_0" "000115_0"
 *
 * @Author fengjunkai
 * @Date 2019-04-29 10:19
 */
public class TelecomDetailInfoMain4 {

    public static void main(String[] args) {
        System.out.println("==========电信通话详单任务开始执行=============任务数=" + args.length);


        for (int i = 0; i < 117; i++) {
            String path = "/home/feng.ren/localfile/part-00"+i;

            System.out.println("=====path======" + path);




                try {
                    String o = "";
                    String[] split = o.split("\t");
                    List<String> list = new ArrayList<>();

                    String phone = PhoneNoUtils.getPhoneNoByRegx(split[12], "电信主叫号码");

                    String cTime = split[2];
                    String recevPhone = split[5];
                    String useTime = split[3];


                    try {
                        list.add(StringUtils.isBlank(split[1]) ? null : split[1]);  //通话类型
                        list.add(StringUtils.isBlank(split[2]) ? null : DateUtil.getCTimeFormat(cTime, "电信通话开始时间")); //通话开始时间
                        list.add(StringUtils.isBlank(split[3]) ? null : NumberUtil.getUseTimeFormat(useTime, "电信通话时间")); //通话时间s
                        list.add(StringUtils.isBlank(split[4]) ? null : split[4]); //主叫、被叫、其他
                        list.add(StringUtils.isBlank(split[5]) ? null : PhoneNoUtils.getPhoneNoByRegx(recevPhone, "电信被叫号码")); //被叫号码
                        list.add(StringUtils.isBlank(split[6]) ? null : split[6]); //通话地点
                        list.add(StringUtils.isBlank(split[7]) ? null : split[7]); //未使用
                        list.add(StringUtils.isBlank(split[8]) ? null : split[8]); //未使用
                        list.add(StringUtils.isBlank(split[9]) ? null : split[9]); //未使用
                        list.add(StringUtils.isBlank(split[10]) ? null : split[10]); //未使用
                        list.add(StringUtils.isBlank(split[11]) ? null : split[11]); //通话费用
                        list.add(StringUtils.isBlank(phone) ? null : phone.replaceAll(" ", "")); //主叫号码
                        list.add(StringUtils.isBlank(split[13]) ? null : split[13]); //未使用
                        list.add(StringUtils.isBlank(split[14]) ? null : DateUtil.timeStamp2Date(split[14], "电信通话入库时间")); //抓取时间,入库时间


                        String uuid = "";
                        if (StringUtils.isNotBlank(phone)) {
                            uuid = JdbcExecuters.queryExecute("select uuid from xyqb_user_i_user where phone_no = '" + phone + "'");
                        }

                        String sql = "INSERT IGNORE INTO comservice_i_telecom_call_info (uuid,tradeType,cTime,tradeTime,callWay,receiverPhone,tradeAddr,basePay,longPay,infoPay,otherPay,allPay,phone,iscm,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";

                        JdbcExecuters.batchUpdateExecute(SqlUtil.getExecuteSql(list, sql), o);
                    } catch (Exception e) {
                    }


                } catch (ArrayIndexOutOfBoundsException a) {

                } catch (Exception e) {
                    System.out.println("======电信位置异常======");
                }


        }

        System.out.println("=====================电信通话详单执行完毕");
    }

}
